/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class ResourceInputStream
extends InputStream {
    private Object handle;
    private int pos;
    private int size;

    private static String fixResourceName(String string) throws IOException {
        Vector vector = new Vector();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(47, n)) != -1) {
            if (n2 == n) {
                ++n;
                continue;
            }
            String string2 = string.substring(n, n2);
            n = n2 + 1;
            if (string2.equals(".")) continue;
            if (string2.equals("..")) {
                try {
                    vector.removeElementAt(vector.size() - 1);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IOException();
                }
            }
            vector.addElement(string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append((String)vector.elementAt(i));
            stringBuffer.append("/");
        }
        if (n < string.length()) {
            String string3 = string.substring(n);
            if (string3.endsWith(".class") && !".class".equals(string3)) {
                throw new IOException();
            }
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    public ResourceInputStream(String string) throws IOException {
        String string2 = ResourceInputStream.fixResourceName(string);
        this.handle = ResourceInputStream.open(string2);
        if (this.handle == null) {
            throw new IOException();
        }
        this.size = ResourceInputStream.size(this.handle);
        this.pos = 0;
    }

    public int read() throws IOException {
        int n = ResourceInputStream.read(this.handle);
        if (n != -1) {
            ++this.pos;
        }
        return n;
    }

    public synchronized void close() throws IOException {
        ResourceInputStream.close(this.handle);
        this.handle = null;
    }

    public int available() throws IOException {
        return this.size - this.pos;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.size) {
            return -1;
        }
        if (this.pos + n2 > this.size) {
            n2 = this.size - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        int n3 = ResourceInputStream.readBytes(this.handle, byArray, n, this.pos, n2);
        if (n3 != -1) {
            this.pos += n3;
        }
        return n3;
    }

    private static native Object open(String var0) throws IOException;

    private static native void close(Object var0) throws IOException;

    private static native int size(Object var0) throws IOException;

    private static native int read(Object var0) throws IOException;

    private static native int readBytes(Object var0, byte[] var1, int var2, int var3, int var4) throws IOException;
}

