/*
 * Decompiled with CFR 0.152.
 */
package com.jinke.io;

import com.jinke.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class FileInputStream
extends InputStream {
    protected int fp = 0;
    protected int pos = -1;

    protected native boolean open(byte[] var1) throws FileNotFoundException;

    protected native int available(int var1) throws IOException;

    protected native void close(int var1) throws IOException;

    protected native long skip(int var1, long var2) throws IOException;

    protected native int readBytes(int var1, byte[] var2, int var3, int var4) throws IOException;

    protected native int read(int var1) throws IOException;

    protected native int tellPosition(int var1) throws IOException;

    protected native int seekPosition(int var1, int var2) throws IOException;

    public FileInputStream() {
    }

    public FileInputStream(String string) throws FileNotFoundException, IOException {
        this();
        this.open(string);
    }

    public void open(String string) throws FileNotFoundException, IOException {
        try {
            if (this.fp != 0) {
                this.close(this.fp);
            }
            byte[] byArray = string.getBytes("UTF-8");
            this.open(byArray);
            if (this.fp == 0) {
                throw new FileNotFoundException();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public int available() throws IOException {
        if (this.fp == 0) {
            throw new IOException();
        }
        return this.available(this.fp);
    }

    public void close() throws IOException {
        if (this.fp != 0) {
            this.close(this.fp);
        }
        this.fp = 0;
    }

    public int read() throws IOException {
        if (this.fp == 0) {
            throw new IOException();
        }
        return this.read(this.fp);
    }

    public int read(byte[] byArray) throws IOException {
        if (this.fp == 0) {
            throw new IOException();
        }
        return this.readBytes(this.fp, byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.fp == 0) {
            throw new IOException();
        }
        return this.readBytes(this.fp, byArray, n, byArray.length);
    }

    public long skip(long l) throws IOException {
        if (this.fp == 0) {
            throw new IOException();
        }
        if (l < 0L) {
            throw new IOException();
        }
        return this.skip(this.fp, l);
    }

    protected void finalize() throws IOException {
        if (this.fp != 0) {
            this.close(this.fp);
        }
    }

    public synchronized void mark(int n) {
        try {
            this.pos = this.tellPosition(this.fp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void reset(int n) throws IOException {
        if (this.pos < 0) {
            return;
        }
        this.seekPosition(n, this.pos);
    }
}

