/*
 * Decompiled with CFR 0.152.
 */
package com.jinke.gui.image;

import java.io.IOException;
import java.io.InputStream;

public class ImageDecoder {
    public static final int NOTSUPPORT = -1;
    public static final int BMP = 0;
    public static final int JPG = 1;
    public static final int GIF = 2;
    public static final int PNG = 3;
    private int type = -1;
    private int width;
    private int height;
    private int level;
    public int pImage = 0;
    int[][] pixel = null;

    private native void decode(byte[] var1);

    private native void destroy(int var1);

    private native void getPixelMetrix(int var1, int[][] var2, int var3);

    private native void resample(int var1, int var2, int var3);

    public ImageDecoder(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        int n = inputStream.available();
        byte[] byArray = new byte[n];
        inputStream.read(byArray, 0, n);
        this.decode(byArray);
    }

    public int getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLevel() {
        return this.level;
    }

    public int[][] getPixelMetrix() {
        if (this.type < 0 || this.pImage == 0) {
            return null;
        }
        if (this.pixel == null) {
            this.pixel = new int[this.height][this.width];
            this.getPixelMetrix(this.pImage, this.pixel, this.type);
        }
        return this.pixel;
    }

    public void resample(int n, int n2) {
        if (this.pImage == 0) {
            return;
        }
        this.resample(this.pImage, n, n2);
        this.width = n;
        this.height = n2;
    }

    public void destroy() {
        if (this.pImage != 0) {
            this.destroy(this.pImage);
        }
        this.pImage = 0;
        this.pixel = null;
    }

    protected void finalize() {
        if (this.pImage != 0) {
            this.destroy();
        }
    }
}

