/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public strictfp final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;
    private static long negativeZeroFloatBits = Float.floatToIntBits(-0.0f);
    private static long negativeZeroDoubleBits = Double.doubleToLongBits(-0.0);

    private Math() {
    }

    public static native double sin(double var0);

    public static native double cos(double var0);

    public static native double tan(double var0);

    public static double toRadians(double d) {
        return d / 180.0 * Math.PI;
    }

    public static double toDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    public static native double sqrt(double var0);

    public static native double ceil(double var0);

    public static native double floor(double var0);

    public static int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static float abs(float f) {
        return f <= 0.0f ? 0.0f - f : f;
    }

    public static double abs(double d) {
        return d <= 0.0 ? 0.0 - d : d;
    }

    public static int max(int n, int n2) {
        return n >= n2 ? n : n2;
    }

    public static long max(long l, long l2) {
        return l >= l2 ? l : l2;
    }

    public static float max(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f && (long)Float.floatToIntBits(f) == negativeZeroFloatBits) {
            return f2;
        }
        return f >= f2 ? f : f2;
    }

    public static double max(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && Double.doubleToLongBits(d) == negativeZeroDoubleBits) {
            return d2;
        }
        return d >= d2 ? d : d2;
    }

    public static int min(int n, int n2) {
        return n <= n2 ? n : n2;
    }

    public static long min(long l, long l2) {
        return l <= l2 ? l : l2;
    }

    public static float min(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f && (long)Float.floatToIntBits(f2) == negativeZeroFloatBits) {
            return f2;
        }
        return f <= f2 ? f : f2;
    }

    public static double min(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && Double.doubleToLongBits(d2) == negativeZeroDoubleBits) {
            return d2;
        }
        return d <= d2 ? d : d2;
    }
}

