/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.sun.cldc.i18n.Helper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class OutputStreamWriter
extends Writer {
    private Writer out;

    public OutputStreamWriter(OutputStream outputStream) {
        this.out = Helper.getStreamWriter(outputStream);
    }

    public OutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.out = Helper.getStreamWriter(outputStream, string);
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    public void write(int n) throws IOException {
        this.ensureOpen();
        this.out.write(n);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.out.write(cArray, n, n2);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n < 0 || n > string.length() || n2 < 0 || n + n2 > string.length() || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.out.write(string, n, n2);
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.out.flush();
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }
}

