/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.util.j2me;

import java.util.Calendar;
import java.util.TimeZone;

public class CalendarImpl
extends Calendar {
    private static final int BC = 0;
    private static final int AD = 1;
    private static final int JAN_1_1_JULIAN_DAY = 1721426;
    private static final int EPOCH_JULIAN_DAY = 2440588;
    private static final int[] NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final long gregorianCutover = -12219292800000L;
    private static final int gregorianCutoverYear = 1582;
    static String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    static String[] days = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

    protected void computeFields() {
        int n;
        int n2 = this.getTimeZone().getRawOffset();
        long l = this.time + (long)n2;
        if (this.time > 0L && l < 0L && n2 > 0) {
            l = Long.MAX_VALUE;
        } else if (this.time < 0L && l > 0L && n2 < 0) {
            l = Long.MIN_VALUE;
        }
        this.timeToFields(l);
        long l2 = l / 86400000L;
        int n3 = (int)(l - l2 * 86400000L);
        if (n3 < 0) {
            n3 = (int)((long)n3 + 86400000L);
        }
        if ((long)(n3 += (n = this.getTimeZone().getOffset(1, this.fields[1], this.fields[2], this.fields[5], this.fields[7], n3) - n2)) >= 86400000L) {
            long l3 = l + (long)n;
            n3 = (int)((long)n3 - 86400000L);
            if (l > 0L && l3 < 0L && n > 0) {
                l3 = Long.MAX_VALUE;
            } else if (l < 0L && l3 > 0L && n < 0) {
                l3 = Long.MIN_VALUE;
            }
            this.timeToFields(l3);
        }
        this.fields[14] = n3 % 1000;
        this.fields[13] = (n3 /= 1000) % 60;
        this.fields[12] = (n3 /= 60) % 60;
        this.fields[11] = n3 /= 60;
        this.fields[9] = n3 / 12;
        this.fields[10] = n3 % 12;
    }

    private final void timeToFields(long l) {
        int n;
        boolean bl;
        int n2;
        int n3;
        int n4;
        long l2;
        if (l >= -12219292800000L) {
            l2 = CalendarImpl.millisToJulianDay(l) - 1721426L;
            int[] nArray = new int[1];
            n4 = CalendarImpl.floorDivide(l2, 146097, nArray);
            int n5 = CalendarImpl.floorDivide(nArray[0], 36524, nArray);
            int n6 = CalendarImpl.floorDivide(nArray[0], 1461, nArray);
            int n7 = CalendarImpl.floorDivide(nArray[0], 365, nArray);
            n3 = 400 * n4 + 100 * n5 + 4 * n6 + n7;
            n2 = nArray[0];
            if (n5 == 4 || n7 == 4) {
                n2 = 365;
            } else {
                ++n3;
            }
            bl = (n3 & 3) == 0 && (n3 % 100 != 0 || n3 % 400 == 0);
            this.fields[7] = (int)((l2 + 1L) % 7L);
        } else {
            l2 = CalendarImpl.millisToJulianDay(l) - 1721424L;
            n3 = (int)CalendarImpl.floorDivide(4L * l2 + 1464L, 1461L);
            long l3 = 365 * (n3 - 1) + CalendarImpl.floorDivide(n3 - 1, 4);
            n2 = (int)(l2 - l3);
            bl = (n3 & 3) == 0;
            this.fields[7] = (int)((l2 - 1L) % 7L);
        }
        int n8 = 0;
        int n9 = n = bl ? 60 : 59;
        if (n2 >= n) {
            n8 = bl ? 1 : 2;
        }
        int n10 = (12 * (n2 + n8) + 6) / 367;
        n4 = n2 - (bl ? LEAP_NUM_DAYS[n10] : NUM_DAYS[n10]) + 1;
        this.fields[7] = this.fields[7] + (this.fields[7] < 0 ? 8 : 1);
        this.fields[1] = n3;
        if (this.fields[1] < 1) {
            this.fields[1] = 1 - this.fields[1];
        }
        this.fields[2] = n10 + 0;
        this.fields[5] = n4;
    }

    public static String toString(Calendar calendar) {
        if (calendar == null) {
            return "Thu Jan 01 00:00:00 UTC 1970";
        }
        int n = calendar.get(7);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        int n7 = calendar.get(1);
        String string = Integer.toString(n7);
        TimeZone timeZone = calendar.getTimeZone();
        String string2 = timeZone.getID();
        if (string2 == null) {
            string2 = "";
        }
        StringBuffer stringBuffer = new StringBuffer(25 + string2.length() + string.length());
        stringBuffer.append(days[n - 1]).append(' ');
        stringBuffer.append(months[n2]).append(' ');
        CalendarImpl.appendTwoDigits(stringBuffer, n3).append(' ');
        CalendarImpl.appendTwoDigits(stringBuffer, n4).append(':');
        CalendarImpl.appendTwoDigits(stringBuffer, n5).append(':');
        CalendarImpl.appendTwoDigits(stringBuffer, n6).append(' ');
        if (string2.length() > 0) {
            stringBuffer.append(string2).append(' ');
        }
        CalendarImpl.appendFourDigits(stringBuffer, n7);
        return stringBuffer.toString();
    }

    public static String toISO8601String(Calendar calendar) {
        if (calendar == null) {
            return "0000 00 00 00 00 00 +0000";
        }
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(10);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        String string = Integer.toString(n);
        StringBuffer stringBuffer = new StringBuffer(25 + string.length());
        CalendarImpl.appendFourDigits(stringBuffer, n).append(' ');
        CalendarImpl.appendTwoDigits(stringBuffer, n2).append(' ');
        CalendarImpl.appendTwoDigits(stringBuffer, n3).append(' ');
        CalendarImpl.appendTwoDigits(stringBuffer, n4).append(' ');
        CalendarImpl.appendTwoDigits(stringBuffer, n6).append(' ');
        CalendarImpl.appendTwoDigits(stringBuffer, n7).append(' ');
        TimeZone timeZone = calendar.getTimeZone();
        int n8 = timeZone.getRawOffset() / 1000 / 60;
        if (n8 < 0) {
            n8 = Math.abs(n8);
            stringBuffer.append('-');
        } else {
            stringBuffer.append('+');
        }
        int n9 = n8 / 60;
        int n10 = n8 % 60;
        CalendarImpl.appendTwoDigits(stringBuffer, n9);
        CalendarImpl.appendTwoDigits(stringBuffer, n10);
        return stringBuffer.toString();
    }

    private static final StringBuffer appendFourDigits(StringBuffer stringBuffer, int n) {
        if (n >= 0 && n < 1000) {
            stringBuffer.append('0');
            if (n < 100) {
                stringBuffer.append('0');
            }
            if (n < 10) {
                stringBuffer.append('0');
            }
        }
        return stringBuffer.append(n);
    }

    private static final StringBuffer appendTwoDigits(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append('0');
        }
        return stringBuffer.append(n);
    }

    protected void computeTime() {
        this.correctTime();
        int n = this.fields[1];
        boolean bl = n >= 1582;
        long l = this.calculateJulianDay(bl, n);
        long l2 = CalendarImpl.julianDayToMillis(l);
        if (bl != l2 >= -12219292800000L && l != -106749550580L) {
            l = this.calculateJulianDay(!bl, n);
            l2 = CalendarImpl.julianDayToMillis(l);
        }
        int n2 = 0;
        n2 += this.fields[11];
        n2 *= 60;
        n2 += this.fields[12];
        n2 *= 60;
        n2 += this.fields[13];
        n2 *= 1000;
        int n3 = this.getTimeZone().getRawOffset();
        int[] nArray = new int[1];
        CalendarImpl.floorDivide(l2 += (long)(n2 += this.fields[14]), 86400000, nArray);
        int n4 = CalendarImpl.julianDayToDayOfWeek(l);
        int n5 = this.getTimeZone().getOffset(1, this.fields[1], this.fields[2], this.fields[5], n4, nArray[0]) - n3;
        this.time = l2 - (long)n3 - (long)n5;
    }

    private final long calculateJulianDay(boolean bl, int n) {
        int n2 = 0;
        long l = 0L;
        n2 = this.fields[2] - 0;
        if (n2 < 0 || n2 > 11) {
            int[] nArray = new int[1];
            n += CalendarImpl.floorDivide(n2, 12, nArray);
            n2 = nArray[0];
        }
        boolean bl2 = n % 4 == 0;
        long l2 = 365L * (long)(n - 1) + (long)CalendarImpl.floorDivide(n - 1, 4) + 1721423L;
        if (bl) {
            bl2 = bl2 && (n % 100 != 0 || n % 400 == 0);
            l2 += (long)(CalendarImpl.floorDivide(n - 1, 400) - CalendarImpl.floorDivide(n - 1, 100) + 2);
        }
        l2 += bl2 ? (long)LEAP_NUM_DAYS[n2] : (long)NUM_DAYS[n2];
        return l2 += (long)this.fields[5];
    }

    private void correctTime() {
        int n;
        if (this.isSet[11]) {
            int n2;
            this.fields[11] = n2 = this.fields[11] % 24;
            this.fields[9] = n2 < 12 ? 0 : 1;
            this.isSet[11] = false;
            return;
        }
        if (this.isSet[9]) {
            if (this.fields[9] != 0 && this.fields[9] != 1) {
                n = this.fields[11];
                this.fields[9] = n < 12 ? 0 : 1;
            }
            this.isSet[9] = false;
        }
        if (this.isSet[10]) {
            n = this.fields[10];
            if (n > 12) {
                this.fields[11] = n % 12 + 12;
                this.fields[10] = n % 12;
                this.fields[9] = 1;
            } else {
                this.fields[11] = this.fields[9] == 1 ? n + 12 : n;
            }
            this.isSet[10] = false;
        }
    }

    private static final long millisToJulianDay(long l) {
        return 2440588L + CalendarImpl.floorDivide(l, 86400000L);
    }

    private static final long julianDayToMillis(long l) {
        return (l - 2440588L) * 86400000L;
    }

    private static final int julianDayToDayOfWeek(long l) {
        int n;
        return n + ((n = (int)((l + 1L) % 7L)) < 0 ? 8 : 1);
    }

    private static final long floorDivide(long l, long l2) {
        return l >= 0L ? l / l2 : (l + 1L) / l2 - 1L;
    }

    private static final int floorDivide(int n, int n2) {
        return n >= 0 ? n / n2 : (n + 1) / n2 - 1;
    }

    private static final int floorDivide(int n, int n2, int[] nArray) {
        if (n >= 0) {
            nArray[0] = n % n2;
            return n / n2;
        }
        int n3 = (n + 1) / n2 - 1;
        nArray[0] = n - n3 * n2;
        return n3;
    }

    private static final int floorDivide(long l, int n, int[] nArray) {
        if (l >= 0L) {
            nArray[0] = (int)(l % (long)n);
            return (int)(l / (long)n);
        }
        int n2 = (int)((l + 1L) / (long)n - 1L);
        nArray[0] = (int)(l - (long)(n2 * n));
        return n2;
    }
}

