/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double {
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = Double.longBitsToDouble(1L);
    private double value;

    public static String toString(double d) {
        return new FloatingDecimal(d).toJavaFormatString();
    }

    public static Double valueOf(String string) throws NumberFormatException {
        return new Double(FloatingDecimal.readJavaFormatString(string).doubleValue());
    }

    public static double parseDouble(String string) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(string).doubleValue();
    }

    public static boolean isNaN(double d) {
        return d != d;
    }

    public static boolean isInfinite(double d) {
        return d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY;
    }

    public Double(double d) {
        this.value = d;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        return object instanceof Double && Double.doubleToLongBits(((Double)object).value) == Double.doubleToLongBits(this.value);
    }

    public static native long doubleToLongBits(double var0);

    public static native double longBitsToDouble(long var0);
}

