/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class PrintStream
extends OutputStream {
    private boolean trouble = false;
    private OutputStreamWriter charOut;
    private OutputStream byteOut;
    private boolean closing = false;

    public PrintStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("Null output stream");
        }
        this.byteOut = outputStream;
        this.charOut = new OutputStreamWriter(outputStream);
    }

    private void ensureOpen() throws IOException {
        if (this.charOut == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PrintStream printStream = this;
        synchronized (printStream) {
            try {
                this.ensureOpen();
                this.charOut.flush();
            }
            catch (IOException iOException) {
                this.trouble = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PrintStream printStream = this;
        synchronized (printStream) {
            if (!this.closing) {
                this.closing = true;
                try {
                    this.charOut.close();
                }
                catch (IOException iOException) {
                    this.trouble = true;
                }
                this.charOut = null;
                this.byteOut = null;
            }
        }
    }

    public boolean checkError() {
        if (this.charOut != null) {
            this.flush();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.byteOut.write(n);
            }
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.byteOut.write(byArray, n, n2);
            }
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(char[] cArray) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.charOut.write(cArray);
            }
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String string) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.charOut.write(string);
            }
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.charOut.write(10);
            }
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int n) {
        this.write(String.valueOf(n));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        this.write(cArray);
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bl) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(bl);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(c);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int n) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(n);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(l);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(f);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(d);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(cArray);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(string);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(object);
            this.newLine();
        }
    }
}

