/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends OutputStream
implements DataOutput {
    protected OutputStream out;

    public DataOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeShort(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeChar(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeInt(int n) throws IOException {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)(l >>> 0) & 0xFF);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.write(c >>> 8 & 0xFF);
            this.write(c >>> 0 & 0xFF);
        }
    }

    public final void writeUTF(String string) throws IOException {
        DataOutputStream.writeUTF(string, this);
    }

    public static final int writeUTF(String string, DataOutput dataOutput) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        int n3 = 0;
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] byArray = new byte[n2 + 2];
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 0 & 0xFF);
        for (int i = 0; i < n; ++i) {
            c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        dataOutput.write(byArray);
        return n2 + 2;
    }
}

