/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float {
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    private float value;

    public static String toString(float f) {
        return new FloatingDecimal(f).toJavaFormatString();
    }

    public static Float valueOf(String string) throws NumberFormatException {
        return new Float(FloatingDecimal.readJavaFormatString(string).floatValue());
    }

    public static float parseFloat(String string) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(string).floatValue();
    }

    public static boolean isNaN(float f) {
        return f != f;
    }

    public static boolean isInfinite(float f) {
        return f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY;
    }

    public Float(float f) {
        this.value = f;
    }

    public Float(double d) {
        this.value = (float)d;
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object object) {
        return object instanceof Float && Float.floatToIntBits(((Float)object).value) == Float.floatToIntBits(this.value);
    }

    public static native int floatToIntBits(float var0);

    public static native float intBitsToFloat(int var0);
}

