/*
 * Decompiled with CFR 0.152.
 */
package com.jinke.gui;

import com.jinke.gui.Graphics;
import com.jinke.gui.Rectangle;
import com.jinke.gui.event.ErrorListener;
import com.jinke.gui.event.EventPump;
import com.jinke.gui.event.KeyListener;
import com.jinke.gui.event.TimerListener;
import com.jinke.gui.event.WindowListener;

public class Window {
    private boolean invalidate = false;
    private int windowID;
    protected Graphics gc;
    private ErrorListener errorListener = null;
    private WindowListener windowListener = null;
    private KeyListener keyListener = null;
    private TimerListener timerListener = null;
    public Thread idle = null;

    public static native void flush();

    public static native void blockFlush(int var0, int var1, int var2, int var3);

    private native boolean createGUI();

    private native int createWindow(int var1, int var2, int var3, int var4);

    private native void setVisible(int var1, boolean var2);

    private native void setSize(int var1, int var2, int var3);

    private native void setLocation(int var1, int var2, int var3);

    private native boolean isVisible(int var1);

    private native void addEventMask(int var1, int var2);

    private native void removeEventMask(int var1, int var2);

    private native void destroyGUI();

    private native void destroyWindow();

    public Window(int n, int n2, int n3, int n4) {
        if (this.createGUI()) {
            this.windowID = this.createWindow(n, n2, n3, n4);
        }
        if (this.windowID != 0) {
            this.invalidate = true;
        }
        if (this.invalidate) {
            this.gc = new Graphics(this);
        } else {
            System.out.println("Error");
        }
    }

    private int createWindow(Rectangle rectangle) {
        return this.createWindow(rectangle.top, rectangle.left, rectangle.width, rectangle.height);
    }

    public void closeWindow() {
        this.destroyWindow();
        this.destroyGUI();
        System.exit(0);
    }

    public int getWindowID() {
        return this.windowID;
    }

    public Graphics getGraphics() {
        return this.gc;
    }

    public synchronized void setVisible(boolean bl) {
        this.setVisible(this.windowID, bl);
    }

    public synchronized void setSize(int n, int n2) {
        this.setSize(this.windowID, n, n2);
    }

    public synchronized void setLocation(int n, int n2) {
        this.setLocation(this.windowID, n, n2);
    }

    public synchronized boolean isVisible() {
        return this.isVisible(this.windowID);
    }

    public synchronized void beginUIThread() {
        new EventPump(this).start();
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyListener = keyListener;
        this.addEventMask(this.windowID, 2);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.keyListener = null;
        this.removeEventMask(this.windowID, 2);
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public void addWindowListener(WindowListener windowListener) {
        this.windowListener = windowListener;
        this.addEventMask(this.windowID, 1);
    }

    public void removeWindowListener() {
        this.windowListener = null;
        this.removeEventMask(this.windowID, 1);
    }

    public WindowListener getWindowListener() {
        return this.windowListener;
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
        this.addEventMask(this.windowID, 0);
    }

    public void removeErrorListener() {
        this.errorListener = null;
        this.removeEventMask(this.windowID, 0);
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void addTimerListener(TimerListener timerListener) {
        this.timerListener = timerListener;
    }

    public void removeTimerListener() {
        this.timerListener = null;
    }

    public TimerListener getTimerListener() {
        return this.timerListener;
    }

    public void invokerLater(Runnable runnable) {
        this.idle = null;
        this.idle = new Thread(runnable);
        this.idle.start();
    }

    protected void finalize() {
        this.destroyWindow();
        this.destroyGUI();
    }
}

