/*
 * Decompiled with CFR 0.152.
 */
package com.jinke.gui.event;

import com.jinke.gui.Window;
import com.jinke.gui.event.DBusEvent;
import com.jinke.gui.event.DBusListener;
import com.jinke.gui.event.ErrorEvent;
import com.jinke.gui.event.ErrorListener;
import com.jinke.gui.event.KeyEvent;
import com.jinke.gui.event.KeyListener;
import com.jinke.gui.event.MouseEvent;
import com.jinke.gui.event.MouseListener;
import com.jinke.gui.event.TimerListener;
import com.jinke.gui.event.WindowEvent;
import com.jinke.gui.event.WindowListener;

public class EventPump
extends Thread {
    private Window w;
    private KeyEvent keyEvent = new KeyEvent();
    private WindowEvent windowEvent = new WindowEvent();
    private ErrorEvent errorEvent = new ErrorEvent();
    private MouseEvent mouseEvent = new MouseEvent();
    private DBusEvent dbusEvent = new DBusEvent();

    private native int getNextEvent();

    private native void drainEvent();

    public EventPump(Window window) {
        this.w = window;
    }

    public void run() {
        ErrorListener errorListener = null;
        WindowListener windowListener = null;
        KeyListener keyListener = null;
        TimerListener timerListener = null;
        MouseListener mouseListener = null;
        DBusListener dBusListener = null;
        int n = 0;
        if (this.w.getDBusListener() != null) {
            this.dbusEvent.dbusInitial();
        }
        while (true) {
            int n2 = this.getNextEvent();
            this.drainEvent();
            try {
                if (timerListener != this.w.getTimerListener()) {
                    n = 0;
                }
                if ((timerListener = this.w.getTimerListener()) != null) {
                    if (n == timerListener.getInterval() / 100 + 1) {
                        try {
                            timerListener.onTimer();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        n = 0;
                    } else {
                        ++n;
                    }
                } else {
                    n = 0;
                }
                if (n2 == 0) {
                    EventPump.sleep(100L);
                    continue;
                }
                switch (n2) {
                    case -1: {
                        errorListener = this.w.getErrorListener();
                        if (errorListener == null) break;
                        errorListener.handleError(this.errorEvent);
                        break;
                    }
                    case 1: {
                        windowListener = this.w.getWindowListener();
                        if (windowListener == null) break;
                        windowListener.exposure(this.windowEvent);
                        break;
                    }
                    case 8: {
                        keyListener = this.w.getKeyListener();
                        if (keyListener == null) break;
                        keyListener.keyPressed(this.keyEvent);
                        break;
                    }
                    case 9: {
                        keyListener = this.w.getKeyListener();
                        if (keyListener == null) break;
                        keyListener.keyReleased(this.keyEvent);
                        break;
                    }
                    case 256: {
                        windowListener = this.w.getWindowListener();
                        if (windowListener == null) break;
                        windowListener.refresh();
                        break;
                    }
                    case 4: {
                        mouseListener = this.w.getMouseListener();
                        if (mouseListener == null) break;
                        mouseListener.mouseEntered(this.mouseEvent);
                        break;
                    }
                    case 5: {
                        mouseListener = this.w.getMouseListener();
                        if (mouseListener == null) break;
                        mouseListener.mouseExited(this.mouseEvent);
                        break;
                    }
                    case 7: {
                        mouseListener = this.w.getMouseListener();
                        if (mouseListener == null) break;
                        mouseListener.mouseMoved(this.mouseEvent);
                        break;
                    }
                    case 3: {
                        mouseListener = this.w.getMouseListener();
                        if (mouseListener == null) break;
                        mouseListener.mouseReleased(this.mouseEvent);
                        break;
                    }
                    case 2: {
                        mouseListener = this.w.getMouseListener();
                        if (mouseListener == null) break;
                        mouseListener.mousePressed(this.mouseEvent);
                        break;
                    }
                    case 12: {
                        dBusListener = this.w.getDBusListener();
                        if (dBusListener == null) break;
                        dBusListener.dbusEventHandler(this.dbusEvent);
                        break;
                    }
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println("EventPump:" + exception);
                continue;
            }
            break;
        }
    }
}

