/*
 * Decompiled with CFR 0.152.
 */
package com.jinke.gui;

import com.jinke.gui.Image;
import com.jinke.gui.image.ImageDecoder;
import java.io.UnsupportedEncodingException;

public class BufferedImage {
    int buf;
    BufferedFont f = null;
    int color;
    int width;
    int height;
    public static final byte[] mask1 = new byte[]{-64, 57, 12, 3};

    protected native int getBuffer(int var1, int var2);

    public BufferedImage(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.buf = this.getBuffer(n, n2);
    }

    public native void clear(int var1, int var2, int var3);

    public void clear() {
        if (this.buf == 0) {
            return;
        }
        this.clear(this.buf, this.width, this.height);
    }

    public int getBuffer() {
        return this.buf;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setFont(BufferedFont bufferedFont) {
        this.f = bufferedFont;
    }

    public BufferedFont getFont() {
        return this.f;
    }

    public native void drawChars(int var1, int var2, char[] var3, int var4, int var5, int var6, int var7, int var8);

    public void drawString(String string, int n, int n2) {
        this.drawChars(string.toCharArray(), n, n2);
    }

    public void drawChars(char[] cArray, int n, int n2) {
        if (this.buf == 0) {
            return;
        }
        if (this.f == null) {
            return;
        }
        if (this.f.ft == 0) {
            return;
        }
        this.drawChars(this.f.ft, this.buf, cArray, n, n2, this.getWidth(), this.getHeight(), this.f.size);
    }

    public native void drawImage(int var1, int var2, int var3, int var4, int var5, int var6);

    public void drawImage(Image image, int n, int n2) {
        ImageDecoder imageDecoder = image.getDecoder();
        if (imageDecoder == null) {
            return;
        }
        if (imageDecoder.pImage == 0) {
            return;
        }
        if (this.buf == 0) {
            return;
        }
        this.drawImage(this.buf, imageDecoder.pImage, n, n2, this.width, this.height);
    }

    public void setColor(int n) {
        this.color = n;
    }

    public int getColor() {
        return this.color;
    }

    public native void fillRect(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public void fillRect(int n, int n2, int n3, int n4) {
        if (this.buf == 0) {
            return;
        }
        this.fillRect(this.buf, n, n2, n3, n4, this.color, this.width, this.height);
    }

    protected native void drawPoint(int var1, int var2, int var3, int var4, int var5, int var6);

    public void drawPoint(int n, int n2) {
        if (this.buf == 0) {
            return;
        }
        this.drawPoint(this.buf, n, n2, this.width, this.height, this.color);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        for (n6 = n; n6 <= n + n3 + 1; ++n6) {
            this.drawPoint(n6, n2);
        }
        for (n6 = n; n6 <= n + n3 + 1; ++n6) {
            this.drawPoint(n6, n2 + n4 + 1);
        }
        for (n5 = n2; n5 <= n2 + n4 + 1; ++n5) {
            this.drawPoint(n, n5);
        }
        for (n5 = n2; n5 <= n2 + n4 + 1; ++n5) {
            this.drawPoint(n + n3 + 1, n5);
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        int n5 = n2 - n4;
        int n6 = n3 - n;
        int n7 = 2 * n5 + n6;
        int n8 = 2 * n5;
        int n9 = 2 * (n5 + n6);
        int n10 = n;
        int n11 = n2;
        this.drawPoint(n10, n11);
        while (n10 < n3) {
            if (n7 < 0) {
                ++n10;
                ++n11;
                n7 += n9;
            } else {
                ++n10;
                n7 += n8;
            }
            this.drawPoint(n10, n11);
        }
    }

    public void circle(int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        int n5 = n3;
        int n6 = 2 * (1 - n3);
        while (n5 >= 0) {
            if (!bl) {
                this.drawPoint(n + n4, n2 + n5);
                this.drawPoint(n - n4, n2 + n5);
                this.drawPoint(n - n4, n2 - n5);
                this.drawPoint(n + n4, n2 - n5);
            } else {
                this.drawLine(n + n4, n2 + n5, n + n4, n2 - n5);
                this.drawLine(n - n4, n2 + n5, n - n4, n2 - n5);
            }
            int n7 = n6 < 0 ? (2 * (n6 + n5) - 1 < 0 ? 1 : 2) : (n6 > 0 ? (2 * (n6 - n4) - 1 <= 0 ? 2 : 3) : 2);
            switch (n7) {
                case 1: {
                    n6 += 2 * ++n4 + 1;
                    break;
                }
                case 2: {
                    n6 += 2 * (++n4 - --n5 + 1);
                    break;
                }
                case 3: {
                    n6 += -2 * --n5 + 1;
                }
            }
        }
    }

    public native void destroy(int var1);

    public void destroy() {
        if (this.buf == 0) {
            return;
        }
        this.destroy(this.buf);
        this.buf = 0;
    }

    protected void finalize() {
        this.destroy();
    }

    public static class BufferedFont {
        public int ft = 0;
        protected String fontname;
        protected int size;

        protected native void initial();

        protected native int createFont(byte[] var1);

        protected native void destroy(int var1);

        protected native void setSize(int var1, int var2);

        protected native int getCharsWidth(int var1, char[] var2, int var3);

        public BufferedFont(String string) {
            this.initial();
            this.fontname = string;
            try {
                this.ft = this.createFont(string.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }

        public void setSize(int n) {
            if (this.ft == 0) {
                return;
            }
            this.size = n;
            this.setSize(this.ft, this.size);
        }

        public int getSize() {
            return this.size;
        }

        public int getStringWidth(String string) {
            if (this.ft == 0) {
                return 0;
            }
            boolean bl = false;
            char[] cArray = string.toCharArray();
            return this.getCharsWidth(this.ft, cArray, this.size);
        }

        public String getName() {
            return this.fontname;
        }

        public static native void clearBuffer();

        public void destroy() {
            if (this.ft == 0) {
                return;
            }
            this.destroy(this.ft);
            this.ft = 0;
        }

        protected void finalize() {
            this.destroy();
        }
    }
}

