/*
 * Decompiled with CFR 0.152.
 */
package com.jinke.gui;

import java.io.UnsupportedEncodingException;

public class Font {
    public static final int NONE = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    private int fontID;

    public native int createFont(byte[] var1, int var2);

    public native void destoryFont(int var1);

    public native int getSize(int var1);

    public native int getBaseLine(int var1);

    public native int getDescent(int var1);

    public native void setSize(int var1, short var2);

    public native void setRotation(int var1, short var2);

    public native void setAttribute(int var1, int var2);

    public native int getStringWidth(int var1, String var2);

    public native int setInvert(int var1, boolean var2);

    public Font(int n) {
        this.fontID = n;
    }

    public Font(String string, int n, int n2) {
        if (string == null) {
            this.fontID = 0;
        } else {
            try {
                this.fontID = this.createFont(string.getBytes("UTF-8"), n);
                this.setAttribute(n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
    }

    public int getFontID() {
        return this.fontID;
    }

    public int getSize() {
        return this.getSize(this.fontID);
    }

    public void setSize(short s) {
        this.setSize(this.fontID, s);
    }

    public void setRotation(short s) {
        this.setRotation(this.fontID, s);
    }

    public void setAttribute(int n) {
        this.setAttribute(this.fontID, n);
    }

    public void destroy() {
        if (this.fontID != 0) {
            this.destoryFont(this.fontID);
        }
        this.fontID = 0;
    }

    protected void finalize() {
        if (this.fontID != 0) {
            this.destoryFont(this.fontID);
        }
    }

    public int getStringWidth(String string) {
        return this.getStringWidth(this.fontID, string);
    }

    public int getBaseLine() {
        return this.getBaseLine(this.fontID);
    }

    public int getDescent() {
        return this.getDescent(this.fontID);
    }

    public void setInvert(boolean bl) {
        this.setInvert(this.fontID, bl);
    }
}

