import com.jinke.gui.Window;
import com.jinke.gui.Font;
import com.jinke.gui.Graphics;
import com.jinke.gui.Color;
import com.jinke.gui.event.KeyListener;
import com.jinke.gui.event.KeyEvent;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;


/**
 * @author plyr0 <plyr00@gmail.com>
 */
public class PropJink extends Window 
  implements KeyListener, Runnable {

    int yoffset =0;
	int xoffset =5;
	
	public static void main(String args[]) {
		new PropJink();
	}
    
	public PropJink() {
        super(0, 0, 600, 800);
		setVisible(true);
		addKeyListener(this);
		invokerLater(this);
		beginUIThread();	
    }
	
	public void keyPressed(KeyEvent ke) {
		//f.destroy();
		finalize();
		System.gc();
		System.exit(0);
	}

    public void keyReleased(KeyEvent ke){}

    public void run() {
		Font f = new Font("Arial", 14, 0);
		//f.setInvert(false);
		yoffset = f.getBaseLine()+5;
		gc.setFont(f);
		gc.clear(0, 0, 600, 800);
		
        Enumeration labels = parseLines("MIDP").elements();
        String lb = new String("");
		String text = new String("");
		
        while (labels.hasMoreElements()){
            lb = (String)labels.nextElement();
            text = lb + "=" + System.getProperty(lb);;
            gc.drawString( text, xoffset, yoffset);
			//blockFlush(5, yoffset-f.getBaseLine(), f.getStringWidth(text)+5, f.getSize() + f.getDescent() );
			fastBlockFlush(xoffset, yoffset-f.getBaseLine(), f.getStringWidth(text)+5, f.getSize() );// + f.getDescent() );
			//flush();
			yoffset+=14;
			if (yoffset>=800) {
				yoffset=0;
				xoffset=300;
			}
        }
    }

    /**
     * Read lines terminated CR, LF, both. Ignores lines with only one
     * or more CRs LFs. Every line appended as Vector's element, without CR/LF.
     *
     * @param res
     * @return Vector with lines
     */
    public Vector parseLines(String res) {
        InputStreamReader mInStream = new InputStreamReader(this.getClass().getResourceAsStream(res));
        Vector retval= new Vector();
        int c;
        String s = new String("");
        boolean hasChars = false;
        try {
            while ((c = mInStream.read()) != -1) {
                if (c == (int) '\n' || c == (int) '\r') {
                    if (hasChars) {
                        retval.addElement(s);
                        s = "";
                        hasChars = false;
                    }
                } else {
                    s += (char) c;
                    hasChars = true;
                }
            }
            if (hasChars) {
                retval.addElement(s);
            }
            mInStream.close();
            retval.trimToSize();
            return retval;

        } catch (IOException ex) {
            ex.printStackTrace();
            retval = new Vector(1, 1);
            retval.addElement("Error: "+ex.getMessage());
            return retval;
        }
    }



}


