/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class DataInputStream
extends InputStream
implements DataInput {
    protected InputStream in;

    public DataInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public final int read(byte[] byArray) throws IOException {
        return this.in.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = this.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    public final int skipBytes(int n) throws IOException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n && (n3 = (int)this.skip(n - n2)) > 0; n2 += n3) {
        }
        return n2;
    }

    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public final char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        char[] cArray = new char[n];
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        dataInput.readFully(byArray, 0, n);
        block5: while (n2 < n) {
            int n4 = byArray[n2] & 0xFF;
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n3++] = (char)n4;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0x1F) << 6 | by & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 2];
                    byte by2 = byArray[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n3);
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void mark(int n) {
        this.in.mark(n);
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }
}

