/*
 * Decompiled with CFR 0.152.
 */
package com.jinke.io;

import com.jinke.io.FileNotFoundException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class RandomAccessFile
implements DataOutput,
DataInput {
    private short fd = (short)-1;
    private static final int O_RDONLY = 1;
    private static final int O_RDWR = 2;
    private static final int O_SYNC = 4;

    private native void open(byte[] var1, int var2) throws FileNotFoundException;

    public native void close(int var1);

    public native long getFilePointer(int var1);

    public native long length(int var1);

    public native void seek(int var1, long var2);

    public native int read(short var1) throws IOException;

    public native int readBytes(short var1, byte[] var2, int var3, int var4) throws IOException;

    public native void write(short var1, int var2) throws IOException;

    public native void writeBytes(short var1, byte[] var2, int var3, int var4) throws IOException;

    public RandomAccessFile(String string, String string2) throws FileNotFoundException, IOException {
        int n = -1;
        if (string2.equals("r")) {
            n = 1;
        } else if (string2.startsWith("rw")) {
            n = 2;
            if (string2.length() > 2) {
                n = string2.equals("rws") ? (n |= 4) : -1;
            }
        }
        if (n < 0) {
            throw new IllegalArgumentException("Illegal mode \"" + string2 + "\" must be one of " + "\"r\", \"rw\", \"rws\",");
        }
        this.open(string.getBytes("UTF-8"), n);
    }

    public void close() throws IOException {
        if (this.fd == -1) {
            throw new IOException();
        }
        this.close(this.fd);
    }

    public long getFilePointer() throws IOException {
        if (this.fd == -1) {
            throw new IOException("Error In getFilePointer");
        }
        return this.getFilePointer(this.fd);
    }

    public long length() throws IOException {
        if (this.fd == -1) {
            throw new IOException();
        }
        return this.length(this.fd);
    }

    public void seek(long l) throws IOException {
        if (this.fd == -1) {
            throw new IOException();
        }
        this.seek(this.fd, l);
    }

    public int skipBytes(int n) throws IOException {
        long l;
        if (n <= 0) {
            return 0;
        }
        long l2 = this.getFilePointer();
        long l3 = l2 + (long)n;
        if (l3 > (l = this.length())) {
            l3 = l;
        }
        this.seek(l3);
        return (int)(l3 - l2);
    }

    public int read() throws IOException {
        if (this.fd != -1) {
            return this.read(this.fd);
        }
        return -1;
    }

    public int readBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.fd == -1) {
            throw new IOException();
        }
        if (byArray.length <= n || n2 < 0 || n < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.readBytes(this.fd, byArray, n, n2);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readBytes(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.read(byArray, n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Here!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        block4: while (!bl) {
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    continue block4;
                }
                case 13: {
                    bl = true;
                    long l = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(l);
                    continue block4;
                }
            }
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public void write(int n) throws IOException {
        if (this.fd == -1) {
            throw new IOException();
        }
        this.write(this.fd, n);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.fd == -1) {
            throw new IOException();
        }
        this.writeBytes(this.fd, byArray, n, n2);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.write(byArray, n, n2);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeChar(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 2 * n;
        byte[] byArray = new byte[n2];
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            byArray[n3++] = (byte)(cArray[i] >>> 8);
            byArray[n3++] = (byte)(cArray[i] >>> 0);
        }
        this.writeBytes(byArray, 0, n2);
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeInt(int n) throws IOException {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)(l >>> 0) & 0xFF);
    }

    public void writeShort(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public void writeUTF(String string) throws IOException {
        DataOutputStream.writeUTF(string, this);
    }

    public static void main(String[] stringArray) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile("/root/test1.txt", "rw");
            String string = new String("Hello World");
            randomAccessFile.writeChars(string);
            System.out.println("write:" + string);
            randomAccessFile.seek(0L);
            int n = 0;
            while ((long)n < randomAccessFile.length() / 2L) {
                System.out.print(randomAccessFile.readChar());
                ++n;
            }
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("err");
        }
    }
}

