/*
 * Decompiled with CFR 0.152.
 */
package com.jinke.gui;

import com.jinke.gui.BufferedImage;
import com.jinke.gui.Color;
import com.jinke.gui.Font;
import com.jinke.gui.Image;
import com.jinke.gui.Window;
import com.jinke.gui.image.ImageDecoder;
import java.io.UnsupportedEncodingException;

public class Graphics {
    private int windowID;
    private int gcID;
    private Color fc;
    private Color bc;
    private Font f;

    private native int createGC();

    private native void destroyGC(int var1);

    private native void drawPoint(int var1, int var2, int var3, int var4);

    private native void drawLine(int var1, int var2, int var3, int var4, int var5, int var6);

    private native void drawRect(int var1, int var2, int var3, int var4, int var5, int var6);

    private native void drawEllipse(int var1, int var2, int var3, int var4, int var5, int var6);

    private native void drawString(int var1, int var2, byte[] var3, int var4, int var5);

    private native void drawStringArea(int var1, int var2, byte[] var3, int var4, int var5, int var6);

    private native void drawChar(int var1, int var2, char var3, int var4, int var5);

    private native void fillRect(int var1, int var2, int var3, int var4, int var5, int var6);

    private native void fillEllipse(int var1, int var2, int var3, int var4, int var5, int var6);

    private native void drawImage(int var1, int var2, int[][] var3, int var4, int var5);

    private native void drawBufferedImage(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native void drawArc(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private native void clear(int var1, int var2, int var3, int var4, int var5, int var6);

    private native void setForeColor(int var1);

    private native void setBackColor(int var1);

    private native void setFont(int var1);

    private native int getForeColor(int var1);

    private native int getBackColor(int var1);

    private native int getFont(int var1);

    public Graphics(Window window) {
        this.windowID = window.getWindowID();
        this.gcID = this.createGC();
        this.defailtSetup();
    }

    private void defailtSetup() {
        this.setForeColor(Color.BLACK);
        this.setBackColor(Color.WHITE);
        this.f = null;
    }

    public void drawPoint(int n, int n2) {
        this.drawPoint(this.windowID, this.gcID, n, n2);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.drawLine(this.windowID, this.gcID, n, n2, n3, n4);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.drawRect(this.windowID, this.gcID, n, n2, n3, n4);
    }

    public void drawEllipse(int n, int n2, int n3, int n4) {
        this.drawEllipse(this.windowID, this.gcID, n, n2, n3, n4);
    }

    public void drawString(String string, int n, int n2) {
        try {
            this.drawString(this.windowID, this.gcID, string.getBytes("UTF-8"), n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
    }

    public void drawString(String string, int n, int n2, int n3) {
        try {
            this.drawStringArea(this.windowID, this.gcID, string.getBytes("UTF-8"), n, n2, n3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
    }

    public void drawChar(char c, int n, int n2) {
        this.drawChar(this.windowID, this.gcID, c, n, n2);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.fillRect(this.windowID, this.gcID, n, n2, n3, n4);
    }

    public void fillEllipse(int n, int n2, int n3, int n4) {
        this.fillEllipse(this.windowID, this.gcID, n, n2, n3, n4);
    }

    public void setForeColor(Color color) {
        if (color != null) {
            this.fc = color;
            this.setForeColor(this.gcID);
        }
    }

    public void setBackColor(Color color) {
        if (color != null) {
            this.bc = color;
            this.setBackColor(this.gcID);
        }
    }

    public void setFont(Font font) {
        if (font != null) {
            this.f = font;
            this.setFont(this.gcID);
        }
    }

    public Color getForeColor() {
        return this.fc;
    }

    public Color getBackColor() {
        return this.bc;
    }

    public Font getFont() {
        return this.f;
    }

    protected void finalize() {
        this.destroy();
    }

    public void drawImage(Image image, int n, int n2) {
        ImageDecoder imageDecoder = image.getDecoder();
        if (imageDecoder == null) {
            return;
        }
        if (imageDecoder.pImage == 0) {
            return;
        }
        this.drawImage(this.windowID, this.gcID, imageDecoder.getPixelMetrix(), n, n2);
    }

    public void drawBufferedImage(BufferedImage bufferedImage, int n, int n2) {
        this.drawBufferedImage(this.windowID, this.gcID, bufferedImage.getBuffer(), n, n2, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public void drawStrenchImage(Image image, int n, int n2, int n3, int n4) {
        ImageDecoder imageDecoder = image.getDecoder();
        if (imageDecoder == null) {
            return;
        }
        if (imageDecoder.pImage == 0) {
            return;
        }
        imageDecoder.resample(n3, n4);
        this.drawImage(this.windowID, this.gcID, imageDecoder.getPixelMetrix(), n, n2);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawArc(this.windowID, this.gcID, n, n2, n3, n4, n5, n6);
    }

    public void clear(int n, int n2, int n3, int n4) {
        this.clear(this.windowID, this.gcID, n, n2, n3, n4);
    }

    public void destroy() {
        if (this.gcID != 0) {
            this.destroyGC(this.gcID);
        }
    }
}

