/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.sun.cldc.i18n.Helper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InputStreamReader
extends Reader {
    private Reader in;

    public InputStreamReader(InputStream inputStream) {
        this.in = Helper.getStreamReader(inputStream);
    }

    public InputStreamReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this.in = Helper.getStreamReader(inputStream, string);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public int read() throws IOException {
        this.ensureOpen();
        return this.in.read();
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        return this.in.read(cArray, n, n2);
    }

    public long skip(long l) throws IOException {
        this.ensureOpen();
        return this.in.skip(l);
    }

    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.in.ready();
    }

    public boolean markSupported() {
        if (this.in == null) {
            return false;
        }
        return this.in.markSupported();
    }

    public void mark(int n) throws IOException {
        this.ensureOpen();
        if (!this.in.markSupported()) {
            throw new IOException("mark() not supported");
        }
        this.in.mark(n);
    }

    public void reset() throws IOException {
        this.ensureOpen();
        this.in.reset();
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }
}

