/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class StringBuffer {
    private char[] value;
    private int count;
    private boolean shared;

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int n) {
        this.value = new char[n];
        this.shared = false;
    }

    public StringBuffer(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    private final void copy() {
        char[] cArray = new char[this.value.length];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
        this.shared = false;
    }

    public synchronized void ensureCapacity(int n) {
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
    }

    private void expandCapacity(int n) {
        int n2 = (this.value.length + 1) * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n > n2) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
        this.shared = false;
    }

    public synchronized void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        if (this.count < n) {
            if (this.shared) {
                this.copy();
            }
            while (this.count < n) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        } else {
            this.count = n;
            if (this.shared) {
                if (n > 0) {
                    this.copy();
                } else {
                    this.value = new char[16];
                    this.shared = false;
                }
            }
        }
    }

    public synchronized char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, n, cArray, n3, n2 - n);
    }

    public synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (this.shared) {
            this.copy();
        }
        this.value[n] = c;
    }

    public synchronized StringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public synchronized native StringBuffer append(String var1);

    public synchronized StringBuffer append(char[] cArray) {
        int n = cArray.length;
        int n2 = this.count + n;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        System.arraycopy(cArray, 0, this.value, this.count, n);
        this.count = n2;
        return this;
    }

    public synchronized StringBuffer append(char[] cArray, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count = n3;
        return this;
    }

    public StringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public synchronized StringBuffer append(char c) {
        int n = this.count + 1;
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        this.value[this.count++] = c;
        return this;
    }

    public native StringBuffer append(int var1);

    public StringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public StringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public StringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public synchronized StringBuffer delete(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 > 0) {
            if (this.shared) {
                this.copy();
            }
            System.arraycopy(this.value, n + n3, this.value, n, this.count - n2);
            this.count -= n3;
        }
        return this;
    }

    public synchronized StringBuffer deleteCharAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n + 1, this.value, n, this.count - n - 1);
        --this.count;
        return this;
    }

    public synchronized StringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public synchronized StringBuffer insert(int n, String string) {
        int n2;
        int n3;
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n3 = this.count + (n2 = string.length())) > this.value.length) {
            this.expandCapacity(n3);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count = n3;
        return this;
    }

    public synchronized StringBuffer insert(int n, char[] cArray) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = cArray.length;
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        System.arraycopy(cArray, 0, this.value, n, n2);
        this.count = n3;
        return this;
    }

    public StringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public synchronized StringBuffer insert(int n, char c) {
        int n2 = this.count + 1;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        this.count = n2;
        return this;
    }

    public StringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public StringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public StringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public synchronized StringBuffer reverse() {
        if (this.shared) {
            this.copy();
        }
        int n = this.count - 1;
        for (int i = n - 1 >> 1; i >= 0; --i) {
            char c = this.value[i];
            this.value[i] = this.value[n - i];
            this.value[n - i] = c;
        }
        return this;
    }

    public native String toString();

    final void setShared() {
        this.shared = true;
    }

    final char[] getValue() {
        return this.value;
    }
}

