/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.sun.cldc.i18n.Helper;
import java.io.UnsupportedEncodingException;

public final class String {
    private char[] value;
    private int offset;
    private int count;

    public String() {
        this.value = new char[0];
    }

    public String(String string) {
        this.count = string.length();
        this.value = new char[this.count];
        string.getChars(0, this.count, this.value, 0);
    }

    public String(char[] cArray) {
        this.count = cArray.length;
        this.value = new char[this.count];
        System.arraycopy(cArray, 0, this.value, 0, this.count);
    }

    public String(char[] cArray, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > cArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
        this.value = new char[n2];
        this.count = n2;
        System.arraycopy(cArray, n, this.value, 0, n2);
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        this(Helper.byteToCharArray(byArray, n, n2, string));
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public String(byte[] byArray, int n, int n2) {
        this(Helper.byteToCharArray(byArray, n, n2));
    }

    public String(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            stringBuffer.setShared();
            this.value = stringBuffer.getValue();
            this.offset = 0;
            this.count = stringBuffer.length();
        }
    }

    String(int n, int n2, char[] cArray) {
        this.value = cArray;
        this.offset = n;
        this.count = n2;
    }

    public int length() {
        return this.count;
    }

    public native char charAt(int var1);

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        System.arraycopy(this.value, this.offset + n, cArray, n3, n2 - n);
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        return Helper.charToByteArray(this.value, this.offset, this.count, string);
    }

    public byte[] getBytes() {
        return Helper.charToByteArray(this.value, this.offset, this.count);
    }

    public native boolean equals(Object var1);

    public boolean equalsIgnoreCase(String string) {
        return string != null && string.count == this.count && this.regionMatches(true, 0, string, 0, this.count);
    }

    public int compareTo(String string) {
        int n = this.count;
        int n2 = string.count;
        int n3 = Math.min(n, n2);
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        int n4 = this.offset;
        int n5 = string.offset;
        if (n4 == n5) {
            int n6 = n3 + n4;
            for (int i = n4; i < n6; ++i) {
                char c = cArray[i];
                char c2 = cArray2[i];
                if (c == c2) continue;
                return c - c2;
            }
        } else {
            while (n3-- != 0) {
                char c;
                char c3;
                if ((c3 = cArray[n4++]) == (c = cArray2[n5++])) continue;
                return c3 - c;
            }
        }
        return n - n2;
    }

    public boolean regionMatches(boolean bl, int n, String string, int n2, int n3) {
        char[] cArray = this.value;
        int n4 = this.offset + n;
        int n5 = this.offset + this.count;
        char[] cArray2 = string.value;
        int n6 = string.offset + n2;
        if (n2 < 0 || n < 0 || (long)n > (long)this.count - (long)n3 || (long)n2 > (long)string.count - (long)n3) {
            return false;
        }
        while (n3-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = cArray[n4++]) == (c3 = cArray2[n6++]) || bl && ((c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string, int n) {
        char[] cArray = this.value;
        int n2 = this.offset + n;
        int n3 = this.offset + this.count;
        char[] cArray2 = string.value;
        int n4 = string.offset;
        int n5 = string.count;
        if (n < 0 || n > this.count - n5) {
            return false;
        }
        while (--n5 >= 0) {
            if (cArray[n2++] == cArray2[n4++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public boolean endsWith(String string) {
        return this.startsWith(string, this.count - string.count);
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.offset;
        char[] cArray = this.value;
        int n3 = this.count;
        for (int i = 0; i < n3; ++i) {
            n = 31 * n + cArray[n2++];
        }
        return n;
    }

    public native int indexOf(int var1);

    public native int indexOf(int var1, int var2);

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.count - 1);
    }

    public int lastIndexOf(int n, int n2) {
        int n3 = this.offset;
        char[] cArray = this.value;
        for (int i = this.offset + (n2 >= this.count ? this.count - 1 : n2); i >= n3; --i) {
            if (cArray[i] != n) continue;
            return i - this.offset;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        int n2 = this.offset + (this.count - string.count);
        if (n >= this.count) {
            if (this.count == 0 && n == 0 && string.count == 0) {
                return 0;
            }
            return -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (string.count == 0) {
            return n;
        }
        int n3 = string.offset;
        char c = cArray2[n3];
        int n4 = this.offset + n;
        block0: while (true) {
            if (n4 <= n2 && cArray[n4] != c) {
                ++n4;
                continue;
            }
            if (n4 > n2) {
                return -1;
            }
            int n5 = n4 + 1;
            int n6 = n5 + string.count - 1;
            int n7 = n3 + 1;
            while (n5 < n6) {
                if (cArray[n5++] == cArray2[n7++]) continue;
                ++n4;
                continue block0;
            }
            break;
        }
        return n4 - this.offset;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        return n == 0 && n2 == this.count ? this : new String(this.offset + n, n2 - n, this.value);
    }

    public String concat(String string) {
        int n = string.length();
        if (n == 0) {
            return this;
        }
        char[] cArray = new char[this.count + n];
        this.getChars(0, this.count, cArray, 0);
        string.getChars(0, n, cArray, this.count);
        return new String(0, this.count + n, cArray);
    }

    public String replace(char c, char n) {
        if (c != n) {
            int n2 = this.count;
            int n3 = -1;
            char[] cArray = this.value;
            int n4 = this.offset;
            while (++n3 < n2 && cArray[n4 + n3] != c) {
            }
            if (n3 < n2) {
                int n5;
                char[] cArray2 = new char[n2];
                for (n5 = 0; n5 < n3; ++n5) {
                    cArray2[n5] = cArray[n4 + n5];
                }
                while (n3 < n2) {
                    n5 = cArray[n4 + n3];
                    cArray2[n3] = n5 == c ? n : n5;
                    ++n3;
                }
                return new String(0, n2, cArray2);
            }
        }
        return this;
    }

    public String toLowerCase() {
        int n;
        block3: {
            for (n = 0; n < this.count; ++n) {
                char c = this.value[this.offset + n];
                if (c == Character.toLowerCase(c)) {
                    continue;
                }
                break block3;
            }
            return this;
        }
        char[] cArray = new char[this.count];
        System.arraycopy(this.value, this.offset, cArray, 0, n);
        while (n < this.count) {
            cArray[n] = Character.toLowerCase(this.value[this.offset + n]);
            ++n;
        }
        return new String(0, this.count, cArray);
    }

    public String toUpperCase() {
        int n;
        block3: {
            for (n = 0; n < this.count; ++n) {
                char c = this.value[this.offset + n];
                if (c == Character.toUpperCase(c)) {
                    continue;
                }
                break block3;
            }
            return this;
        }
        char[] cArray = new char[this.count];
        System.arraycopy(this.value, this.offset, cArray, 0, n);
        while (n < this.count) {
            cArray[n] = Character.toUpperCase(this.value[this.offset + n]);
            ++n;
        }
        return new String(0, this.count, cArray);
    }

    public String trim() {
        int n;
        int n2 = this.count;
        int n3 = this.offset;
        char[] cArray = this.value;
        for (n = 0; n < n2 && cArray[n3 + n] <= ' '; ++n) {
        }
        while (n < n2 && cArray[n3 + n2 - 1] <= ' ') {
            --n2;
        }
        return n > 0 || n2 < this.count ? this.substring(n, n2) : this;
    }

    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        this.getChars(0, this.count, cArray, 0);
        return cArray;
    }

    public static String valueOf(Object object) {
        return object == null ? "null" : object.toString();
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String valueOf(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String valueOf(char c) {
        char[] cArray = new char[]{c};
        return new String(0, 1, cArray);
    }

    public static String valueOf(int n) {
        return Integer.toString(n, 10);
    }

    public static String valueOf(long l) {
        return Long.toString(l, 10);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public native String intern();
}

