/*
 * Decompiled with CFR 0.152.
 */
package com.jinke.io;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class File {
    protected String name;

    private native boolean exist(byte[] var1);

    private native boolean isDirectory(byte[] var1);

    private native boolean isFile(byte[] var1);

    private native int openDir(byte[] var1);

    private native String getNextFileName(int var1);

    private native void closeDir(int var1);

    private native String getCurrentDir();

    private native String getModifiedDate(byte[] var1);

    public File(String string) {
        this.name = string;
    }

    public boolean exists() {
        try {
            return this.exist(this.name.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return false;
        }
    }

    public boolean isDirectory() {
        try {
            return this.isDirectory(this.name.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return false;
        }
    }

    public boolean isFile() {
        try {
            return this.isFile(this.name.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return false;
        }
    }

    public String[] list() {
        try {
            String[] stringArray;
            int n = this.openDir(this.name.getBytes("UTF-8"));
            if (n == 0) {
                return null;
            }
            Vector vector = new Vector();
            while ((stringArray = this.getNextFileName(n)) != null) {
                if (stringArray.compareTo(new String(".")) == 0 || stringArray.compareTo(new String("..")) == 0) continue;
                vector.addElement(stringArray);
            }
            this.closeDir(n);
            stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = new String((String)vector.elementAt(i));
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public String getModifiedDate() {
        try {
            return this.getModifiedDate(this.name.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String getPath() {
        return this.name;
    }

    public String getAbsolutePath() {
        if (this.name.charAt(0) == '/') {
            return this.name;
        }
        return this.getCurrentDir() + '/' + this.name;
    }

    public String getCanonicalPath() throws IOException {
        int n;
        int n2;
        String string;
        block6: {
            if (this.name.charAt(0) == '/') {
                return this.name;
            }
            string = this.getCurrentDir() + '/';
            System.out.println("cur:" + string);
            System.out.println("name:" + this.name);
            n2 = 0;
            n = string.length() - 1;
            while (true) {
                if (this.name.startsWith("../", n2)) {
                    if (string.charAt(n) == '/') {
                        --n;
                    }
                    if (n < 0) {
                        throw new IOException();
                    }
                    n = string.lastIndexOf(47, n);
                    System.out.println(n);
                    if (n < 0) {
                        throw new IOException();
                    }
                    if ((n2 += 3) < this.name.length()) continue;
                    throw new IOException();
                }
                if (!this.name.startsWith("./", n2)) break block6;
                if ((n2 += 2) >= this.name.length()) break;
            }
            throw new IOException();
        }
        return string.substring(0, n + 1) + this.name.substring(n2);
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File(".././../VmUnix");
            System.out.println(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected native void mkdir(byte[] var1);

    public void mkdir() {
        try {
            this.mkdir(this.name.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

