#!/bin/sh
#
# This script will try to find all recently updated metadata.db, and set page
# flow mode for any pdf files inside.
#
# 1) Open a new PDF file.
# 2) Call this script.
# 3) Enjoy page flow mode.
#
# Caveats:
#  - only enables page_flow, no disabling;
#  - edits all "updated" metadata, which may be more than you want
#
# Disclaimer:
#  No warranty whatsoever. If it kills your reader, eats your goldfish and
#  gropes you, you'd have to live with it. See LICENSE file for more details.
#

# root dir of sdcard
root="${ROOT:-/media/mmcblk0p1}"
# optional log file
log="${root}/flow.log"
# SQL query to flip the uds_page_flow bit to on
flow_on='UPDATE application_data SET value="continuous"  WHERE "key"="uds_page_flow" AND file_id IN (SELECT file_id FROM file_metadata WHERE filename LIKE "%.pdf");'
# SQL query to list current content of metadata.db
query='SELECT * FROM file_metadata; SELECT * FROM application_data;'
# Guess what
separator="================================"
# temporary helper file
stampfile="/tmp/flowmytears.stamp"


# Sets uds_page_flow=continuous, for all pdf files in given metadata.db.
# Args: $1 - metadata.db file to update.
turn_on_flow () {
    sqlite3 "${1}" "${flow_on}"
}


# Forces reader to sync metadata to sdcard.
# Args: none.
sync_metadata () {
    dbus-send  --type=signal /com/irexnet/sysd com.irexnet.sysd.sysPrepareUnmount string:"/media/mmcblk0p1"
    sleep 2
    dbus-send  --type=signal /com/irexnet/sysd com.irexnet.sysd.sysVolumeMounted  string:"/media/mmcblk0p1"
}


# Dumps interesting tables to the log file.
# Args: $1 - metadata.db file to query.
dump_db () {
    echo "${separator}" >> ${log}
    date >> ${log}
    sqlite3 "${1}" "${query}" >> ${log}
}


# main screen turn on :)

# Cleanup, mark the stampfile, wait a bit.
rm -f "${log}"
touch "${stampfile}"
sleep 2

# Ask reader to sync data to sdcard.
sync_metadata

# Find all updated dbs.
find "${root}" -name "metadata.db" -newer ${stampfile} | while read file; do
#    dump_db "${file}"
    turn_on_flow "${file}"
#    dump_db "${file}"
done

# clean up stampfile
rm -f "${stampfile}"
