class LondonFreePress(BasicNewsRecipe):
    title          = u'London Free Press (Canada)'
    __author__            = 'rty'
    oldest_article = 4
    max_articles_per_feed = 100

    pubisher  = 'lfpress.com'
    description           = 'Ontario Canada Newspaper'
    category              = 'News, Ontario, Canada'
    remove_javascript = True
    use_embedded_content   = False
    no_stylesheets = True
    language = 'en'
    encoding               = 'utf-8'
    conversion_options = {'linearize_tables':True} 

    feeds          = [
                    (u'News', u'http://www.lfpress.com/news/rss.xml'),
                    (u'Comment', u'http://www.lfpress.com/comment/rss.xml'),
                    (u'Entertainment', u'http://www.lfpress.com/entertainment/rss.xml '),
                    (u'Money', u'http://www.lfpress.com/money/rss.xml '),
                    (u'Life', u'http://www.lfpress.com/life/rss.xml '),
                    (u'Sports', u'http://www.lfpress.com/sports/rss.xml ')
                        ]

    keep_only_tags = [
                              dict(name='div', attrs={'id':'article'}),
                               ]
    remove_tags = [
                    dict(name='div', attrs={'id':'commentsBottom'}),
                    dict(name='div', attrs={'class':['leftBox','bottomBox clear']}),
   	dict(name='ul', attrs={'class':'tabs dl contentSwap'}),
                         ]
    remove_tags_after = [
                  dict(name='div', attrs={'class':'bottomBox clear'}),
                         ]