/*
 * Decompiled with CFR 0.152.
 */
package manga;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesLoader {
    private Properties props = new Properties();
    private File properties_file = null;
    protected final String key_width = "width";
    protected final String key_height = "height";
    protected final String key_max_dpi = "max_dpi";
    protected final String key_auto_trim = "auto_trim";
    protected final String key_trim_fuzz = "trim_fuzz";
    protected final String key_auto_rotate = "auto_rotate";
    protected final String key_color_mode = "color_mode";
    protected final String key_num_colors = "num_colors";
    protected final String key_page_filename_length = "page_filename_length";
    protected final String key_output_base_folder = "output_base_folder";
    protected final String key_del_output_image_folders = "del_output_image_folders";
    protected final String key_archive_input_image_folders = "archive_input_image_folders";
    protected final String key_unarchive_input_image_folders = "unarchive_input_image_folders";
    protected final String key_pdf = "pdf";
    protected final String key_pdf_r_to_l = "pdf_r_to_l";
    protected final String key_archive = "archive";
    protected final String key_archive_format = "archive_format";
    protected final String key_epub = "epub";
    protected final String key_epub_r_to_l = "epub_r_to_l";
    protected final String key_auto_bind = "auto_bind";
    protected final String key_auto_bind_size = "auto_bind_size";
    protected final String key_auto_split_portrait_scans = "auto_split_portrait_scans";
    protected final String key_auto_split_r_first = "auto_split_r_first";
    protected final String key_allow_auto_split_color_scans = "allow_auto_split_color_scans";
    protected final String key_image_format = "image_format";
    protected final String key_image_magick_dir = "image_magick_dir";
    protected final String key_kindle_bookmark = "kindle_bookmark";
    protected final String key_comic_zeal_naming = "comic_zeal_naming";

    public PropertiesLoader(File n_properties_file) {
        this.properties_file = n_properties_file;
        try {
            FileInputStream fis = new FileInputStream(this.properties_file);
            this.props.load(fis);
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PropertiesLoader(InputStream is) {
        try {
            this.props.load(is);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getWidth() {
        return this.intKeyValue(this.props.getProperty("width"));
    }

    public int getHeight() {
        return this.intKeyValue(this.props.getProperty("height"));
    }

    public int getMaxDPI() {
        return this.intKeyValue(this.props.getProperty("max_dpi"));
    }

    public int getPageFilenameLength() {
        return this.intKeyValue(this.props.getProperty("page_filename_length"));
    }

    public String getOutputBaseFolder() {
        return this.props.getProperty("output_base_folder").trim();
    }

    public boolean getArchiveInputImageFolders() {
        return this.booleanKeyValue(this.props.getProperty("archive_input_image_folders"));
    }

    public boolean getUnarchiveInputImageFolders() {
        return this.booleanKeyValue(this.props.getProperty("unarchive_input_image_folders"));
    }

    public boolean getDelOutputImageFolders() {
        return this.booleanKeyValue(this.props.getProperty("del_output_image_folders"));
    }

    public boolean getAutoTrim() {
        return this.booleanKeyValue(this.props.getProperty("auto_trim"));
    }

    public int getTrimFuzz() {
        return this.intKeyValue(this.props.getProperty("trim_fuzz"));
    }

    public boolean getAutoRotate() {
        return this.booleanKeyValue(this.props.getProperty("auto_rotate"));
    }

    public String getColorMode() {
        return this.props.getProperty("color_mode");
    }

    public int getNumColors() {
        return this.intKeyValue(this.props.getProperty("num_colors"));
    }

    public boolean getPdf() {
        return this.booleanKeyValue(this.props.getProperty("pdf"));
    }

    public boolean getPdfRToL() {
        return this.booleanKeyValue(this.props.getProperty("pdf_r_to_l"));
    }

    public boolean getArchive() {
        return this.booleanKeyValue(this.props.getProperty("archive"));
    }

    public String getArchiveFormat() {
        return this.props.getProperty("archive_format");
    }

    public boolean getEpub() {
        return this.booleanKeyValue(this.props.getProperty("epub"));
    }

    public boolean getEpubRToL() {
        return this.booleanKeyValue(this.props.getProperty("epub_r_to_l"));
    }

    public boolean getAutoBind() {
        return this.booleanKeyValue(this.props.getProperty("auto_bind"));
    }

    public int getAutoBindSize() {
        return this.intKeyValue(this.props.getProperty("auto_bind_size"));
    }

    public boolean getAutoSplitPortraitScans() {
        return this.booleanKeyValue(this.props.getProperty("auto_split_portrait_scans"));
    }

    public boolean getAutoSplitRFirst() {
        return this.booleanKeyValue(this.props.getProperty("auto_split_r_first"));
    }

    public boolean getAllowAutoSplitColorScans() {
        return this.booleanKeyValue(this.props.getProperty("allow_auto_split_color_scans"));
    }

    public String getImageFormat() {
        return this.props.getProperty("image_format");
    }

    public String getImageMagickDir() {
        return this.props.getProperty("image_magick_dir").trim();
    }

    public boolean getKindleBookmark() {
        return this.booleanKeyValue(this.props.getProperty("kindle_bookmark"));
    }

    public boolean getComicZealNaming() {
        return this.booleanKeyValue(this.props.getProperty("comic_zeal_naming"));
    }

    public int intKeyValue(String value) {
        value = value.trim();
        return Integer.parseInt(value);
    }

    public boolean booleanKeyValue(String value) {
        if ((value = value.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return false;
    }

    public void printProperties() {
        boolean unarchive_input_image_archives;
        int width;
        if (this.properties_file != null) {
            System.out.println("\nUsing these settings stored in " + this.properties_file.getName() + ":");
        }
        if ((width = this.getWidth()) != -1) {
            System.out.println("  width (in pixels):  " + width);
        } else {
            System.out.println("  width (in pixels):  original");
        }
        int height = this.getHeight();
        if (height != -1) {
            System.out.println("  height (in pixels): " + height);
        } else {
            System.out.println("  height (in pixels): original");
        }
        System.out.println("  maximum dpi: " + this.getMaxDPI());
        boolean use_autotrim = this.getAutoTrim();
        System.out.println("  auto trim: " + use_autotrim);
        if (use_autotrim) {
            System.out.println("    trim fuzz: " + this.getTrimFuzz() + "%");
        }
        System.out.println("  auto rotate: " + this.getAutoRotate());
        System.out.println("  color mode: " + this.getColorMode());
        int num_colors = this.getNumColors();
        if (num_colors != -1) {
            System.out.println("  num colors: " + num_colors);
        } else {
            System.out.println("  num colors: full");
        }
        boolean use_pdf = this.getPdf();
        System.out.println("  pdf chapters: " + use_pdf);
        if (use_pdf) {
            System.out.println("    pdf r to l: " + this.getPdfRToL());
        }
        boolean use_archive = this.getArchive();
        System.out.println("  archive chapters: " + use_archive);
        if (use_archive) {
            System.out.println("    archive format: " + this.getArchiveFormat());
        }
        boolean use_epub = this.getEpub();
        System.out.println("  epub chapters: " + use_epub);
        if (use_epub) {
            System.out.println("    epub r to l: " + this.getEpubRToL());
        }
        boolean use_auto_bind = this.getAutoBind();
        System.out.println("  auto bind: " + use_auto_bind);
        if (use_auto_bind) {
            System.out.println("    auto bind size: " + this.getAutoBindSize());
        }
        boolean use_auto_split_portrait_scans = this.getAutoSplitPortraitScans();
        System.out.println("  auto split portrait scans: " + use_auto_split_portrait_scans);
        if (use_auto_split_portrait_scans) {
            System.out.println("    split right page first: " + this.getAutoSplitRFirst());
            System.out.println("    allow auto split color scans: " + this.getAllowAutoSplitColorScans());
        }
        if (unarchive_input_image_archives = this.getUnarchiveInputImageFolders()) {
            System.out.println("  unarchive input image archives: " + unarchive_input_image_archives);
        } else {
            System.out.println("  archive input image folders: " + this.getArchiveInputImageFolders());
        }
        System.out.println("  delete output image folders: " + this.getDelOutputImageFolders());
        System.out.println("  image format: " + this.getImageFormat());
        System.out.println("  kindle bookmark: " + this.getKindleBookmark());
        System.out.println("  comic zeal naming: " + this.getComicZealNaming());
        System.out.println("  ImageMagick home directory: " + this.getImageMagickDir());
        System.out.println("");
    }
}

