/*
 * File Name: pixlist.c
 */

/*
 * This file is part of popupmenu.
 *
 * popupmenu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * popupmenu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 *
 * Note: possibly could have used reference count of gobject instead
 */

//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

#define LOGGING_ON 0

// system include files, between < >
#include <gtk/gtk.h>
#include <string.h>

// ereader include files, between < >
#include <libergtk/ergtk.h>

#include "log.h"
#include "pixlist.h"

static GTree *g_icon_cache = NULL;

gint compareString(gconstpointer a, gconstpointer b) {
    return strcmp((const gchar*)a, (const gchar*)b);
}

static GdkPixbuf* load_icon(const gchar* filename)
{
    if (g_icon_cache == NULL) g_icon_cache = g_tree_new(compareString);

    gpointer cache = g_tree_lookup(g_icon_cache, filename);
    if (cache) return (GdkPixbuf *)cache;

    GError *err = NULL;
    GdkPixbuf *icon = gdk_pixbuf_new_from_file(filename, &err);
    if (icon) {
        g_tree_insert(g_icon_cache, g_strdup(filename), icon);
    } else  {
        LOGPRINTF("cannot load iconfile [%s] error [%s]", filename, err->message);
        g_clear_error(&err);
    }
    return icon;
}


GdkPixbuf *pixlist_icon_state(const char *icon, const char *state)
{
    LOGPRINTF("entry %s, %s", icon, state);
    
    if ((icon == NULL) || (icon[0] == '\0'))
    {
        // no icon name so don't bother to load/ref image
        return NULL;
    }

    gchar *iconfile = NULL;
    gchar *fileext = g_utf8_strrchr(icon, strlen(icon), '.');
    if (fileext == NULL)
    {
        // name is not a filename or path 
        // prefix with path and postfix with state and file extension
        if (state && (strcmp(state, "normal") == 0))
        {
            iconfile = g_strdup_printf("%s%s.png", PATH_IMG, icon);
        }
        else
        {
            iconfile = g_strdup_printf("%s%s_%s.png", PATH_IMG, icon, state);
        }
    }
    else
    {
        gchar *strcopy = g_strdup(icon);
        gchar *filepath = g_utf8_strrchr(strcopy, strlen(strcopy), '.');
        *filepath = '\0';
        
        // icon is a full path
        // postfix with state only
        if (strcmp(state, "normal") ==0)
        {
            iconfile = g_strdup_printf("%s%s", strcopy, fileext);
        }
        else
        {
            iconfile = g_strdup_printf("%s_%s%s", strcopy, state, fileext);
        }
        g_free(strcopy);
    }
        
    GdkPixbuf* pixbuf = load_icon(iconfile);
    g_free(iconfile);
    return pixbuf;
}


GdkPixbuf *pixlist_toolbar_icon(const char *name, const char *state)
{
    GdkPixbuf* icon = NULL;
    if (name != NULL && name[0] != 0) {
        static char filename[256];
        snprintf(filename, sizeof(filename), "%stoolbar_%s_%s.png", PATH_IMG, name, state);
        icon = load_icon(filename);
        if (icon == NULL) {
            WARNPRINTF("cannot find icon %s", filename);
        }
    }
    if (icon == NULL) {
        icon = load_icon(PATH_IMG"toolbar_blank.png");
    }
    return icon;
}

