//virtual keyboard public object
VirtualKeyboard = new Object();
//public methods:
//VirtualKeyboard.Activate = function(from,kbdView)
//VirtualKeyboard.Deactivate = function()
//
//multiletter acronyms:
//SPC   space (char 32)
//SH    shift (change keyboard layout)

var tmp = function() {
    var log = Core.log.getLogger("VK");

    //Keyboard definition object
    //name      Full keyboard name
    //shortName shortcut to be displayed on button
    //def       array with keyboard definition
    //shift     optional array with shifted keyboard definition
    kbdDefinition = function(name, shortName, def, shift) {
        this.Name = name;
        this.ShortName = shortName;
        this.Definition = def;
        this.Shifted = shift;
        this.Enable = true;
    };
    //  private variables
    var _fromObj;                       //user object activating keyboard.
    var _kbdView;                       //visual representation of keyboard
    var _origDrivers;                   //original button drivers
    var _inpBuffer;                     //input buffer
    var _fstDigit;                      //first digit; -1 == there is not 1st digit
    var _kbdList;                       //list of keyboard layouts in use (max. 10)
    var _kbdLayoutList = new Array();   //list of keyboard layouts
    var _actKeyboard;                   //actually active keyboard
    var _actDefinition;                 //actually active keyboard definition (kbdDefinition.Definition or kbdDefinition.Shift)
    var _kbdLineSelector;               //selected line
    var _KeybordSwithLine;              //line of keyboard switcher

    //prepare several keyboards
    _kbdLayoutList.push(new kbdDefinition('Letters', 'abc', [
        ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'],
        ['k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't'],
        ['u', 'v', 'w', 'x', 'y', 'z', ' ', '', '', '']
    ]));
    _kbdLayoutList.push(new kbdDefinition('Digits', '123', [
        ['1', '2', '3', '4', '5', '6', '7', '8', '9', '0']
    ]));
    _kbdLayoutList.push(new kbdDefinition('Edhanced', 'edh',
    [
        ['1', '2', '3', '4', '5', '6', '7', '8', '9', '0'],
        ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'],
        ['k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't'],
        ['u', 'v', 'w', 'x', 'y', 'z', 'SPC', '-', '+', '='],
        ['[', ']', ',', '.', ';', ':', '/', '?', '\\', 'SH']
    ],
    [
        ['!', '@', '#', '$', '%', '^', '&', '*', '(', ')'],
        ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J'],
        ['K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T'],
        ['U', 'V', 'W', 'X', 'Y', 'Z', 'SPC', '_', '', ''],
        ['{', '}', '<', '>', '"', '\'', '|', '~', '`', 'SH']
    ]
    ));
    _kbdLayoutList.kbdDefault = _kbdLayoutList[0];

    //save original button driver and set new one
    //from      (group) object initializing keyboard
    //name      name of driver to install
    function installDriver(from, name) {
        _origDrivers[name] = from[name];
        from[name] = this['fg_' + name];
    };
    //helper function to transform array index to row/column number
    //n         array index (0..9)
    //ret->     line/col/button index
    function arr2ndx(n) {
        return (n + 1) % 10;
    };
    //helper function to transform row/column number to array index
    //n         row/column/button number
    //ret->     array index (0..9)
    function ndx2arr(n) {
        if (n == 0) return 9;
        return n - 1;
    };
    //activate keyboard layout
    //kbd       keybord layout to activate
    //bShift    true for 'shifted' layout
    function setKeyboard(kbd, bShift) {
        //some cleanup - just to be sure
        if (_kbdLineSelector != undefined) {
            _kbdLineSelector.kbdLine.KBD_LINE_GROUP.kbdLineSel.show(false);
            _kbdLineSelector = undefined;
        }
        _fstDigit = -1;

        _actKeyboard = kbd;
        if (bShift && (kbd.Shifted != undefined)) {
            _actDefinition = kbd.Shifted;
        } else {
            _actDefinition = kbd.Definition;
        }
        _kbdView.kbdDoc.KBD_GROUP.kbdTitle.setValue(kbd.Name);
        //set keyboard lines
        for (var line = 0; line < 10; line++) {
            var lineObj = _kbdView.kbdDoc.KBD_GROUP['line' + arr2ndx(line)];
            if (line in _actDefinition) {
                lineObj.show(true);
                setKeyboardLine(lineObj, line + 1, _actDefinition[line]);
                if ((line % 2) == 0) {
                    lineObj.kbdLine.KBD_LINE_GROUP.kbdLineLight.show(true);
                } else {
                    lineObj.kbdLine.KBD_LINE_GROUP.kbdLineDark.show(true);
                }
            } else {
                lineObj.show(false);
            }
        }
        //set language line
        var lngLine = _actDefinition.length;
        _KeybordSwithLine = this.arr2ndx(lngLine);
        var kbdLngLine = _kbdView.kbdDoc.KBD_GROUP['line' + _KeybordSwithLine];
        if ((lngLine % 2) == 0) {
            kbdLngLine.kbdLine.KBD_LINE_GROUP.kbdLineLight.show(true);
        } else {
            kbdLngLine.kbdLine.KBD_LINE_GROUP.kbdLineDark.show(true);
        }
        kbdLngLine.show(true);
        kbdLngLine.kbdLine.KBD_LINE_GROUP.lineName.setValue('0');
        for (var col = 0; col < 10; col++) {
            var colNdx = this.arr2ndx(col);
            var colObj = kbdLngLine.kbdLine.KBD_LINE_GROUP['col' + colNdx];
            if (col in _kbdList) {
                colObj.setValue(_kbdList[col].ShortName);
            } else {
                colObj.setValue('');
            }
        }
        //resize keyboard - why the hell it does not work???
        //        var kbdY, ln0Y, ln0H;
        //        kbdY = _kbdView.getY();
        //        ln0Y = _kbdView.kbdDoc.KBD_GROUP.line1.getY();
        //        ln0H = _kbdView.kbdDoc.KBD_GROUP.line1.getHeight();
        //        _kbdView.changeLayout(100, undefined, 100, 50, 500, undefined);
    };
    //fill one line of keyboard layout
    //line      line view object
    //lineNum   line number to be set as label
    //kbdLine   keys definition
    function setKeyboardLine(line, lineNum, kbdLine) {
        line.kbdLine.KBD_LINE_GROUP.lineName.setValue(lineNum);
        for (var col = 0; col < 10; col++) {
            var colObj = line.kbdLine.KBD_LINE_GROUP['col' + this.arr2ndx(col)];
            colObj.setValue(kbdLine[col]);
        }
    };
    //display updated input box and send feedback to user
    //key       'physical' key
    //keyTranslated translated meaning (e.g. SPC is translated to ' ')
    function reportProgress(key, keyTranslated) {
        _kbdView.kbdDoc.KBD_GROUP.input.setValue(_inpBuffer);
        _fromObj.bubble("doKbdProgress", key, keyTranslated, _inpBuffer);
    };
    //process digit button pressed
    //digit     pressed digit (1st or 2nd in pair)
    function processDigit(digit) {
        var arrNdx = ndx2arr(digit);
        if (_fstDigit == -1) {
            //this is 1st digit
            if (arrNdx == 9) {
                //keyboard switch
                //_kbdView.kbdDoc.KBD_GROUP.stat.setValue('kbdSwitch');
                _fstDigit = 9;
                _kbdLineSelector = _kbdView.kbdDoc.KBD_GROUP['line' + _KeybordSwithLine];
                _kbdLineSelector.kbdLine.KBD_LINE_GROUP.kbdLineSel.show(true);
            } else {
                if (!(arrNdx in _actDefinition)) {
                    //_kbdView.kbdDoc.KBD_GROUP.stat.setValue('too big fstDigit');
                } else {
                    _fstDigit = arrNdx;
                    //_kbdView.kbdDoc.KBD_GROUP.stat.setValue('fstDigit=' + _fstDigit);
                    var lineObj = _kbdView.kbdDoc.KBD_GROUP['line' + digit];
                    _kbdLineSelector = lineObj;
                    _kbdLineSelector.kbdLine.KBD_LINE_GROUP.kbdLineSel.show(true);
                }
            }
        } else {
            if (_fstDigit == 9) {
                //keyboard switch
                var kbd = _kbdList[arrNdx];
                if (kbd != undefined) {
                    setKeyboard(kbd);
                }
            } else {
                var pressed = _actDefinition[_fstDigit][arrNdx];
                var translated = translateKey(pressed);
                _inpBuffer += translated;
                //_kbdView.kbdDoc.KBD_GROUP.stat.setValue('');
                reportProgress(pressed, translated);
            }
            if (_kbdLineSelector != undefined) {
                _kbdLineSelector.kbdLine.KBD_LINE_GROUP.kbdLineSel.show(false);
                _kbdLineSelector = undefined;
            }
            _fstDigit = -1;
        }
    };
    //multiletter key translation
    //pressed   pressed key to translate
    //ret->     translated value
    function translateKey(pressed) {
        if (pressed.lenght == 1) return pressed;
        if (pressed == 'SPC') return ' ';
        if (pressed == 'SH') {
            //shift pressed
            setKeyboard(_actKeyboard, _actDefinition == _actKeyboard.Definition);
            return '';
        }
        return pressed;
    }
    //digit button hold - keyboard switcher
    //digit     0..9 - hold button
    function holdDigit(digit) {
        var kbd = _kbdList[digit];
        if (kbd != undefined) {
            setKeyboard(kbd);
        }
    };

    //activate keyboard
    //from      user object activating keyboard. I'll hack this object button drivers
    //kbdView   visual representation of keyboard
    VirtualKeyboard.Activate = function(from, kbdView) {
        log.trace('Activate');
        _kbdView = kbdView;
        _fromObj = from;
        _kbdView.show(true);
        _inpBuffer = '';
        _kbdView.kbdDoc.KBD_GROUP.input.setValue('');
        _fstDigit = -1;
        _kbdLineSelector = undefined;
        _origDrivers = new Object();
        installDriver(from, 'doCenter');
        installDriver(from, 'doMark');
        installDriver(from, 'doMarkMenu'); //mark-hold
        installDriver(from, 'doMenu');
        installDriver(from, 'doDigit');
        for (var i = 0; i < 10; i++) {
            installDriver(from, 'doHold' + i);
        }
        //prepare list of keyboards
        var srcNdx = 0;
        _kbdList = new Array();
        _kbdList.push(_kbdLayoutList.kbdDefault);
        while ((srcNdx < _kbdLayoutList.length) && (_kbdList.length < 10)) {
            if (_kbdLayoutList[srcNdx].Enable && (_kbdLayoutList[srcNdx] != _kbdLayoutList.kbdDefault)) {
                _kbdList.push(_kbdLayoutList[srcNdx]);
            }
            srcNdx++;
        }

        setKeyboard(_kbdLayoutList.kbdDefault);
        log.trace('Activate done');
    };
    //unactivate keyboard
    VirtualKeyboard.Deactivate = function() {
        log.trace('Deactivate');
        if (_fromObj == undefined) return; //nothing to do
        _kbdView.show(false);

        for (var drv in _origDrivers) {
            if (_origDrivers[drv] == undefined) {
                //there was not driver originally
                delete _fromObj[drv];
            } else {
                _fromObj[drv] = _origDrivers[drv];
            }
        }

        _kbdView = undefined;
        _fromObj = undefined;
        _origDrivers = undefined;
    };
    //force value into input buffer
    VirtualKeyboard.SetInput = function(input) {
        _inpBuffer = input;
        _kbdView.kbdDoc.KBD_GROUP.input.setValue(input);
    };
    
    /////////////////////////////////////////////
    // fg_ functions are called with 'this' == _fromObj!!!
    // button event handlers

    //Center button pressed
    function fg_doCenter() { //result ready
        this.bubble("doKbdInput", _inpBuffer);
    };
    //Menu button
    function fg_doMenu() { //cancel - switch off keyboard?
        this.bubble("doKbdCancel");
    }
    //Mark button
    function fg_doMarkMenu() {   //clear result
        _inpBuffer = '';
        reportProgress('CLR', undefined);
    };
    //Mark-hold button
    function fg_doMark() {   //BS
        _inpBuffer = _inpBuffer.slice(0, -1);
        reportProgress('BS', undefined);
    };
    //digit button pressed
    function fg_doDigit(part) {
        processDigit(part.key);
    };
    //digit button pressed & hold
    function fg_doHold0() { holdDigit(0); };
    function fg_doHold1() { holdDigit(1); };
    function fg_doHold2() { holdDigit(2); };
    function fg_doHold3() { holdDigit(3); };
    function fg_doHold4() { holdDigit(4); };
    function fg_doHold5() { holdDigit(5); };
    function fg_doHold6() { holdDigit(6); };
    function fg_doHold7() { holdDigit(7); };
    function fg_doHold8() { holdDigit(8); };
    function fg_doHold9() { holdDigit(9); };

    //configuration object...
    var _keyboardObject = {
        name: "VirtualKeyboard",
        title: "Virtual Keyboard",
        icon: "CLOCK",    //I know, stupid - temporary:)
        optionDefs:
        [],
        /**
        * @constructor
        */
        onPreInit: function() {
            var optDefs = this.optionDefs;
            var dk = {
                name: "defKbd",
                title: "Default keyboard",
                icon: "CLOCK", //I know, stupid - temporary:)
                defaultValue: "0",
                values: [],
                valueTitles: {}
            };
            optDefs.push(dk);
            for (var i = 0; i < _kbdLayoutList.length; i++) {
                dk.values.push(i.toString());
                dk.valueTitles[i.toString()] = _kbdLayoutList[i].Name;
                //add enable/disable for keyboards
                optDefs.push({
                    name: i.toString(),
                    title: _kbdLayoutList[i].Name,
                    icon: "CLOCK", //I know, stupid - temporary:)
                    defaultValue: 'Enable',
                    values: ['Enable', 'Disable'],
                    valueTitles: { 'Enable': 'Enabled', 'Disable': 'Disabled' }
                });
            }
        },
        //apply settings on internal structures
        onInit: function() {
            _kbdLayoutList.kbdDefault = _kbdLayoutList[this.options.defKbd];
            for (var i = 0; i < _kbdLayoutList.length; i++) {
                _kbdLayoutList[i].Enable = (this.options[i.toString()] == 'Enable');
            }
        },
        //setting has changed - reflect it to internal structures
        onSettingsChanged: function(propertyName, oldValue, newValue) {
            if (oldValue === newValue) {
                return;
            }
            if (propertyName == 'defKbd') {
                //default keyboard
                _kbdLayoutList.kbdDefault = _kbdLayoutList[newValue];
                _kbdLayoutList[newValue].Enable = true;    //enable default keyboard
            } else {
                //particular keyboard enable/disable
                _kbdLayoutList[propertyName].Enable = (newValue == 'Enable');
            }
        }
    };
    if (Core.addAddon != undefined) {
        //ok, this is not simulation
        Core.addAddon(_keyboardObject);
    }
};
try {
    tmp();
}
catch (e) {
    log.error("in VirtualKeyboard.js", e);
}

//    this._kbdDriver.inp.changeLayout(30, undefined, 150, undefined, 100, 30, undefined);
//target.playWithTextEdit = function(e) {
//    var rootWindow = this.getWindow();
//    this.bubble("tracelog", 'rootWindow=' + rootWindow);
//    var te = new FskUI.TextEdit(rootWindow);
//    this.bubble("tracelog", 'te=' + te);
//    this.bubble("tracelog", 'te.setTextFormat=' + te.setTextFormat);
//    var tf = new FskUI.TextFormat;
//    this.bubble("tracelog", 'tf=' + tf);
//    var fo = tf.getFont();
//    this.bubble("tracelog", 'fo=' + fo);
//    var co = tf.getColor();
//    this.bubble("tracelog", 'co=' + co);
//    this.bubble("tracelog", 'size=' + tf.getSize());
//    this.bubble("tracelog", 'style=' + tf.getStyle());
//    this.bubble("tracelog", 'VAl=' + tf.getVAlignment());
//    this.bubble("tracelog", 'HAl=' + tf.getHAlignment());
//    te.setTextFormat(tf);
//    var bounds = new Object();
//    bounds.x = 100;
//    bounds.y = 100;
//    bounds.width = 100;
//    bounds.height = 30;
//    te.setBounds(bounds);
//    te.insert('pokus');
//    rootWindow.beginDrawing();
//    te.draw(false);
//    rootWindow.endDrawing();
//    this.te = te;
//};
