#! /usr/bin/python
# embedfont_plugin.py, version 1.0
# Embeds custom fonts into a ePub
# based on the information from fiery@mobileread
# http://www.mobileread.com/forums/showthread.php?t=61587
# Author: Paul Tomashevskyi with some code from Paul Durrant's fontencrypt.py script
# License: GPL v3
# Revision history:
# 1.0 - Initial release


import sys
import shutil
import zlib
import binascii
import xml.etree.ElementTree as etree
import zipfile
from zipfile import ZipFile, ZipInfo, ZIP_STORED, ZIP_DEFLATED
from contextlib import closing
import os, re
import os.path
from calibre.customize import FileTypePlugin



class EmbedFontPlugin(FileTypePlugin):

 name                = 'Minion-Myriad embedder' # Name of the plugin
 description         = 'This plugin perform embedding of custom fonts into epub files'
 supported_platforms = ['windows', 'osx', 'linux'] # Platforms this plugin will run on
 author              = 'Brent Carson based on code by Paul Tomashevskyi' # The author of this plugin
 version             = (1, 0, 0)   # The version number of this plugin
 file_types          = set(['epub']) 
 on_postprocess      = True
 priority = 100
  

 def run(self, path_to_ebook):


  fontFamilyNameSerif = "Minion Pro"
  fontRegularNameSerif = 'MinionPE.otf'
  fontItalicNameSerif = 'MinionP8.otf'
  fontBoldNameSerif = 'MinionP0.otf'
  fontBoldItalicNameSerif = 'MinionP6.otf'
  fontFamilyNameMono = "Bitstream Vera Sans Mono"
  fontRegularNameMono = 'VeraMono.ttf'
  fontItalicNameMono = 'VeraMoIt.ttf'
  fontBoldNameMono = 'VeraMoBd.ttf'
  fontBoldItalicNameMono = 'VeraMoBI.ttf'
  fontFamilyNameSans = "Myriad Pro"
  fontRegularNameSans = 'MyriadPE.otf'
  fontItalicNameSans = 'MyriadPC.otf'
  fontBoldNameSans = 'MyriadPro-BlackSemiExt.otf'
  fontBoldItalicNameSans = 'MyriadPro-BlackSemiExtIt.otf'


# Lets find the location of liberation font files
# usually they are present in Calibre2\\..\\resources\\fonts\\MinionMyriad\\
# from Kovid: font_dir = P('fonts/liberation')

  fontPath = None

#  for path in sys.path:
#	fontPath = path
#	print "Attempting " + fontPath
#	if not os.path.isfile(fontPath + fontItalicNameSerif):
#		fontPath = None
#		continue
#	if not os.path.isfile(fontPath + fontRegularNameSerif):
#		fontPath = None
#		continue
#	if not os.path.isfile(fontPath + fontBoldItalicNameSerif):
#		fontPath = None
#		continue
#	if not os.path.isfile(fontPath + fontBoldNameSerif):
#		fontPath = None
#		continue
#	break
 
  if fontPath == None:
   for path in sys.path:
	fontPath = path + "\\..\\resources\\fonts\\MinionMyriad\\"
#	fontPath = P('fonts/')
	if not os.path.isfile(fontPath + fontItalicNameSerif):
		fontPath = None
		continue
	if not os.path.isfile(fontPath + fontRegularNameSerif):
		fontPath = None
		continue
	if not os.path.isfile(fontPath + fontBoldItalicNameSerif):
		fontPath = None
		continue
	if not os.path.isfile(fontPath + fontBoldNameSerif):
		fontPath = None
		continue
	if not os.path.isfile(fontPath + fontItalicNameMono):
		fontPath = None
		continue
	if not os.path.isfile(fontPath + fontRegularNameMono):
		fontPath = None
		continue
	if not os.path.isfile(fontPath + fontBoldItalicNameMono):
		fontPath = None
		continue
	if not os.path.isfile(fontPath + fontBoldNameMono):
		fontPath = None
		continue
	if not os.path.isfile(fontPath + fontItalicNameSans):
		fontPath = None
		continue
	if not os.path.isfile(fontPath + fontRegularNameSans):
		fontPath = None
		continue
	if not os.path.isfile(fontPath + fontBoldItalicNameSans):
		fontPath = None
		continue
	if not os.path.isfile(fontPath + fontBoldNameSans):
		fontPath = None
		continue
	break

  if fontPath == None:
       print "Error: Can't find Minion-Myriad fonts."
       sys.exit(0)	

  with closing(ZipFile(open(path_to_ebook, 'rb'))) as inf:
    namelist = set(inf.namelist())
    if 'content.opf' not in namelist:
       print "Error: content.opf missing."
       sys.exit(0)
    content = etree.fromstring(inf.read('content.opf'))
    manifest = content.find("{http://www.idpf.org/2007/opf}manifest")
    if manifest==None:
       print "Error: manifest in content.xml missing"
       sys.exit(0)

# modify manifest file
    manifestitems = manifest.getchildren()
    id1 = etree.SubElement(manifest, 'item')
    id1.attrib["href"]=fontRegularNameSerif
    id1.attrib["media-type"]="application/octet-stream"
    id1.attrib["id"]="id1"
    id2 = etree.SubElement(manifest, 'item')
    id2.attrib["href"]=fontItalicNameSerif
    id2.attrib["media-type"]="application/octet-stream"
    id2.attrib["id"]="id2"
    id3 = etree.SubElement(manifest, 'item')
    id3.attrib["href"]=fontBoldItalicNameSerif
    id3.attrib["media-type"]="application/octet-stream"
    id3.attrib["id"]="id3"
    id4 = etree.SubElement(manifest, 'item')
    id4.attrib["href"]=fontBoldNameSerif
    id4.attrib["media-type"]="application/octet-stream"
    id4.attrib["id"]="id4"
    id5 = etree.SubElement(manifest, 'item')
    id5.attrib["href"]=fontRegularNameMono
    id5.attrib["media-type"]="application/octet-stream"
    id5.attrib["id"]="id5"
    id6 = etree.SubElement(manifest, 'item')
    id6.attrib["href"]=fontItalicNameMono
    id6.attrib["media-type"]="application/octet-stream"
    id6.attrib["id"]="id6"
    id7 = etree.SubElement(manifest, 'item')
    id7.attrib["href"]=fontBoldItalicNameMono
    id7.attrib["media-type"]="application/octet-stream"
    id7.attrib["id"]="id7"
    id8 = etree.SubElement(manifest, 'item')
    id8.attrib["href"]=fontBoldNameMono
    id8.attrib["media-type"]="application/octet-stream"
    id8.attrib["id"]="id8"
    id9 = etree.SubElement(manifest, 'item')
    id9.attrib["href"]=fontRegularNameSans
    id9.attrib["media-type"]="application/octet-stream"
    id9.attrib["id"]="id9"
    id10 = etree.SubElement(manifest, 'item')
    id10.attrib["href"]=fontItalicNameSans
    id10.attrib["media-type"]="application/octet-stream"
    id10.attrib["id"]="id10"
    id11 = etree.SubElement(manifest, 'item')
    id11.attrib["href"]=fontBoldItalicNameSans
    id11.attrib["media-type"]="application/octet-stream"
    id11.attrib["id"]="id11"
    id12 = etree.SubElement(manifest, 'item')
    id12.attrib["href"]=fontBoldNameSans
    id12.attrib["media-type"]="application/octet-stream"
    id12.attrib["id"]="id12"

#modify stylesheet.css file
    stylesheetcontent = inf.read('stylesheet.css')
    insertplace = stylesheetcontent.find('.calibre {') 
    newstylesheetcontent = stylesheetcontent[:insertplace]+\
	"@font-face {font-style: italic;font-family: '" + fontFamilyNameSerif +"', serif;font-weight: normal;src: url(" + fontItalicNameSerif + ");}"+\
	"@font-face {font-style: normal;font-family: '" + fontFamilyNameSerif +"', serif;font-weight: normal;src: url(" + fontRegularNameSerif + ");}"+\
	"@font-face {font-style: italic;font-family: '" + fontFamilyNameSerif +"', serif;font-weight: bold;src: url(" + fontBoldItalicNameSerif + ");}"+\
	"@font-face {font-style: normal;font-family: '" + fontFamilyNameSerif +"', serif;font-weight: bold;src: url(" + fontBoldNameSerif + ");}"+\
	"@font-face {font-style: italic;font-family: '" + fontFamilyNameMono +"', monospace;font-weight: normal;src: url(" + fontItalicNameMono + ");}"+\
	"@font-face {font-style: normal;font-family: '" + fontFamilyNameMono +"', monospace;font-weight: normal;src: url(" + fontRegularNameMono + ");}"+\
	"@font-face {font-style: italic;font-family: '" + fontFamilyNameMono +"', monospace;font-weight: bold;src: url(" + fontBoldItalicNameMono + ");}"+\
	"@font-face {font-style: normal;font-family: '" + fontFamilyNameMono +"', monospace;font-weight: bold;src: url(" + fontBoldNameMono + ");}"+\
	"@font-face {font-style: italic;font-family: '" + fontFamilyNameSans +"', sans-serif;font-weight: normal;src: url(" + fontItalicNameSans + ");}"+\
	"@font-face {font-style: normal;font-family: '" + fontFamilyNameSans +"', sans-serif;font-weight: normal;src: url(" + fontRegularNameSans + ");}"+\
	"@font-face {font-style: italic;font-family: '" + fontFamilyNameSans +"', sans-serif;font-weight: bold;src: url(" + fontBoldItalicNameSans + ");}"+\
	"@font-face {font-style: normal;font-family: '" + fontFamilyNameSans +"', sans-serif;font-weight: bold;src: url(" + fontBoldNameSans + ");}"+\
	stylesheetcontent[insertplace:]

    namelist.remove('content.opf') 
    namelist.remove('stylesheet.css') 
    namelist.remove('mimetype')
    kwds = dict(compression=ZIP_DEFLATED, allowZip64=False)
# create the modified archive
    outfile = self.temporary_file("_fe_plugin.epub")
    with closing(ZipFile(outfile, 'w', **kwds)) as outf:
	# output mimetype uncompressed and first
        zi = inf.getinfo('mimetype')
        zi.compress_type = ZIP_STORED
        outf.writestr(zi, inf.read('mimetype'))
	# then write other files
	outf.writestr('content.opf', etree.tostring(content))
	outf.writestr('stylesheet.css', newstylesheetcontent)
	outf.write(fontPath + fontRegularNameSerif, fontRegularNameSerif)
	outf.write(fontPath + fontItalicNameSerif, fontItalicNameSerif)
	outf.write(fontPath + fontBoldItalicNameSerif, fontBoldItalicNameSerif)
	outf.write(fontPath + fontBoldNameSerif, fontBoldNameSerif)
	outf.write(fontPath + fontRegularNameMono, fontRegularNameMono)
	outf.write(fontPath + fontItalicNameMono, fontItalicNameMono)
	outf.write(fontPath + fontBoldItalicNameMono, fontBoldItalicNameMono)
	outf.write(fontPath + fontBoldNameMono, fontBoldNameMono)
	outf.write(fontPath + fontRegularNameSans, fontRegularNameSans)
	outf.write(fontPath + fontItalicNameSans, fontItalicNameSans)
	outf.write(fontPath + fontBoldItalicNameSans, fontBoldItalicNameSans)
	outf.write(fontPath + fontBoldNameSans, fontBoldNameSans)


        for path in namelist:
            data = inf.read(path)
            outf.writestr(path,  data) 

# workaround for calibre bug
# copy the modified file in the place of original ebook
    shutil.copyfile(outfile.name, path_to_ebook)
    return path_to_ebook