tmp = function() {
	var log = Core.log.getLogger("addons1");

	// Checks if string ends with given postfix
	//
	var endsWith = function(str, postfix) {
		return str.lastIndexOf(postfix) === str.length - postfix.length;
	};

	// Returns array of files with given extension sorted by name
	//
	var listFiles = function(path, ext) {
		try {
			var iterator = new FileSystem.Iterator(path);
			try {
				var items = [];
				var item;
				while (item = iterator.getNext()) {
					if (item.type == "file") {
						var p = item.path;
						if (ext === undefined || endsWith(p, ext)) {
							items.push(p);
						}
					}
				}
				items.sort();
				return items;
			} finally {
				iterator.close();
			}
		} catch (e) {
			log.error("Error in list files, listing folder " + path + ": " + e);
		}
		return [];
	};


	// Loads file contents
	//
	var getFileContent = function(path) {
		try {
			var f = new Stream.File(path, 2);
			var result = f.toString();
			f.close();
			return result;
		} catch (e) {
			log.error("Error reading file " + path + ": " + e);
		}
		return "";
	};

	// Loads file, or, if path points to a folder, combined content of the files in folder, with extention <ext>
	//
	var getFileContentEx = function(path, ext) {
		var info = FileSystem.getFileInfo(path);
		if (info && info.type == "directory") {
			var files = listFiles(path, ext);
			var result = "";
			for (var i = 0, n = files.length; i < n; i++) {
				result = result + getFileContent(path + files[i]);
			}
			return result;
		}
		return getFileContent(path);
	}

	// Call addons
	var addonCode = getFileContentEx(Core.config.addonsFile1, ".js");
	var addons = new Function("Core,log,tmp", addonCode);
	addons(Core, log, undefined);
	delete addonCode;
	delete addons;
};
try {
	tmp();
} catch (e) {
	// Core's log
	log.error("in addons1.js", e);
}