//virtual keyboard public object
VirtualKeyboard = new Object();
//public methods:
//VirtualKeyboard.Activate = function(from,kbdView)
//VirtualKeyboard.Deactivate = function()

var tmp = function() {
    kbdDefinition = function(name, shortName, def) {
        this.Name = name;
        this.ShortName = shortName;
        this.Definition = def;
    };

    //  private variables
    var _fromObj;           //user object activating keyboard.
    var _kbdView;           //visual representation of keyboard
    var _origDrivers;       //original button drivers
    var _inpBuffer;         //input buffer
    var _fstDigit;          //first digit; -1 == there is not 1st digit
    var _kbdList = Array(); //list of keyboard drivers
    var _actKeyboard;       //actually active keyboard
    var _kbdLineSelector;   //selected line
    var _KeybordSwithLine;  //line of keyboard switcher

    //prepare several keyboards
    _kbdList.push(new kbdDefinition('Simple', 'smpl', [
        ['1', '2', '3', '4', '5', '6', '7', '8', '9', '0'],
        ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'],
        ['k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't'],
        ['u', 'v', 'w', 'x', 'y', 'z', ' ', 'h1', 'i1', 'CLR']
    ]));
    _kbdList.push(new kbdDefinition('Letters', 'abc', [
        ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'],
        ['k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't'],
        ['u', 'v', 'w', 'x', 'y', 'z', ' ', 'h1', 'i1', 'CLR']
    ]));
    _kbdList.push(new kbdDefinition('Digits', '123', [
        ['1', '2', '3', '4', '5', '6', '7', '8', '9', '0']
    ]));
    _kbdList.kbdDefault = _kbdList[0];

    //save original button driver and set new one
    var installDriver = function(from, name) {
        _origDrivers[name] = from[name];
        from[name] = this['fg_' + name];
    };
    //helper function to transform array index to row/column number
    var arr2ndx = function(n) {
        return (n + 1) % 10;
    };
    //helper function to transform row/column number to array index
    var ndx2arr = function(n) {
        if (n == 0) return 9;
        return n - 1;
    };
    //activate keyboard layout
    var setKeyboard = function(kbd) {
        _actKeyboard = kbd;
        _kbdView.kbdDoc.KBD_GROUP.kbdTitle.setValue(kbd.Name);
        //set keyboard lines
        for (var line = 0; line < 10; line++) {
            var lineObj = _kbdView.kbdDoc.KBD_GROUP['line' + arr2ndx(line)];
            if (line in kbd.Definition) {
                lineObj.show(true);
                setKeyboardLine(lineObj, line + 1, kbd.Definition[line]);
                if ((line % 2) == 0) {
                    lineObj.kbdLine.KBD_LINE_GROUP.kbdLineLight.show(true);
                } else {
                    lineObj.kbdLine.KBD_LINE_GROUP.kbdLineDark.show(true);
                }
            } else {
                lineObj.show(false);
            }
        }
        //set language line
        var lngLine = kbd.Definition.length;
        _KeybordSwithLine = this.arr2ndx(lngLine);
        var kbdLngLine = _kbdView.kbdDoc.KBD_GROUP['line' + _KeybordSwithLine];
        if ((lngLine % 2) == 0) {
            kbdLngLine.kbdLine.KBD_LINE_GROUP.kbdLineLight.show(true);
        } else {
            kbdLngLine.kbdLine.KBD_LINE_GROUP.kbdLineDark.show(true);
        }
        kbdLngLine.show(true);
        kbdLngLine.kbdLine.KBD_LINE_GROUP.lineName.setValue('0');
        for (var col = 0; col < 10; col++) {
            var colNdx = this.arr2ndx(col);
            var colObj = kbdLngLine.kbdLine.KBD_LINE_GROUP['col' + colNdx];
            if (col in _kbdList) {
                colObj.setValue(_kbdList[col].ShortName);
            } else {
                colObj.setValue('');
            }
        }
        //resize keyboard - why the hell it does not work???
        //        var kbdY, ln0Y, ln0H;
        //        kbdY = _kbdView.getY();
        //        ln0Y = _kbdView.kbdDoc.KBD_GROUP.line1.getY();
        //        ln0H = _kbdView.kbdDoc.KBD_GROUP.line1.getHeight();
        //        _kbdView.changeLayout(100, undefined, 100, 50, 500, undefined);
    };

}; 

try {
    tmp();
} catch (e) {
    // Core's log
    log.error("in VK.js", e);
}
