/*
 * Decompiled with CFR 0.152.
 */
package common.utils;

import java.io.File;
import java.util.ArrayList;

public class ExtFilter {
    public static final String TYPE_VIDEO = "video";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_ZIP = "zip";
    public static final String TYPE_RAR = "rar";
    public static final String TYPE_ARCHIVE = "archive";
    private String[] video_filter_ext;
    private String[] image_filter_ext;
    private String[] zip_filter_ext;
    private String[] rar_filter_ext;
    ArrayList<String> filter;

    public ExtFilter(String type) {
        block7: {
            block10: {
                block9: {
                    block8: {
                        block6: {
                            this.video_filter_ext = new String[]{".3g2", ".3gp", ".3gp2", ".3gpp", ".3mm", ".amv", ".as", ".asx", ".avb", ".avi", ".avs", ".bin", ".bsf", ".dat", ".divx", ".dv", ".dvx", ".flv", ".hkm", ".m1pg", ".m1v", ".m21 ", ".m21", ".m2", ".m2t ", ".m2ts", ".m2v", ".m4e", ".m4u", ".m4v ", ".mgv ", ".mj2", ".mjp", ".mjpg", ".mkv", ".mov", ".movie", ".mp21", ".mp21", ".mp2v", ".mp4 ", ".mp4v", ".mpe", ".mpeg", ".mp", ".mpg2", ".mpv2", ".mqv", ".mts", ".ogm", ".ogv", ".pmf", ".qt", ".rec", ".rm", ".rmvb", ".rts", ".rv", ".swf", ".tivo", ".vc1", ".vid", ".wmv", ".xvid"};
                            this.image_filter_ext = new String[]{".ai", ".dxf", ".emf", ".emz", ".eps", ".exif", ".fig", ".fxg", ".gif", ".icon", ".j", ".j2c", ".j2k", ".jng ", ".jp2", ".jpc", ".jpe", ".jpeg", ".jpf", ".jpg", ".jpw", ".jpx", ".jtf", ".pbm", ".pct", ".pcx", ".pgm", ".pic", ".png", ".pnt", ".ppm", ".ps", ".psb", ".psd", ".qif", ".qti", ".qtif", ".raw", ".rgb", ".rif", ".thm", ".thumb", ".tif", ".tiff"};
                            this.zip_filter_ext = new String[]{".zip", ".cbz"};
                            this.rar_filter_ext = new String[]{".rar", ".cbr"};
                            this.filter = new ArrayList();
                            if (!type.equals(TYPE_VIDEO)) break block6;
                            int i = 0;
                            while (i < this.video_filter_ext.length) {
                                this.filter.add(this.video_filter_ext[i]);
                                ++i;
                            }
                            break block7;
                        }
                        if (!type.equals(TYPE_IMAGE)) break block8;
                        int i = 0;
                        while (i < this.image_filter_ext.length) {
                            this.filter.add(this.image_filter_ext[i]);
                            ++i;
                        }
                        break block7;
                    }
                    if (!type.equals(TYPE_ZIP)) break block9;
                    int i = 0;
                    while (i < this.zip_filter_ext.length) {
                        this.filter.add(this.zip_filter_ext[i]);
                        ++i;
                    }
                    break block7;
                }
                if (!type.equals(TYPE_RAR)) break block10;
                int i = 0;
                while (i < this.rar_filter_ext.length) {
                    this.filter.add(this.rar_filter_ext[i]);
                    ++i;
                }
                break block7;
            }
            if (!type.equals(TYPE_ARCHIVE)) break block7;
            int i = 0;
            while (i < this.zip_filter_ext.length) {
                this.filter.add(this.zip_filter_ext[i]);
                ++i;
            }
            i = 0;
            while (i < this.rar_filter_ext.length) {
                this.filter.add(this.rar_filter_ext[i]);
                ++i;
            }
        }
    }

    public boolean isValid(String extension) {
        return this.filter.contains(extension);
    }

    public boolean isValid(File fh) {
        String fh_ext = ExtFilter.getExtension(fh);
        return this.isValid(fh_ext);
    }

    public static String getExtension(File fh) {
        String fh_name = fh.getName();
        int last_period_index = fh_name.lastIndexOf(46);
        if (last_period_index == -1 || last_period_index == fh_name.length() - 1) {
            return null;
        }
        return fh_name.substring(last_period_index);
    }

    public static String getNameWithoutExtension(File fh) {
        String fh_name = fh.getName();
        String extension = ExtFilter.getExtension(fh);
        return fh_name.substring(0, fh_name.length() - extension.length());
    }
}

