// Description: Dictionary by Celemenseken & Lisak & m-land 
// History: 
//      2010-05-18 kartu - Uploaded scrolling fixes by m-land 
//      2010-05-20 kartu - Fixed flickering caused by hourglass 
// 
var Core = params.Core;
log = params.log;
//dictionary files 
var dictPath = params.dictPath; //"/Data/database/system/PRSPlus/dictionary/"; //directory with dictionaries 
var lineNo = 0; //a line number with the result of the last search 
var xCol = 1; //starting position of the cursor - at the middle column
var fnPageScroll;

//Three button selection mode: if true, left arrow: left column, up arrow: up column, right arrow: right column 
//otherwise: up arrow: previous term, left arrow - move cursor to left, right arrow - move cursor to the right 
//target.threeButton = true; 
var threeButton = false;

//map of special function keys 
var keyMap = [
         ['', 'CLR', 'BS'],
         ['a', 'b', 'c'],
         ['d', 'e', 'f'],
         ['g', 'h', 'i'],
         ['j', 'k', 'l'],
         ['m', 'n', 'o'],
         ['p', 'q', 'r'],
         ['s', 't', 'u'],
         ['v', 'w', 'x'],
         ['y', 'z', ' ']
 ];

//return file's content in a string 
var fileToString = function(path) {
    return Core.io.getFileContent(path, null);
};

//put text into /tmp/script.sh and run it 
var runCommand = function(text) {
    Core.shell.exec(text);
};

//run a command and return the result 
var runCommandResult = function(text) {
    var tmpf = "/tmp/__dict_result__";
    runCommand(text + " >" + tmpf);

    var res = fileToString(tmpf);
    this.issue = res;

    FileSystem.deleteFile(tmpf);
    return res;
};

//DICTIONARY FUNCTIONS
target.init = function() {
    this.changeResultsSize(params.resultSize);
};

target.exitApp = function() {
    kbook.autoRunRoot.exitIf(kbook.model);
};

target.clearInput = function() {
    this.inputLine.setValue('');
    this.log.setValue("");  //@@@
};
target.myLog = function(x) {
    this.log.setValue(this.log.getValue() + '\n' + x);
};

target.clearStatus = function() {
    this.statusLine.setValue('');
};

target.clearLines = function() {
    this.textlines.setValue('');  
};

//shows/hides hourglass 
target.showHourGlass = function(show) {
    this.hourGlass.show(show);
    this.hourGlass.invalidate();
    if (show) {
        // Force screen update 
        FskUI.Window.update.call(kbook.model.container.getWindow());
    }
};

target.changeResultsSize = function(s){
    try {
        var te = Core.system.getSoValue(this.textlines, 'te');
        var stf = Core.system.getSoValue(te, 'setTextFormat');
        var sk = Core.system.getSoValue(this.textlines, 'skin');
        var styles = Core.system.getSoValue(sk, 'styles');
        var style = styles[0];
        var ssize = Core.system.getSoValue(style, 'size');
        Core.system.setSoValue(style, 'size', s);
        stf.call(te, style);
        var textinv = Core.system.getSoValue(this.textlines, 'invalidate');
        textinv.call(this.textlines);
    }
    catch (e) {
        //this.myLog("E:" + e);
    }
};

target.changeSize = function() {
    try {
        //this.myLog("S1");
    }
    catch (e) {
    //    this.myLog("E:" + e);
    }
};
target.doSmartZoom = function() {
    try {
        var gs = Core.system.getSoValue(this.textlines, 'getSize');
        var gr = Core.system.getSoValue(this.textlines, 'getRange');
        var sz = gs.call(this.textlines, true);
        var ra = gr.call(this.textlines, true);
        if (sz >= ra) {
            return;
        } else {
            var ratio = 100 - sz * 100 / ra;
            if (ratio > params.maxSmartZoom) {
                ratio = params.maxSmartZoom;
            }
            var resRetio = params.resultSize * (1 - ratio / 100);
            this.changeResultsSize(resRetio);
        }
    }
    catch (e) {
       //this.myLog("E:" + e);
    }
};

target.txtFormat = function(txt) {
    if (params.maxSmartZoom > 0) {
        this.textlines.setValue('');
        this.changeResultsSize(params.resultSize);
    }
    var myLines;
    var szBul = '*';
    myLines = szBul + txt.replace('\t', '\n' + szBul);
    this.textlines.setValue(myLines);
    if (params.maxSmartZoom > 0) {
        this.doSmartZoom();
    }
};

target.doNewScroll = function(by) {
    try {
        var fnPageScroll = Core.system.getSoValue(this.textlines, 'scrollPage');
        fnPageScroll.call(this.textlines, true, by);
    }
    catch (e) {
        //   this.myLog('Err:' + e);
    }
};

//move cursor in columns (xCol: 0, 1 or 2) 
target.moveCursor = function(direction) {
    if (direction == "left") {
        if (--xCol < 0) {
            xCol = 2;
        }
    }
    if (direction == "right") {
        if (++xCol > 2) {
            xCol = 0;
        }
    }

    this.lineCursor.changeLayout(457 + xCol * 48, undefined, undefined, 627, undefined, undefined);
};
//move cursor in columns (xCol: 0, 1 or 2)
target.arrowKey = function(button) {
    if (button == "left") {
        if (threeButton) {
            xCol = 0;
        } else {
            //lookup previous dict. line 
            this.findNeighbour(-1);
        }
    }
    if (button == "right") {
        if (threeButton) {
            xCol = 2;
        } else {
            //lookup next dict. line 
            this.findNeighbour(1);
        }
    }

    if (button == "up") {
        this.doNewScroll(-1);
    }

    if (button == "down") {
        this.doNewScroll(1);
    }

    this.lineCursor.changeLayout(457 + xCol * 48, undefined, undefined, 627, undefined, undefined);
};

//select a letter/function w/ function keys (key: 0..9) 
target.pressDigit = function(digit) {
    var button = keyMap[digit][xCol];
    var processed = false; //has the key been processed? ('catch all letters') 

    if (button === '') {
        return;
    }

    if (button == 'BS') {
        //backspace 
        var input = this.inputLine.getValue();
        this.inputLine.setValue(input.slice(0, input.length - 1));
        processed = true;
    }

    if (button == 'CLR') {
        //clear all text from inputLine 
        processed = true;
        this.clearInput();
        this.clearLines();
    }

    if (!processed) {
        //letter 
        this.inputLine.setValue(this.inputLine.getValue() + button);
    }
};


target.searchTerm = function(term) {
    this.showHourGlass(true);

    //I cannot access memory card from the shell (for the moment), so I have to have dictionary copied to internal memory 
    var scriptLine = "/bin/grep -n -i '^" + term + "' " + dictPath + " | head -n 1";
    var res = runCommandResult(scriptLine);

    this.showHourGlass(false);
    if (res != '') {
        try {
            //get leading line number (separated by colon) 
            var colonIdx = res.indexOf(':');
            lineNo = Number(res.slice(0, colonIdx));

            //get term (separated by two spaces) 
            var termIdx = res.search('  ');
            term = res.slice(colonIdx + 1, termIdx);
            this.inputLine.setValue(term);

            //get defintion 
            var definition = res.slice(termIdx + 2, res.length - 1);
            this.txtFormat(definition);
            //TODO: store original searched term 
        } catch (e) {
            var error = "Error searching for term: " + term + ": " + e;
            this.textlines.setValue(error);
        }
    } else {
        this.textlines.setValue('Word not found.\nPlease try again.');
    }
};

//perform a search or load a new dictionary: 
target.centerKey = function() {
    var input = this.inputLine.getValue();

    if (input == '') {
        this.clearLines();
        this.textlines.setValue('Please type some text before pressing Enter.');
        return;
    }

    this.searchTerm(this.inputLine.getValue());
};

//previous/next line. offset = distance from original line 
target.findNeighbour = function(offset) {
    var newLineNo = lineNo + offset;

    var scriptLine = "/bin/sed -n '" + newLineNo + "p' " + dictPath;
    var res = runCommandResult(scriptLine);

    if (res == '') {
        //before first or after last line 
        this.statusLine.setValue('No line found - end of dictionary?');
        return;
    }

    lineNo = newLineNo;
    //get term (separated by two spaces) 
    var termIdx = res.search('  ');
    var term = res.slice(0, termIdx);
    this.inputLine.setValue(term);
    //get defintion 
    var definition = res.slice(termIdx + 2, res.length - 1);
    this.txtFormat(definition);
}; 
 