/*
 * Decompiled with CFR 0.152.
 */
package pdfreflow;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jdesktop.layout.GroupLayout;
import pdfreflow.HelpDialog;
import pdfreflow.ReadErr;
import pdfreflow.ReadIO;

public class uiframe
extends JFrame {
    private String pdftohtml = null;
    private String pdfreflow = null;
    private boolean haderror = false;
    private File pwd = null;
    public static boolean windows = false;
    private String savedpagenum = null;
    boolean useragright;
    boolean usenonfiction;
    String topnum;
    String bottomnum;
    String firstpagenum;
    String lastpagenum;
    String centernum;
    String shortlinenum;
    String dontreflowval;
    private static String[] envp = null;
    private static String arg1 = null;
    private static String jdir = "";
    private HelpDialog help = null;
    private JTextField bottom;
    private JTextField center;
    private JTextField dontreflow;
    private JTextField firstpage;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JTextField lastpage;
    private JTextField line;
    private JCheckBox nonfiction;
    private JTextArea output;
    private JTextField pageno;
    private JTextField pdfname;
    private JCheckBox ragright;
    private JTextField shortline;
    private JLabel status;
    private JTextField top;

    public uiframe() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.pdfname = new JTextField();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.output = new JTextArea();
        this.ragright = new JCheckBox();
        this.jButton2 = new JButton();
        this.status = new JLabel();
        this.pageno = new JTextField();
        this.jButton3 = new JButton();
        this.jLabel2 = new JLabel();
        this.top = new JTextField();
        this.jLabel3 = new JLabel();
        this.bottom = new JTextField();
        this.jLabel4 = new JLabel();
        this.firstpage = new JTextField();
        this.lastpage = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.dontreflow = new JTextField();
        this.jLabel7 = new JLabel();
        this.center = new JTextField();
        this.nonfiction = new JCheckBox();
        this.jLabel8 = new JLabel();
        this.line = new JTextField();
        this.jLabel9 = new JLabel();
        this.shortline = new JTextField();
        this.jButton4 = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("PDF Reflow");
        this.jLabel1.setText("PDF Document:");
        this.jLabel1.setToolTipText("PDF Document to reflow");
        this.pdfname.setToolTipText("PDF Document to reflow");
        this.pdfname.setName("");
        this.jButton1.setText("Open...");
        this.jButton1.setToolTipText("Open a PDF document to reflow");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                uiframe.this.jButton1ActionPerformed(evt);
            }
        });
        this.output.setColumns(20);
        this.output.setFont(new Font("Courier New", 0, 13));
        this.output.setLineWrap(true);
        this.output.setRows(5);
        this.output.setToolTipText("");
        this.jScrollPane1.setViewportView(this.output);
        this.ragright.setText("Rag Right");
        this.ragright.setToolTipText("Text is rag right (not justified)");
        this.jButton2.setText("Reflow");
        this.jButton2.setToolTipText("Reflow the PDF document");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                uiframe.this.jButton2ActionPerformed(evt);
            }
        });
        this.status.setForeground(new Color(255, 255, 255));
        this.status.setText(" ");
        this.pageno.setToolTipText("Page number to be show");
        this.pageno.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                uiframe.this.pagenoActionPerformed(evt);
            }
        });
        this.jButton3.setText("Show Page");
        this.jButton3.setToolTipText("Show page contents to discover line number");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                uiframe.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Crop Top:");
        this.jLabel2.setToolTipText("Crop text less than or equal to this Y position");
        this.top.setToolTipText("Crop text less than or equal to this Y position");
        this.top.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                uiframe.this.topActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Crop Bottom:");
        this.jLabel3.setToolTipText("Crop text greater than or equal to this Y position");
        this.bottom.setToolTipText("Crop text greater than or equal to this Y position");
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("First Page:");
        this.jLabel4.setToolTipText("First page to reflow (default is 1)");
        this.firstpage.setToolTipText("First page to reflow (default is 1)");
        this.lastpage.setToolTipText("Last page to reflow (default is last page of document)");
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Last Page:");
        this.jLabel5.setToolTipText("Last page to reflow (default is last page of document)");
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("Don't Reflow:");
        this.jLabel6.setToolTipText("Page ranges to not reflow, ie 1,3-5,12-15");
        this.dontreflow.setToolTipText("Page ranges to not reflow, ie 1,3-5,12-15");
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Center Page:");
        this.jLabel7.setToolTipText("Page with centered line");
        this.center.setToolTipText("Page with centered line");
        this.nonfiction.setText("Nonfiction");
        this.nonfiction.setToolTipText("Non fiction text");
        this.nonfiction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                uiframe.this.nonfictionActionPerformed(evt);
            }
        });
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("Line:");
        this.jLabel8.setToolTipText("Line number of centered text");
        this.line.setToolTipText("Line number of centered text");
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText("Short Line:");
        this.jLabel9.setToolTipText("Cutoff in percentage for end of paragraph (0-100). Using 0 gives a good default value.");
        this.shortline.setToolTipText("Cutoff in percentage for end of paragraph (0-100). Using 0 gives a good default value.");
        this.jButton4.setText("Help");
        this.jButton4.setToolTipText("Show online help");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                uiframe.this.jButton4ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.jScrollPane1, -1, 738, Short.MAX_VALUE).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(this.jButton3).add(this.jLabel1).add(this.jLabel2).add(this.jLabel4)).addPreferredGap(0).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(this.firstpage, -2, 50, -2).add(this.pageno, -2, 50, -2).add(this.top, -2, 50, -2)).add(8, 8, 8).add(layout.createParallelGroup(1).add(2, this.jLabel3).add(2, this.jLabel5, -2, 70, -2).add(2, this.jLabel9)).addPreferredGap(0).add(layout.createParallelGroup(4).add(this.bottom, -2, 50, -2).add(this.lastpage, -2, 50, -2).add(this.shortline, -2, 50, -2)).add(2, 2, 2).add(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(2, 2, 2).add(layout.createParallelGroup(1).add(2, this.jButton1).add(layout.createParallelGroup(2).add(1, layout.createSequentialGroup().add(this.jLabel7).addPreferredGap(0).add(this.center, -2, 63, -2).addPreferredGap(1).add(this.jLabel8).addPreferredGap(0).add(this.line, -1, 188, Short.MAX_VALUE)).add(1, layout.createSequentialGroup().add(this.jLabel6).addPreferredGap(0).add(this.dontreflow, -1, 299, Short.MAX_VALUE)))).add(3, 3, 3)).add(layout.createSequentialGroup().add(this.nonfiction).addPreferredGap(0).add(this.ragright).addPreferredGap(0).add(this.status, -2, 14, -2).addPreferredGap(1).add(this.jButton4).addPreferredGap(0).add(this.jButton2).add(10, 10, 10)))).add(layout.createSequentialGroup().add(this.pdfname, -1, 508, Short.MAX_VALUE).add(93, 93, 93))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(3).add(this.jLabel1).add(this.pdfname, -2, -1, -2).add(this.jButton1)).add(2, 2, 2).add(layout.createParallelGroup(1).add(layout.createParallelGroup(3).add(this.jLabel2).add(this.jLabel3).add(this.top, -2, -1, -2)).add(this.bottom, -2, -1, -2).add(layout.createParallelGroup(3).add(this.dontreflow, -2, -1, -2).add(this.jLabel6))).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.lastpage, -2, -1, -2).add(this.jLabel5).add(this.jLabel7).add(this.center, -2, -1, -2).add(this.jLabel4).add(this.jLabel8).add(this.line, -2, -1, -2).add(this.firstpage, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(1).add(layout.createParallelGroup(3).add(this.jButton3).add(this.pageno, -2, -1, -2)).add(layout.createParallelGroup(3).add(this.shortline, -2, -1, -2).add(this.jLabel9).add(this.nonfiction).add(this.jButton4).add(this.jButton2).add(this.ragright).add(this.status))).addPreferredGap(0).add(this.jScrollPane1, -1, 293, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.bottom, this.dontreflow, this.top}, 2);
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("PDF Documents", "pdf");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            this.pdfname.setText(file.getPath());
        }
    }

    private void alert(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Alert", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printerror(InputStream stream) throws UnsupportedEncodingException, IOException {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            stream.close();
        }
        this.output.setText(sb.toString());
    }

    private String ats(String[] a) {
        int len = a.length;
        String s = "";
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                s = s + " ";
            }
            s = s + a[i];
        }
        return s;
    }

    private int initXML(String docname) {
        int retval = -1;
        Object stream = null;
        boolean ismac = jdir.length() > 0;
        String[] cmd = ismac ? new String[]{jdir + "pdftohtml", "-xml", "-q", docname} : new String[]{jdir + "pdftohtml", "-xml", docname};
        try {
            String p = envp == null ? "" : envp[0] + " ";
            System.out.println(p + this.ats(cmd));
            Process process = Runtime.getRuntime().exec(cmd, envp, this.pwd);
            ReadIO rio = new ReadIO(process.getInputStream(), this.status);
            ReadErr rerr = ismac ? new ReadErr(process.getErrorStream(), null) : new ReadErr(process.getErrorStream(), this.output);
            rerr = new ReadErr(process.getErrorStream(), this.output);
            Thread out = new Thread(rio);
            Thread err = new Thread(rerr);
            out.start();
            err.start();
            retval = process.waitFor();
            out.join();
            err.join();
            if (!ismac) {
                this.haderror = rerr.haderror;
            }
        }
        catch (IOException e) {
            this.alert("IO Alert:" + e.toString());
        }
        catch (InterruptedException e) {
            this.alert("IO Alert:" + e.toString());
        }
        return retval;
    }

    String validint(String s, String err) throws NumberFormatException {
        Integer val;
        if (s.length() == 0) {
            return null;
        }
        try {
            val = new Integer(s);
        }
        catch (NumberFormatException e) {
            this.alert(err + s);
            throw e;
        }
        return val.toString();
    }

    private int countargs() throws NumberFormatException {
        int args = 2;
        this.useragright = this.ragright.isSelected();
        if (this.useragright) {
            ++args;
        }
        this.usenonfiction = this.nonfiction.isSelected();
        if (this.usenonfiction) {
            ++args;
        }
        if (this.savedpagenum != null) {
            ++args;
        }
        this.topnum = this.validint(this.top.getText(), "Invalid Top Y value: ");
        if (this.topnum != null) {
            ++args;
        }
        this.bottomnum = this.validint(this.bottom.getText(), "Invalid Bottom Y value: ");
        if (this.bottomnum != null) {
            ++args;
        }
        this.firstpagenum = this.validint(this.firstpage.getText(), "Invalid First page: ");
        if (this.firstpagenum != null) {
            ++args;
        }
        this.lastpagenum = this.validint(this.lastpage.getText(), "Invalid Last page: ");
        if (this.lastpagenum != null) {
            ++args;
        }
        this.shortlinenum = this.validint(this.shortline.getText(), "Invalid Short Line: ");
        if (this.shortlinenum != null) {
            int val = new Integer(this.shortlinenum);
            if (val < 0 || val > 100) {
                this.alert("Short Line must be between 0 and 100");
                throw new NumberFormatException();
            }
            ++args;
        }
        String centertmp = this.validint(this.center.getText(), "Invalid Center page: ");
        String linenum = this.validint(this.line.getText(), "Invalid Center line: ");
        if (centertmp != null && linenum == null) {
            this.alert("Missing Line number");
            throw new NumberFormatException();
        }
        if (centertmp == null && linenum != null) {
            this.alert("Missing Center Page number");
            throw new NumberFormatException();
        }
        String string = this.centernum = centertmp != null && linenum != null ? centertmp + ":" + linenum : null;
        if (this.centernum != null) {
            ++args;
        }
        this.dontreflowval = this.dontreflow.getText();
        if (this.dontreflowval != null) {
            this.dontreflowval = this.dontreflowval.trim();
            if (this.dontreflowval.length() == 0) {
                this.dontreflowval = null;
            }
        }
        if (this.dontreflowval != null) {
            ++args;
        }
        return args;
    }

    private int runpdfreflow(String docname) throws NumberFormatException {
        String[] cmd = new String[this.countargs()];
        int retval = -1;
        InputStream stream = null;
        int arg = 0;
        cmd[arg++] = windows ? "pdfreflow.exe" : jdir + "pdfreflow";
        if (this.useragright) {
            cmd[arg++] = "--ragright";
        }
        if (this.usenonfiction) {
            cmd[arg++] = "--nonfiction";
        }
        if (this.savedpagenum != null) {
            cmd[arg++] = "--print=" + this.savedpagenum;
        }
        if (this.firstpagenum != null) {
            cmd[arg++] = "--first=" + this.firstpagenum;
        }
        if (this.lastpagenum != null) {
            cmd[arg++] = "--last=" + this.lastpagenum;
        }
        if (this.topnum != null) {
            cmd[arg++] = "--top=" + this.topnum;
        }
        if (this.bottomnum != null) {
            cmd[arg++] = "--bottom=" + this.bottomnum;
        }
        if (this.centernum != null) {
            cmd[arg++] = "--center=" + this.centernum;
        }
        if (this.shortlinenum != null) {
            cmd[arg++] = "--shortlines=" + this.shortlinenum;
        }
        if (this.dontreflowval != null) {
            cmd[arg++] = "--dontreflow=" + this.dontreflowval;
        }
        cmd[arg++] = docname;
        try {
            System.out.println(this.ats(cmd));
            Process process = Runtime.getRuntime().exec(cmd, envp);
            stream = process.getErrorStream();
            this.printerror(stream);
            retval = process.waitFor();
        }
        catch (IOException e) {
            this.alert("IO Alert:" + e.toString());
        }
        catch (InterruptedException e) {
            this.alert("IO Alert:" + e.toString());
        }
        return retval;
    }

    private void test() {
        int i;
        File dot = new File(".");
        String[] files = dot.list();
        String msg = "File in .: ";
        for (i = 0; i < files.length; ++i) {
            msg = msg + files[i] + " ";
        }
        System.out.println(msg);
        this.alert(msg);
        Map<String, String> map = System.getenv();
        Object[] set = map.keySet().toArray();
        msg = "Env: ";
        for (i = 0; i < set.length; ++i) {
            Object key = set[i];
            msg = msg + key + ":" + map.get(key) + " ";
        }
        System.out.println(msg);
        this.alert(msg);
        msg = "envp: ";
        for (i = 0; i < envp.length; ++i) {
            msg = msg + envp[i] + " ";
        }
        System.out.println(msg);
        this.alert(msg);
    }

    private static void setenv() {
        Map<String, String> map = System.getenv();
        ArrayList<String> list = new ArrayList<String>();
        String val = map.get("PATH");
        if (val != null) {
            String dir = arg1 == null ? "." : arg1;
            list.add("PATH=" + val + File.pathSeparator + dir);
            System.out.println((String)list.get(0));
        }
        if (list.size() != 0) {
            envp = new String[list.size()];
            uiframe.envp[0] = (String)list.get(0);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        String docname = this.pdfname.getText();
        int index = docname.lastIndexOf(".");
        boolean needXML = true;
        if (docname.length() == 0) {
            this.alert("Missing PDF Document.");
            this.output.setText("");
            return;
        }
        File file = new File(docname);
        if (!file.exists()) {
            this.alert(docname + " does not exist.");
            this.output.setText("");
            return;
        }
        String outname = docname.substring(0, index) + ".xml";
        File outfile = new File(outname);
        if (outfile.exists() && outfile.lastModified() > file.lastModified()) {
            needXML = false;
        }
        if (needXML) {
            if (this.initXML(docname) != 0) {
                this.alert("pdftohtml failed on " + docname);
                return;
            }
            if (this.haderror) {
                this.alert("pdftohtml bad output on " + docname);
                return;
            }
        }
        try {
            this.runpdfreflow(outname);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    private void pagenoActionPerformed(ActionEvent evt) {
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        Integer val;
        String pagenum = this.pageno.getText();
        try {
            val = new Integer(pagenum);
        }
        catch (NumberFormatException e) {
            this.alert("Invalid Page Number: " + pagenum);
            return;
        }
        this.savedpagenum = val.toString();
        this.jButton2ActionPerformed(evt);
        this.savedpagenum = null;
    }

    private void topActionPerformed(ActionEvent evt) {
    }

    private void nonfictionActionPerformed(ActionEvent evt) {
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        if (this.help == null) {
            this.help = new HelpDialog((Frame)this, false);
        } else {
            this.help.setVisible(true);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 1) {
                arg1 = args[0];
                jdir = arg1 + File.separator;
            }
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new uiframe().setVisible(true);
            }
        });
    }
}

