/*
 * Decompiled with CFR 0.152.
 */
package manga;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesLoader {
    private Properties props = new Properties();
    private File properties_file = null;
    private static String key_width = "width";
    private static String key_height = "height";
    private static String key_max_dpi = "max_dpi";
    private static String key_auto_trim = "auto_trim";
    private static String key_trim_fuzz = "trim_fuzz";
    private static String key_auto_rotate = "auto_rotate";
    private static String key_color_mode = "color_mode";
    private static String key_num_colors = "num_colors";
    private static String key_page_filename_length = "page_filename_length";
    private static String key_output_base_folder = "output_base_folder";
    private static String key_del_output_image_folders = "del_output_image_folders";
    private static String key_pdf = "pdf";
    private static String key_pdf_r_to_l = "pdf_r_to_l";
    private static String key_zip = "zip";
    private static String key_zip_format = "zip_format";
    private static String key_epub = "epub";
    private static String key_epub_r_to_l = "epub_r_to_l";
    private static String key_auto_bind = "auto_bind";
    private static String key_auto_bind_size = "auto_bind_size";
    private static String key_image_format = "image_format";
    private static String key_image_magick_dir = "image_magick_dir";
    private static String key_kindle_bookmark = "kindle_bookmark";
    private static String key_comic_zeal_naming = "comic_zeal_naming";

    public PropertiesLoader(File n_properties_file) {
        this.properties_file = n_properties_file;
        try {
            FileInputStream fis = new FileInputStream(this.properties_file);
            this.props.load(fis);
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PropertiesLoader(InputStream is) {
        try {
            this.props.load(is);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getWidth() {
        return this.intKeyValue(this.props.getProperty(key_width));
    }

    public int getHeight() {
        return this.intKeyValue(this.props.getProperty(key_height));
    }

    public int getMaxDPI() {
        return this.intKeyValue(this.props.getProperty(key_max_dpi));
    }

    public int getPageFilenameLength() {
        return this.intKeyValue(this.props.getProperty(key_page_filename_length));
    }

    public String getOutputBaseFolder() {
        return this.props.getProperty(key_output_base_folder).trim();
    }

    public boolean getDelOutputImageFolders() {
        return this.booleanKeyValue(this.props.getProperty(key_del_output_image_folders));
    }

    public boolean getAutoTrim() {
        return this.booleanKeyValue(this.props.getProperty(key_auto_trim));
    }

    public int getTrimFuzz() {
        return this.intKeyValue(this.props.getProperty(key_trim_fuzz));
    }

    public boolean getAutoRotate() {
        return this.booleanKeyValue(this.props.getProperty(key_auto_rotate));
    }

    public String getColorMode() {
        return this.props.getProperty(key_color_mode);
    }

    public int getNumColors() {
        return this.intKeyValue(this.props.getProperty(key_num_colors));
    }

    public boolean getPdf() {
        return this.booleanKeyValue(this.props.getProperty(key_pdf));
    }

    public boolean getPdfRToL() {
        return this.booleanKeyValue(this.props.getProperty(key_pdf_r_to_l));
    }

    public boolean getZip() {
        return this.booleanKeyValue(this.props.getProperty(key_zip));
    }

    public String getZipFormat() {
        return this.props.getProperty(key_zip_format);
    }

    public boolean getEpub() {
        return this.booleanKeyValue(this.props.getProperty(key_epub));
    }

    public boolean getEpubRToL() {
        return this.booleanKeyValue(this.props.getProperty(key_epub_r_to_l));
    }

    public boolean getAutoBind() {
        return this.booleanKeyValue(this.props.getProperty(key_auto_bind));
    }

    public int getAutoBindSize() {
        return this.intKeyValue(this.props.getProperty(key_auto_bind_size));
    }

    public String getImageFormat() {
        return this.props.getProperty(key_image_format);
    }

    public String getImageMagickDir() {
        return this.props.getProperty(key_image_magick_dir).trim();
    }

    public boolean getKindleBookmark() {
        return this.booleanKeyValue(this.props.getProperty(key_kindle_bookmark));
    }

    public boolean getComicZealNaming() {
        return this.booleanKeyValue(this.props.getProperty(key_comic_zeal_naming));
    }

    public int intKeyValue(String value) {
        value = value.trim();
        return Integer.parseInt(value);
    }

    public boolean booleanKeyValue(String value) {
        if ((value = value.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return false;
    }

    public void printProperties() {
        int width;
        if (this.properties_file != null) {
            System.out.println("\nUsing these settings stored in " + this.properties_file.getName() + ":");
        }
        if ((width = this.getWidth()) != -1) {
            System.out.println("  width (in pixels):  " + width);
        } else {
            System.out.println("  width (in pixels):  original");
        }
        int height = this.getHeight();
        if (height != -1) {
            System.out.println("  height (in pixels): " + height);
        } else {
            System.out.println("  height (in pixels): original");
        }
        System.out.println("  maximum dpi: " + this.getMaxDPI());
        boolean use_autotrim = this.getAutoTrim();
        System.out.println("  auto trim: " + use_autotrim);
        if (use_autotrim) {
            System.out.println("    trim fuzz: " + this.getTrimFuzz() + "%");
        }
        System.out.println("  auto rotate: " + this.getAutoRotate());
        System.out.println("  color mode: " + this.getColorMode());
        int num_colors = this.getNumColors();
        if (num_colors != -1) {
            System.out.println("  num colors: " + num_colors);
        } else {
            System.out.println("  num colors: full");
        }
        boolean use_pdf = this.getPdf();
        System.out.println("  pdf chapters: " + use_pdf);
        if (use_pdf) {
            System.out.println("    pdf r to l: " + this.getPdfRToL());
        }
        boolean use_zip = this.getZip();
        System.out.println("  zip chapters: " + use_zip);
        if (use_zip) {
            System.out.println("    zip format: " + this.getZipFormat());
        }
        boolean use_epub = this.getEpub();
        System.out.println("  epub chapters: " + use_epub);
        if (use_epub) {
            System.out.println("    epub r to l: " + this.getEpubRToL());
        }
        boolean use_auto_bind = this.getAutoBind();
        System.out.println("  auto bind: " + use_auto_bind);
        if (use_auto_bind) {
            System.out.println("    auto bind size: " + this.getAutoBindSize());
        }
        System.out.println("  delete output image folders: " + this.getDelOutputImageFolders());
        System.out.println("  image format: " + this.getImageFormat());
        System.out.println("  kindle bookmark: " + this.getKindleBookmark());
        System.out.println("  comic zeal naming: " + this.getComicZealNaming());
        System.out.println("  ImageMagick home directory: " + this.getImageMagickDir());
        System.out.println("");
    }
}

