/*
 * Decompiled with CFR 0.152.
 */
package manga;

import common.image.ImageMagick;
import common.utils.ExtFilter;
import common.utils.FileUtils;
import common.utils.JarUtils;
import common.utils.StopWatch;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import manga.CMPropertiesWriter;
import manga.EpubMaker;
import manga.PropertiesLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertManga {
    public static final String PROGRAM_VERSION = "1.71";
    private static String default_kindle_bookmark = "/manga/kindle/default.manga";

    public static void renamePages(File folder, int page_filename_length) {
        File cur_image;
        ArrayList<File> image_files = FileUtils.getImageFileList(folder);
        Collections.sort(image_files);
        ArrayList<File> cover_image_files = new ArrayList<File>();
        ArrayList<File> credit_image_files = new ArrayList<File>();
        int i = 0;
        while (i < image_files.size()) {
            cur_image = image_files.get(i);
            if (cur_image.getName().toLowerCase().contains("cover")) {
                image_files.remove(i);
                cover_image_files.add(cur_image);
                --i;
            } else if (cur_image.getName().toLowerCase().contains("credit")) {
                image_files.remove(i);
                credit_image_files.add(cur_image);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < cover_image_files.size()) {
            image_files.add(0, (File)cover_image_files.get(cover_image_files.size() - i - 1));
            ++i;
        }
        i = 0;
        while (i < credit_image_files.size()) {
            image_files.add((File)credit_image_files.get(i));
            ++i;
        }
        i = 0;
        while (i < image_files.size()) {
            cur_image = image_files.get(i);
            String extension = ExtFilter.getExtension(cur_image);
            String new_name = Integer.toString(i);
            while (new_name.length() < page_filename_length) {
                new_name = "0" + new_name;
            }
            File new_image = new File(String.valueOf(cur_image.getParent()) + File.separatorChar + new_name + extension);
            cur_image.renameTo(new_image);
            ++i;
        }
    }

    private static ArrayList<Integer> processBindFile(File bind_file) {
        ArrayList<Integer> binds = new ArrayList<Integer>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(bind_file));
            boolean done = false;
            while (!done) {
                String line = br.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                line = line.replaceAll(" ", "");
                if ((line = line.replaceAll("\t", "")).equals("") || line.charAt(0) == '#' || line.charAt(0) == '/') continue;
                binds.add(Integer.parseInt(line));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return binds;
    }

    private static void bindFolders(ArrayList<File> folders, File bind_folder, String output_folder_filename, ImageMagick im, String title, boolean use_zip, String zip_extension, boolean use_pdf, boolean pdf_r_to_l, boolean use_kindle_bookmark, boolean use_comic_zeal_naming, boolean use_epub, boolean epub_r_to_l, int page_filename_length) {
        if (folders.isEmpty() || folders.size() == 0) {
            return;
        }
        int next_starting_number = 0;
        int i = 0;
        while (i < folders.size()) {
            File cur_folder = folders.get(i);
            ArrayList<File> cur_folder_image_list = FileUtils.getImageFileList(cur_folder);
            Collections.sort(cur_folder_image_list);
            int j = 0;
            while (j < cur_folder_image_list.size()) {
                File cur_image = cur_folder_image_list.get(j);
                String extension = ExtFilter.getExtension(cur_image);
                String new_name = Integer.toString(next_starting_number + j);
                while (new_name.length() < page_filename_length) {
                    new_name = "0" + new_name;
                }
                try {
                    FileUtils.copyFile(cur_image, new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + new_name + extension));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            next_starting_number += cur_folder_image_list.size();
            ++i;
        }
        if (use_kindle_bookmark) {
            ArrayList<File> bind_folder_image_list = FileUtils.getImageFileList(bind_folder);
            Collections.sort(bind_folder_image_list);
            File bookmark_file = new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + bind_folder.getName() + ".manga");
            File bookmark_save_file = new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + bind_folder.getName() + ".manga_save");
            ConvertManga.writeBookmark(bind_folder, bookmark_file, bookmark_save_file, bind_folder_image_list.get(0));
        }
        String zip_file_filename = null;
        zip_file_filename = use_comic_zeal_naming ? String.valueOf(output_folder_filename) + title + "~" + bind_folder.getName() + zip_extension : String.valueOf(output_folder_filename) + bind_folder.getName() + zip_extension;
        File zip_file = new File(zip_file_filename);
        File pdf_file = new File(String.valueOf(output_folder_filename) + bind_folder.getName() + ".pdf");
        File epub_file = new File(String.valueOf(output_folder_filename) + bind_folder.getName() + ".epub");
        if (use_zip) {
            FileUtils.zipFolder(bind_folder, zip_file);
        }
        if (use_pdf) {
            if (pdf_r_to_l) {
                File tmp_r_to_l_folder = new File(String.valueOf(bind_folder.getParent()) + File.separatorChar + bind_folder.getName() + "_TMP_R_TO_L");
                ConvertManga.createFolderOfRToLPages(bind_folder, tmp_r_to_l_folder, page_filename_length);
                im.pdfImageFolder(tmp_r_to_l_folder, pdf_file);
                FileUtils.deleteDirectory(tmp_r_to_l_folder);
            } else {
                im.pdfImageFolder(bind_folder, pdf_file);
            }
        }
        if (use_epub) {
            EpubMaker em = new EpubMaker(bind_folder.getName(), epub_file, folders, page_filename_length, epub_r_to_l);
            em.makeEpub();
        }
    }

    public static void writeBookmark(File cur_dir, File bookmark_file, File bookmark_save_file, File first_file) {
        try {
            JarUtils ju = new JarUtils();
            ju.copyJarFileToFilesystem(default_kindle_bookmark, bookmark_file);
            BufferedWriter bw = new BufferedWriter(new FileWriter(bookmark_save_file));
            bw.write("LAST=/mnt/us/pictures/" + cur_dir.getName() + "/" + first_file.getName());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void outputUsage() {
        System.out.println("\nCanti 1.71, author: Andrew Mantel");
        System.out.println("Purpose: Convert a collection of manga scans for ereader devices such as the Kindle DX, Kindle 2, and iPad.");
        System.out.println("Usage: java -jar ConvertManga.jar [mandatory_arguments] [other_options]");
        System.out.println("\nMandatory Arguments: (these arguments MUST be specified)");
        System.out.println("-parent_folder /path/to/parent_folder/");
        System.out.println("  The parent folder containing subfolders representing chapters.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path (for example, \"C:\\\\Program Files\\\\manga parent folder\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("-title \"Manga Title\"");
        System.out.println("  Title of the manga, such as \"School Rumble\".");
        System.out.println("\nOther Options: (these are all optional)");
        System.out.println("-num_chars_keep_suffix [integer]");
        System.out.println("  Number of characters to keep from original subfolder suffix.");
        System.out.println("  If you do not set this or set this to -1, then the program will attempt to auto sense the suffix.");
        System.out.println("  Note that if using auto suffix sensing then each manga folder must end with a number such as 1, 001, 1.11, or 001.11 for this to work properly).");
        System.out.println("-manga_prefix \"[manga_prefix]\"");
        System.out.println("  This is placed after the manga title but before the subfolder suffix.");
        System.out.println("  Recommended value is something like \"Ch.\" or \"Vol.\" so that the output will look like \"School_Rumble_-_Ch.001\"");
        System.out.println("-bind_prefix \"[bind_prefix]\"");
        System.out.println("  This is places after the manga title but before the binding number of bound manga.");
        System.out.println("  Recommend value is something like \"Vol.\" or \"Bind.\" so that the output will look like \"School_Rumble_-_Vol.1\"");
        System.out.println("  If not specified, the default value is \"Vol.\"");
        System.out.println("-output_folder /path/to/output_folder/");
        System.out.println("  The output parent folder. If not specified, default is an \"OUT\" folder created one directory above -parent_folder.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path (for example, \"C:\\\\Program Files\\\\manga parent folder\\\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("\nCreating a default .properties file:");
        System.out.println("Usage: java -jar ConvertManga.jar -create_properties [device name]");
        System.out.println("  The program will create a default .properties file for you.");
        System.out.println("  No manga will be processed when you use this option. This will create the default .properties file and then exit.");
        System.out.println("  Acceptable [device name] values: kdx, k2, ipad");
        System.out.println("\nSee ConvertManga.properties for conversion settings.");
        System.out.println("\nSee readme.txt for manga organization requirements and other tips.");
        System.out.println("");
        System.exit(0);
    }

    private static boolean isFolderProcessed(File progress_file, File folder) {
        boolean found = false;
        String folder_path = folder.getAbsolutePath();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(progress_file));
            while (!found && (line = br.readLine()) != null) {
                if (!line.equals(folder_path)) continue;
                found = true;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return found;
    }

    private static void verifyProgressFile(File progress_file) {
        ArrayList<File> processed_folders = new ArrayList<File>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(progress_file));
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                processed_folders.add(new File(line));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<File> processed_folders_exists = new ArrayList<File>();
        int i = 0;
        while (i < processed_folders.size()) {
            File cur_processed_folder = (File)processed_folders.get(i);
            if (cur_processed_folder.exists()) {
                processed_folders_exists.add(cur_processed_folder);
            }
            ++i;
        }
        if (processed_folders_exists.size() < processed_folders.size()) {
            progress_file.delete();
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(progress_file));
                int i2 = 0;
                while (i2 < processed_folders_exists.size()) {
                    bw.write(String.valueOf(((File)processed_folders_exists.get(i2)).getAbsolutePath()) + "\n");
                    ++i2;
                }
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void addProcessedFolder(File progress_file, File folder) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(progress_file, true));
            bw.write(String.valueOf(folder.getAbsolutePath()) + "\n");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getFileNumberSuffix(File fh) {
        boolean done = false;
        boolean found_decimal = false;
        String filename = null;
        String suffix = "";
        filename = fh.isDirectory() ? fh.getName() : ExtFilter.getNameWithoutExtension(fh);
        int j = 0;
        while (!done && j < filename.length() - 1) {
            char cur_char = filename.charAt(filename.length() - 1 - j);
            if (cur_char == '.') {
                if (!found_decimal) {
                    suffix = String.valueOf(cur_char) + suffix;
                    found_decimal = true;
                } else {
                    done = true;
                }
            } else if (Character.isDigit(cur_char)) {
                suffix = String.valueOf(cur_char) + suffix;
            } else {
                done = true;
            }
            ++j;
        }
        String regex = "^0*";
        if ((suffix = suffix.replaceAll(regex, "")).length() >= 1 && suffix.charAt(0) == '.') {
            suffix = suffix.substring(1);
        }
        return suffix;
    }

    public static void createFolderOfRToLPages(File in_folder, File out_folder, int page_filename_length) {
        if (!out_folder.exists()) {
            out_folder.mkdir();
        }
        ArrayList<File> in_folder_images = FileUtils.getImageFileList(in_folder);
        Collections.sort(in_folder_images);
        int i = 0;
        while (i < in_folder_images.size()) {
            File cur_image = in_folder_images.get(i);
            String cur_image_ext = ExtFilter.getExtension(cur_image);
            String new_filename_noext = Integer.toString(in_folder_images.size() - 1 - i);
            while (new_filename_noext.length() < page_filename_length) {
                new_filename_noext = "0" + new_filename_noext;
            }
            File new_image = new File(String.valueOf(out_folder.getAbsolutePath()) + File.separatorChar + new_filename_noext + cur_image_ext);
            try {
                FileUtils.copyFile(cur_image, new_image);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static void createFolderOfRToLPages(ArrayList<File> in_folders, File out_folder, int page_filename_length) {
        if (!out_folder.exists()) {
            out_folder.mkdir();
        }
        Collections.sort(in_folders);
        int next_starting_number = 0;
        int i = 0;
        while (i < in_folders.size()) {
            File cur_in_folder = in_folders.get(in_folders.size() - 1 - i);
            ArrayList<File> cur_in_folder_images = FileUtils.getImageFileList(cur_in_folder);
            Collections.sort(cur_in_folder_images);
            int j = 0;
            while (j < cur_in_folder_images.size()) {
                File cur_image = cur_in_folder_images.get(j);
                String cur_image_ext = ExtFilter.getExtension(cur_image);
                String new_filename_noext = Integer.toString(cur_in_folder_images.size() - 1 - j + next_starting_number);
                while (new_filename_noext.length() < page_filename_length) {
                    new_filename_noext = "0" + new_filename_noext;
                }
                File new_image = new File(String.valueOf(out_folder.getAbsolutePath()) + File.separatorChar + new_filename_noext + cur_image_ext);
                try {
                    FileUtils.copyFile(cur_image, new_image);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            next_starting_number += cur_in_folder_images.size();
            ++i;
        }
    }

    public static void main(String[] args) throws IOException {
        int i;
        boolean use_auto_bind;
        char cur_char;
        int j;
        boolean done;
        String cur_suffix;
        File cur_folder;
        ExtFilter zip_filter;
        String parent_folder_filename = null;
        String output_folder_filename = null;
        String title = null;
        String manga_prefix = "";
        String bind_prefix = "Vol.";
        String prefix = null;
        File progress_file = null;
        File bind_file = null;
        File parent_folder_file = null;
        File output_folder_file = null;
        File properties_file = new File("ConvertManga.properties");
        boolean use_bind = false;
        boolean single_folder_mode = false;
        boolean auto_sense_suffix = false;
        int num_chars_keep_suffix = -1;
        PropertiesLoader pl = null;
        ArrayList<Object> binds = new ArrayList();
        ArrayList<String> suffixes = new ArrayList<String>();
        if (args.length == 0) {
            ConvertManga.outputUsage();
        } else if (args.length % 2 != 0) {
            System.out.println("ERROR: Invalid number of arguments.");
            ConvertManga.outputUsage();
        } else if (args.length == 2 && args[0].equalsIgnoreCase("-create_properties")) {
            String device = args[1].trim().toLowerCase();
            System.out.println("\nWriting .properties file for " + device + " device, then exiting...");
            CMPropertiesWriter.writePropertiesFile(device);
            if (properties_file.exists()) {
                System.out.println("Finished writing default .properties file.");
                System.out.println("Please read through " + properties_file.getAbsolutePath() + " to see if there are any default settings you would like changed.");
            } else {
                System.out.println("ERROR: Cannot find created .properties file. There must have been a problem during file creation.");
            }
            System.exit(0);
        } else {
            if (properties_file.exists()) {
                pl = new PropertiesLoader(properties_file);
            }
            boolean parsed_parent_folder = false;
            boolean parsed_title = false;
            int i2 = 0;
            while (i2 < args.length) {
                String option = args[i2];
                String option_value = args[++i2];
                if (option.equalsIgnoreCase("-parent_folder")) {
                    parent_folder_filename = option_value;
                    if (parent_folder_filename.charAt(parent_folder_filename.length() - 1) != File.separatorChar) {
                        parent_folder_filename = String.valueOf(parent_folder_filename) + File.separatorChar;
                    }
                    parsed_parent_folder = true;
                } else if (option.equalsIgnoreCase("-title")) {
                    title = option_value;
                    title = title.replaceAll(" ", "_");
                    parsed_title = true;
                } else if (option.equalsIgnoreCase("-manga_prefix")) {
                    manga_prefix = option_value;
                    manga_prefix = manga_prefix.replaceAll(" ", "_");
                } else if (option.equalsIgnoreCase("-bind_prefix")) {
                    bind_prefix = option_value;
                    bind_prefix = bind_prefix.replaceAll(" ", "_");
                } else if (option.equalsIgnoreCase("-num_chars_keep_suffix")) {
                    num_chars_keep_suffix = Integer.parseInt(option_value);
                } else if (option.equalsIgnoreCase("-output_folder")) {
                    output_folder_filename = option_value;
                    if (output_folder_filename.charAt(output_folder_filename.length() - 1) != File.separatorChar) {
                        output_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar;
                    }
                } else if (option.equalsIgnoreCase("-create_properties")) {
                    System.out.println("ERROR: When using -create_properties you cannot set any other options.");
                    System.exit(1);
                } else {
                    System.out.println("ERROR: Invalid option \"" + option + "\"");
                    ConvertManga.outputUsage();
                }
                ++i2;
            }
            if (!parsed_parent_folder || !parsed_title) {
                System.out.println("ERROR: Not all mandatory arguments were specified.");
                ConvertManga.outputUsage();
            }
            if (!(parent_folder_file = new File(parent_folder_filename)).exists()) {
                System.out.println("ERROR: Cannot find parent folder: " + parent_folder_file.getAbsolutePath());
                System.exit(1);
            }
            if (output_folder_filename == null) {
                String output_base_folder = pl.getOutputBaseFolder();
                if (output_base_folder.equalsIgnoreCase("default")) {
                    output_folder_filename = String.valueOf(parent_folder_file.getParent()) + File.separatorChar + "OUT" + File.separatorChar;
                } else {
                    output_folder_filename = output_base_folder = output_base_folder.replaceAll(" ", "_");
                    if (output_folder_filename.charAt(output_folder_filename.length() - 1) != File.separatorChar) {
                        output_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar;
                    }
                    output_folder_filename = String.valueOf(output_folder_filename) + title + File.separatorChar;
                }
            }
            if (output_folder_filename.equals(parent_folder_filename)) {
                output_folder_filename = String.valueOf(parent_folder_file.getParent()) + File.separatorChar + "OUT" + File.separatorChar;
            }
            if (!(output_folder_file = new File(output_folder_filename)).exists()) {
                FileUtils.recursiveMakeDirectory(output_folder_file);
            }
            if (!(progress_file = new File(String.valueOf(output_folder_filename) + "progress.txt")).exists()) {
                progress_file.createNewFile();
            }
            if ((bind_file = new File(String.valueOf(parent_folder_filename) + "bind.txt")).exists()) {
                use_bind = true;
                binds = ConvertManga.processBindFile(bind_file);
            }
            prefix = String.valueOf(title) + " - " + manga_prefix;
            prefix = prefix.replaceAll(" ", "_");
            if (num_chars_keep_suffix < 0) {
                auto_sense_suffix = true;
            }
        }
        if (pl == null) {
            if (properties_file.exists()) {
                pl = new PropertiesLoader(properties_file);
            } else {
                System.out.println("ERROR: Couldn't load .properties file. Please make sure that " + properties_file.getAbsolutePath() + " exists.");
                System.exit(1);
            }
        }
        boolean use_zip = pl.getZip();
        String zip_extension = ".zip";
        if (use_zip && !(zip_filter = new ExtFilter("zip")).isValid(zip_extension = pl.getZipFormat())) {
            System.out.println("ERROR: " + zip_extension + " is not a valid zip extension. Defaulting to .zip");
            zip_extension = ".zip";
        }
        boolean use_pdf = pl.getPdf();
        boolean pdf_r_to_l = pl.getPdfRToL();
        boolean use_epub = pl.getEpub();
        boolean epub_r_to_l = pl.getEpubRToL();
        boolean use_kindle_bookmark = pl.getKindleBookmark();
        boolean use_comic_zeal_naming = pl.getComicZealNaming();
        int page_filename_length = pl.getPageFilenameLength();
        pl.printProperties();
        if (use_bind) {
            System.out.println("Found bind.txt file, will perform binding after processing manga.");
        }
        ImageMagick im = new ImageMagick();
        StopWatch sw = new StopWatch();
        sw.start();
        ArrayList<File> zipList = FileUtils.getZipFileList(parent_folder_file);
        ArrayList<File> zipExtractedFolderList = new ArrayList<File>();
        Collections.sort(zipList);
        if (zipList.size() > 0) {
            System.out.println("Found " + zipList.size() + " zip archives in -parent_folder, extracting archives to temporary folders...");
        }
        int i3 = 0;
        while (i3 < zipList.size()) {
            File cur_zip_file = zipList.get(i3);
            String cur_zip_filename_noext = ExtFilter.getNameWithoutExtension(cur_zip_file);
            File cur_tmp_folder = new File(String.valueOf(parent_folder_file.getAbsolutePath()) + File.separatorChar + cur_zip_filename_noext);
            FileUtils.unzipFile(cur_zip_file, cur_tmp_folder);
            zipExtractedFolderList.add(cur_tmp_folder);
            ++i3;
        }
        ArrayList<File> folderList = FileUtils.getFolderList(parent_folder_file);
        Collections.sort(folderList);
        if (folderList.isEmpty() && parent_folder_file.isDirectory()) {
            System.out.println("parent_folder " + parent_folder_file.getAbsolutePath() + " is a directory that did not contain any subfolders, so running in single folder mode.\n");
            single_folder_mode = true;
            folderList.add(parent_folder_file);
        }
        if (folderList.isEmpty() && zipList.size() == 1) {
            System.out.println("parent_folder " + parent_folder_file.getAbsolutePath() + " is a zip/cbz archive, so running in single folder mode.\n");
            single_folder_mode = true;
        }
        boolean found_empty_folder = false;
        int i4 = 0;
        while (!folderList.isEmpty() && i4 < folderList.size()) {
            cur_folder = folderList.get(i4);
            ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder);
            if (image_files.isEmpty()) {
                found_empty_folder = true;
                System.out.println("Ignoring folder " + cur_folder.getAbsolutePath() + " because it has no image files.");
                folderList.remove(i4);
                --i4;
            }
            ++i4;
        }
        if (found_empty_folder) {
            System.out.println("");
        }
        i4 = 0;
        while (i4 < folderList.size()) {
            cur_folder = folderList.get(i4);
            String cur_folder_name = cur_folder.getName();
            if (auto_sense_suffix) {
                String suffix = ConvertManga.getFileNumberSuffix(cur_folder);
                suffixes.add(suffix);
            } else {
                suffixes.add(cur_folder_name.substring(cur_folder_name.length() - num_chars_keep_suffix));
            }
            ++i4;
        }
        int longest_length = 0;
        int i5 = 0;
        while (i5 < suffixes.size()) {
            cur_suffix = (String)suffixes.get(i5);
            int cur_length = 0;
            done = false;
            j = 0;
            while (!done && j < cur_suffix.length()) {
                cur_char = cur_suffix.charAt(j);
                if (cur_char == '.') {
                    done = true;
                } else {
                    ++cur_length;
                }
                ++j;
            }
            if (cur_length > longest_length) {
                longest_length = cur_length;
            }
            ++i5;
        }
        i5 = 0;
        while (i5 < suffixes.size()) {
            cur_suffix = (String)suffixes.get(i5);
            int cur_length = 0;
            done = false;
            j = 0;
            while (!done && j < cur_suffix.length()) {
                cur_char = cur_suffix.charAt(j);
                if (cur_char == '.') {
                    done = true;
                } else {
                    ++cur_length;
                }
                ++j;
            }
            j = cur_length;
            while (j < longest_length) {
                cur_suffix = "0" + cur_suffix;
                ++j;
            }
            suffixes.remove(i5);
            suffixes.add(i5, cur_suffix);
            ++i5;
        }
        if (use_bind) {
            int total_num_binds = 0;
            int i6 = 0;
            while (i6 < binds.size()) {
                total_num_binds += ((Integer)binds.get(i6)).intValue();
                ++i6;
            }
            if (total_num_binds > folderList.size()) {
                System.out.println("ERROR: Total number of binds (" + total_num_binds + ") is greater than the number of manga folders (" + folderList.size() + ") in " + parent_folder_filename + ". The number of binds must be equal to or less than the number of manga folders. Please correct the bind.txt file before running again.");
                System.exit(1);
            }
        }
        if (use_bind && manga_prefix.equals(bind_prefix)) {
            bind_prefix = !manga_prefix.equals("Bind.") ? "Bind." : "Vol.";
            System.out.println("WARNING: manga_prefix is the same as bind_prefix. Changing bind_prefix to \"" + bind_prefix + "\".");
        }
        if (!use_bind && !single_folder_mode && (use_auto_bind = pl.getAutoBind())) {
            use_bind = true;
            int auto_bind_size = pl.getAutoBindSize();
            System.out.println("Will perform auto-binding after processing manga.");
            int num_full = folderList.size() / auto_bind_size;
            int num_left_over = folderList.size() % auto_bind_size;
            i = 0;
            while (i < num_full) {
                binds.add(auto_bind_size);
                ++i;
            }
            if (num_left_over != 0) {
                binds.add(num_left_over);
            }
        }
        ArrayList<File> outputZipList = FileUtils.getZipFileList(output_folder_file);
        ArrayList<File> outputFolderList = FileUtils.getFolderList(output_folder_file);
        if (outputZipList.size() > 1 && outputFolderList.isEmpty()) {
            String comic_zeal_prefix = String.valueOf(title) + "~" + title;
            boolean printed_restore_message = false;
            i = 0;
            while (i < outputZipList.size()) {
                File cur_output_zip_file = outputZipList.get(i);
                String cur_output_zip_filename_noext = ExtFilter.getNameWithoutExtension(cur_output_zip_file);
                if (cur_output_zip_filename_noext.contains(title)) {
                    if (!printed_restore_message) {
                        System.out.println("Restoring output image folders from zip archives...");
                        printed_restore_message = true;
                    }
                    if (cur_output_zip_filename_noext.indexOf(comic_zeal_prefix) == 0) {
                        cur_output_zip_filename_noext = cur_output_zip_filename_noext.substring(new String(String.valueOf(title) + "~").length());
                    }
                    File cur_output_folder_file = new File(String.valueOf(output_folder_file.getAbsolutePath()) + File.separatorChar + cur_output_zip_filename_noext);
                    FileUtils.unzipFile(cur_output_zip_file, cur_output_folder_file);
                }
                ++i;
            }
        }
        ConvertManga.verifyProgressFile(progress_file);
        ArrayList<File> newFolderList = new ArrayList<File>();
        System.out.println("Copying files to new folders...");
        int i7 = 0;
        while (i7 < folderList.size()) {
            File source = folderList.get(i7);
            String suffix = (String)suffixes.get(i7);
            if (!source.exists()) {
                System.out.println("File or directory does not exist.");
                System.exit(0);
            }
            String dest_filename = null;
            dest_filename = !(suffix != null && !suffix.equals("") || manga_prefix != null && !manga_prefix.equals("")) ? String.valueOf(output_folder_filename) + File.separatorChar + title : String.valueOf(output_folder_filename) + File.separatorChar + prefix + suffix;
            File destination = new File(dest_filename);
            if (!destination.exists()) {
                destination.mkdir();
                ArrayList<File> source_image_list = FileUtils.getImageFileList(source);
                int j2 = 0;
                while (j2 < source_image_list.size()) {
                    File cur_image = source_image_list.get(j2);
                    FileUtils.copyFile(cur_image, new File(String.valueOf(destination.getAbsolutePath()) + File.separatorChar + cur_image.getName()));
                    ++j2;
                }
            }
            newFolderList.add(destination);
            ++i7;
        }
        i7 = 0;
        while (i7 < zipExtractedFolderList.size()) {
            FileUtils.deleteDirectory((File)zipExtractedFolderList.get(i7));
            ++i7;
        }
        long time_before_processing = sw.getElapsedTimeSecs();
        System.out.println("Converting all manga scans using ImageMagick...");
        int num_folders_processed = 0;
        int i8 = 0;
        while (i8 < newFolderList.size()) {
            boolean already_zipped = false;
            boolean already_pdfed = false;
            boolean already_epubbed = false;
            File cur_folder2 = (File)newFolderList.get(i8);
            if (num_folders_processed != 0) {
                String approx_time_remaining = StopWatch.formatTime((long)(newFolderList.size() - i8) * (sw.getElapsedTimeSecs() - time_before_processing) / (long)num_folders_processed);
                System.out.println("  Processing folder: " + cur_folder2.getName() + "... (approx " + approx_time_remaining + " remaining)");
            } else {
                System.out.println("  Processing folder: " + cur_folder2.getName() + "...");
            }
            File bookmark_file = new File(String.valueOf(cur_folder2.getAbsolutePath()) + File.separatorChar + cur_folder2.getName() + ".manga");
            File bookmark_save_file = new File(String.valueOf(cur_folder2.getAbsolutePath()) + File.separatorChar + cur_folder2.getName() + ".manga_save");
            String zip_file_filename = null;
            zip_file_filename = use_comic_zeal_naming ? String.valueOf(output_folder_filename) + title + "~" + cur_folder2.getName() + zip_extension : String.valueOf(output_folder_filename) + cur_folder2.getName() + zip_extension;
            File zip_file = new File(zip_file_filename);
            File pdf_file = new File(String.valueOf(output_folder_filename) + cur_folder2.getName() + ".pdf");
            File epub_file = new File(String.valueOf(output_folder_filename) + cur_folder2.getName() + ".epub");
            boolean processed = ConvertManga.isFolderProcessed(progress_file, cur_folder2);
            if (zip_file.exists()) {
                already_zipped = true;
            }
            if (pdf_file.exists()) {
                already_pdfed = true;
            }
            if (epub_file.exists()) {
                already_epubbed = true;
            }
            if (!processed) {
                ConvertManga.renamePages(cur_folder2, page_filename_length);
                ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder2);
                Collections.sort(image_files);
                int j3 = 0;
                while (j3 < image_files.size()) {
                    File cur_image = image_files.get(j3);
                    im.processImage(cur_image);
                    ++j3;
                }
                if (image_files.size() > 0 && use_kindle_bookmark) {
                    ConvertManga.writeBookmark(cur_folder2, bookmark_file, bookmark_save_file, image_files.get(0));
                }
                ConvertManga.addProcessedFolder(progress_file, cur_folder2);
                ++num_folders_processed;
            }
            if (use_zip && !use_bind && !already_zipped) {
                FileUtils.zipFolder(cur_folder2, zip_file);
            }
            if (use_pdf && !use_bind && !already_pdfed) {
                if (pdf_r_to_l) {
                    File tmp_r_to_l_folder = new File(String.valueOf(output_folder_file.getAbsolutePath()) + File.separatorChar + cur_folder2.getName() + "_TMP_R_TO_L");
                    ConvertManga.createFolderOfRToLPages(cur_folder2, tmp_r_to_l_folder, page_filename_length);
                    im.pdfImageFolder(tmp_r_to_l_folder, pdf_file);
                    FileUtils.deleteDirectory(tmp_r_to_l_folder);
                } else {
                    im.pdfImageFolder(cur_folder2, pdf_file);
                }
            }
            if (use_epub && !use_bind && !already_epubbed) {
                EpubMaker em = new EpubMaker(cur_folder2.getName(), epub_file, cur_folder2, page_filename_length, epub_r_to_l);
                em.makeEpub();
            }
            ++i8;
        }
        ArrayList<File> bind_folders = new ArrayList<File>();
        if (use_bind) {
            System.out.println("\nBeginning binding...");
            ArrayList<File> unbound_folders = FileUtils.getFolderList(output_folder_file);
            Collections.sort(unbound_folders);
            int i9 = 0;
            while (i9 < binds.size()) {
                int cur_bind = (Integer)binds.get(i9);
                String bind_title = String.valueOf(title) + "_-_" + bind_prefix + Integer.toString(i9 + 1);
                bind_title = bind_title.replaceAll(" ", "_");
                String bind_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar + bind_title;
                File bind_folder = new File(bind_folder_filename);
                if (bind_folder.exists()) {
                    FileUtils.deleteDirectory(bind_folder);
                }
                bind_folder.mkdir();
                ArrayList<File> folders_to_bind = new ArrayList<File>();
                int j4 = 0;
                while (j4 < cur_bind) {
                    folders_to_bind.add(unbound_folders.remove(0));
                    ++j4;
                }
                System.out.println("  Binding folders:");
                j4 = 0;
                while (j4 < folders_to_bind.size()) {
                    System.out.println("    " + ((File)folders_to_bind.get(j4)).getName());
                    ++j4;
                }
                System.out.println("  to form " + bind_title + "...");
                ConvertManga.bindFolders(folders_to_bind, bind_folder, output_folder_filename, im, title, use_zip, zip_extension, use_pdf, pdf_r_to_l, use_kindle_bookmark, use_comic_zeal_naming, use_epub, epub_r_to_l, page_filename_length);
                bind_folders.add(bind_folder);
                ++i9;
            }
        }
        if (pl.getDelOutputImageFolders()) {
            if (use_zip && !use_bind) {
                System.out.println("\nDeleting output image folders...");
                folderList = FileUtils.getFolderList(output_folder_file);
                int i10 = 0;
                while (i10 < folderList.size()) {
                    FileUtils.deleteDirectory(folderList.get(i10));
                    ++i10;
                }
            } else {
                int i11 = 0;
                while (i11 < bind_folders.size()) {
                    FileUtils.deleteDirectory((File)bind_folders.get(i11));
                    ++i11;
                }
                System.out.println("\nAlthough you requested to delete output image folders, this cannot be allowed with your current settings. Check to make sure that \"zip\" (either .zip or .cbz is fine) is turned on and binding (either through bind file or auto-binding) is disabled.");
            }
        }
        sw.stop();
        System.out.println("\nFinished.");
        System.out.println("Total time: " + StopWatch.formatTime(sw.getElapsedTimeSecs()));
        System.out.println("Check folder " + output_folder_filename + " for output.");
    }
}

