/*
 * Decompiled with CFR 0.152.
 */
package manga;

import common.utils.FileUtils;
import common.utils.JarUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import manga.PropertiesLoader;

public class CMPropertiesWriter {
    private static final String DEVICE_VALUE_KDX = "kdx";
    private static final String DEVICE_VALUE_K2 = "k2";
    private static final String DEVICE_VALUE_IPAD = "ipad";
    private static String default_loc = "/manga/props/";
    private static String default_kdx_filename = "ConvertManga_kdx.properties";
    private static String default_k2_filename = "ConvertManga_k2.properties";
    private static String default_ipad_filename = "ConvertManga_ipad.properties";
    private static String key_descriptors_imagemagick_filename = "key_descriptors_imagemagick.txt";
    private static String key_descriptors_convertmanga_filename = "key_descriptors_convertmanga.txt";
    private static String key_descriptors_kindle_filename = "key_descriptors_kindle.txt";
    private static String key_descriptors_ipad_filename = "key_descriptors_ipad.txt";

    public static void writePropertiesFile(String device) {
        String default_props_filename = null;
        File properties_file = new File("ConvertManga.properties");
        if (device.equalsIgnoreCase(DEVICE_VALUE_KDX)) {
            device = DEVICE_VALUE_KDX;
            default_props_filename = String.valueOf(default_loc) + default_kdx_filename;
        } else if (device.equalsIgnoreCase(DEVICE_VALUE_K2)) {
            device = DEVICE_VALUE_K2;
            default_props_filename = String.valueOf(default_loc) + default_k2_filename;
        } else if (device.equalsIgnoreCase(DEVICE_VALUE_IPAD)) {
            device = DEVICE_VALUE_IPAD;
            default_props_filename = String.valueOf(default_loc) + default_ipad_filename;
        } else {
            System.out.println("  ERROR: Invalid -device value: " + device + ". Acceptable values: " + DEVICE_VALUE_KDX + ", " + DEVICE_VALUE_K2 + ", " + DEVICE_VALUE_IPAD);
        }
        InputStream is = CMPropertiesWriter.class.getResourceAsStream(default_props_filename);
        PropertiesLoader pl = new PropertiesLoader(is);
        int width = pl.getWidth();
        int height = pl.getHeight();
        int max_dpi = pl.getMaxDPI();
        boolean auto_trim = pl.getAutoTrim();
        int trim_fuzz = pl.getTrimFuzz();
        boolean auto_rotate = pl.getAutoRotate();
        String color_mode = pl.getColorMode();
        int num_colors = pl.getNumColors();
        String image_format = pl.getImageFormat();
        boolean pdf = pl.getPdf();
        boolean pdf_r_to_l = pl.getPdfRToL();
        boolean zip = pl.getZip();
        String zip_format = pl.getZipFormat();
        boolean epub = pl.getEpub();
        boolean epub_r_to_l = pl.getEpubRToL();
        boolean auto_bind = pl.getAutoBind();
        int auto_bind_size = pl.getAutoBindSize();
        int page_filename_length = pl.getPageFilenameLength();
        String output_base_folder = pl.getOutputBaseFolder();
        boolean del_output_image_folders = pl.getDelOutputImageFolders();
        boolean kindle_bookmark = pl.getKindleBookmark();
        boolean comic_zeal_naming = pl.getComicZealNaming();
        String image_magick_dir = "";
        String os_name = System.getProperty("os.name");
        String os_name_lowercase = os_name.toLowerCase();
        if (os_name_lowercase.contains("nux") || os_name_lowercase.contains("nix")) {
            System.out.println("  Detected that you are running a unix or linux os. Setting ImageMagick install directory to: /usr/bin/");
            image_magick_dir = "/usr/bin/";
        } else if (os_name_lowercase.contains("mac")) {
            System.out.println("  Detected that you are running a mac os. Setting ImageMagick install directory to: /opt/local/bin/");
            image_magick_dir = "/opt/local/bin/";
        } else if (os_name_lowercase.contains("win")) {
            System.out.println("  Detected that you are running a windows os. Searching for ImageMagick install directory...");
            boolean found = false;
            List<File> roots = Arrays.asList(File.listRoots());
            int i = 0;
            while (!found && i < roots.size()) {
                char cur_drive_letter;
                File program_files_folder;
                File cur_root = roots.get(i);
                if (FileSystemView.getFileSystemView().getSystemTypeDescription(cur_root).toLowerCase().contains("local") && (program_files_folder = new File(String.valueOf(cur_drive_letter = cur_root.getAbsolutePath().charAt(0)) + ":\\Program Files\\")).exists()) {
                    ArrayList<File> program_files_folder_subfolders = FileUtils.getFolderList(program_files_folder);
                    Collections.sort(program_files_folder_subfolders);
                    if (program_files_folder_subfolders != null) {
                        int j = 0;
                        while (j < program_files_folder_subfolders.size()) {
                            File cur_folder = program_files_folder_subfolders.get(j);
                            if (cur_folder.getName().indexOf("ImageMagick") == 0) {
                                image_magick_dir = cur_folder.getAbsolutePath();
                                if (image_magick_dir.charAt(image_magick_dir.length() - 1) != File.separatorChar) {
                                    image_magick_dir = String.valueOf(image_magick_dir) + File.separatorChar;
                                }
                                found = true;
                            }
                            ++j;
                        }
                        if (found) {
                            j = 0;
                            while (j < image_magick_dir.length()) {
                                char cur_char = image_magick_dir.charAt(j);
                                if (cur_char == '\\') {
                                    image_magick_dir = String.valueOf(image_magick_dir.substring(0, j)) + "\\\\" + image_magick_dir.substring(j + 1);
                                    ++j;
                                }
                                ++j;
                            }
                        }
                    }
                }
                ++i;
            }
            if (!found) {
                System.out.println("  ERROR: Unable to find ImageMagick install directory. You will have to manually specify this value within the .properties file before you can process manga.");
            } else {
                System.out.println("  Found ImageMagick install directory: " + image_magick_dir);
            }
        } else {
            System.out.println("  ERROR: Unable to determine your operating system. Defaulting ImageMagick install directory to: /usr/bin/. Please manually change this to the correct value before processing manga.");
            image_magick_dir = "/usr/bin/";
        }
        try {
            ArrayList<String> lines = null;
            if (properties_file.exists()) {
                properties_file.delete();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(properties_file));
            bw.write("# @author Andrew Mantel\n");
            bw.write("# @version 1.71\n");
            bw.write("\n");
            InputStream key_descriptors_imagemagick_is = CMPropertiesWriter.class.getResourceAsStream(String.valueOf(default_loc) + key_descriptors_imagemagick_filename);
            lines = JarUtils.readTextFromJarFile(key_descriptors_imagemagick_is);
            int i = 0;
            while (i < lines.size()) {
                bw.write(String.valueOf(lines.get(i)) + "\n");
                ++i;
            }
            bw.write("width = " + width + "\n");
            bw.write("height = " + height + "\n");
            bw.write("max_dpi = " + max_dpi + "\n");
            bw.write("auto_trim = " + auto_trim + "\n");
            bw.write("trim_fuzz = " + trim_fuzz + "\n");
            bw.write("auto_rotate = " + auto_rotate + "\n");
            bw.write("color_mode = " + color_mode + "\n");
            bw.write("num_colors = " + num_colors + "\n");
            bw.write("image_format = " + image_format + "\n");
            bw.write("image_magick_dir = " + image_magick_dir + "\n");
            bw.write("\n\n");
            InputStream key_descriptors_convertmanga_is = CMPropertiesWriter.class.getResourceAsStream(String.valueOf(default_loc) + key_descriptors_convertmanga_filename);
            lines = JarUtils.readTextFromJarFile(key_descriptors_convertmanga_is);
            int i2 = 0;
            while (i2 < lines.size()) {
                bw.write(String.valueOf(lines.get(i2)) + "\n");
                ++i2;
            }
            bw.write("pdf = " + pdf + "\n");
            bw.write("pdf_r_to_l = " + pdf_r_to_l + "\n");
            bw.write("zip = " + zip + "\n");
            bw.write("zip_format = " + zip_format + "\n");
            bw.write("epub = " + epub + "\n");
            bw.write("epub_r_to_l = " + epub_r_to_l + "\n");
            bw.write("auto_bind = " + auto_bind + "\n");
            bw.write("auto_bind_size = " + auto_bind_size + "\n");
            bw.write("page_filename_length = " + page_filename_length + "\n");
            bw.write("output_base_folder = " + output_base_folder + "\n");
            bw.write("del_output_image_folders = " + del_output_image_folders + "\n");
            bw.write("\n\n");
            InputStream key_descriptors_kindle_is = CMPropertiesWriter.class.getResourceAsStream(String.valueOf(default_loc) + key_descriptors_kindle_filename);
            lines = JarUtils.readTextFromJarFile(key_descriptors_kindle_is);
            int i3 = 0;
            while (i3 < lines.size()) {
                bw.write(String.valueOf(lines.get(i3)) + "\n");
                ++i3;
            }
            bw.write("kindle_bookmark = " + kindle_bookmark + "\n");
            bw.write("\n\n");
            InputStream key_descriptors_ipad_is = CMPropertiesWriter.class.getResourceAsStream(String.valueOf(default_loc) + key_descriptors_ipad_filename);
            lines = JarUtils.readTextFromJarFile(key_descriptors_ipad_is);
            int i4 = 0;
            while (i4 < lines.size()) {
                bw.write(String.valueOf(lines.get(i4)) + "\n");
                ++i4;
            }
            bw.write("comic_zeal_naming = " + comic_zeal_naming + "\n");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

