/*
 * images management
 * Copyright 2008 Kovid Goyal
 * License: GNU GPL v3
 */

function scale_images() {
    $("img:visible").each(function() {
        var offset = $(this).offset();
        //window.py_bridge.debug(window.getComputedStyle(this, '').getPropertyValue('max-width'));
        $(this).css("max-width", (window.innerWidth-offset.left-5)+"px");
        $(this).css("max-height", (window.innerHeight-5)+"px");
    });
}

function setup_image_scaling_handlers() {
   scale_images();
   $(window).resize(function(){
        scale_images();
   });
}

function extract_svged_images() {
    $("svg").each(function() {
        var children = $(this).children("img");
        if (children.length == 1) {
            var img = $(children[0]);
            var href = img.attr('xlink:href');
            if (href != undefined) {
                $(this).replaceWith('<div style="text-align:center; margin: 0; padding: 0"><img style="height: 98%" alt="SVG Image" src="' + href +'"></img></div>');
            }
        }
    });
}

// Added by Pollito Pito...
// Not sure what is better : $(document).ready or $(window).ready but
// it seems that $(document).ready does not always work.

		//$(document).ready(function() {
		$(window).ready(function(){
				// Get the size of the viewport and define the Width of the columns
					viewportHeight = $(window).height();
					twoColWidth = $(window).width();
				// Substract half of the column gap. The column rule has no Width
					oneColWidth = (twoColWidth/2)-10;
				//Apply a temporary style to get the height of the doc when it is only one column wide
					$("body").css({"width":oneColWidth});				
					docTotalLength = $("body").height();
				// Calc the number of facing pages considering the 10px top and bottom margins.
					numberOfpages = Math.ceil(docTotalLength/(2*(viewportHeight-40)));
						
				//Build a CSS for the two column layaout.
					var body_css = {
					"margin-top":'10px',
					"margin-bottom":'10px',
					"margin-right":'0px',
					"margin-left":'0px',
					
					"-webkit-column-count":'2',
					"-webkit-column-fill":'balance',
					"-webkit-column-gap":'20px',
					"-webkit-column-rule":'2px solid rgb(221,204,181)',
									
					"height": viewportHeight - 20,
					"width": twoColWidth 						
					}
					
					//Apply the CSS to the body.
					$("body").css(body_css);
					//Force the font size via css on the paragraphs.
					//$("p").css({"font-size":'20px'});				
		});
				
				//Traps the enter key and performs the scrolling
		var SpaceToScroll = 0;
		var curr_page = 1;
		$(document).keyup(function (event) {
				//It seems that the keypress triggers the scrollLeft in 1px
				//therefore (twoColWidth + 19) instead of (twoColWidth + 20)
		
					if (event.keyCode == 39 && curr_page < numberOfpages) {
					 curr_page++;
					 SpaceToScroll += (twoColWidth + 19);
					 $("body").animate({scrollLeft: SpaceToScroll}, 500);

					}else if (event.keyCode == 37 && curr_page > 1){
					 curr_page--;	
					 SpaceToScroll -= (twoColWidth + 19);
					 $("body").animate({scrollLeft: SpaceToScroll}, 500);
				
					}else if (event.keyCode == 39 && curr_page == numberOfpages){
					 alert ("Go to Next Chapter.");
					}else if (event.keyCode == 37 && curr_page == 1){
					 alert ("Go to Prev. Chapter.");					
					}
		});
				//On resizing the window reloads the doc. 
				$(window).bind('resize',function(){
					window.location.href = window.location.href;
					}
				);