/*
 * Decompiled with CFR 0.152.
 */
package manga;

import common.image.ImageMagick;
import common.utils.ExtFilter;
import common.utils.FileUtils;
import common.utils.PropertiesLoader;
import common.utils.StopWatch;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import manga.EpubMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertManga {
    public static File default_bookmark = new File("./default.manga");

    public static void renamePages(File folder, int page_filename_length) {
        File cur_image;
        ArrayList<File> image_files = FileUtils.getImageFileList(folder);
        Collections.sort(image_files);
        ArrayList<File> cover_image_files = new ArrayList<File>();
        ArrayList<File> credit_image_files = new ArrayList<File>();
        int i = 0;
        while (i < image_files.size()) {
            cur_image = image_files.get(i);
            if (cur_image.getName().toLowerCase().contains("cover")) {
                image_files.remove(i);
                cover_image_files.add(cur_image);
                --i;
            } else if (cur_image.getName().toLowerCase().contains("credit")) {
                image_files.remove(i);
                credit_image_files.add(cur_image);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < cover_image_files.size()) {
            image_files.add(0, (File)cover_image_files.get(cover_image_files.size() - i - 1));
            ++i;
        }
        i = 0;
        while (i < credit_image_files.size()) {
            image_files.add((File)credit_image_files.get(i));
            ++i;
        }
        i = 0;
        while (i < image_files.size()) {
            cur_image = image_files.get(i);
            String extension = ExtFilter.getExtension(cur_image);
            String new_name = Integer.toString(i);
            while (new_name.length() < page_filename_length) {
                new_name = "0" + new_name;
            }
            File new_image = new File(String.valueOf(cur_image.getParent()) + File.separatorChar + new_name + extension);
            cur_image.renameTo(new_image);
            ++i;
        }
    }

    public static ArrayList<Integer> processBindFile(File bind_file) {
        ArrayList<Integer> binds = new ArrayList<Integer>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(bind_file));
            boolean done = false;
            while (!done) {
                String line = br.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                line = line.replaceAll(" ", "");
                if ((line = line.replaceAll("\t", "")).equals("") || line.charAt(0) == '#' || line.charAt(0) == '/') continue;
                binds.add(Integer.parseInt(line));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return binds;
    }

    public static void bindFolders(ArrayList<File> folders, File bind_folder, String output_folder_filename, ImageMagick im, String title, boolean use_zip, String zip_extension, boolean use_pdf, boolean use_kindle_bookmark, boolean use_comic_zeal_naming, boolean use_epub, boolean epub_r_to_l, int page_filename_length) {
        if (folders.isEmpty() || folders.size() == 0) {
            return;
        }
        int next_starting_number = 0;
        int i = 0;
        while (i < folders.size()) {
            File cur_folder = folders.get(i);
            ArrayList<File> cur_folder_image_list = FileUtils.getImageFileList(cur_folder);
            Collections.sort(cur_folder_image_list);
            int j = 0;
            while (j < cur_folder_image_list.size()) {
                File cur_image = cur_folder_image_list.get(j);
                String extension = ExtFilter.getExtension(cur_image);
                String new_name = Integer.toString(next_starting_number + j);
                while (new_name.length() < page_filename_length) {
                    new_name = "0" + new_name;
                }
                try {
                    FileUtils.copyFile(cur_image, new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + new_name + extension));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            next_starting_number += cur_folder_image_list.size();
            ++i;
        }
        if (use_kindle_bookmark) {
            ArrayList<File> bind_folder_image_list = FileUtils.getImageFileList(bind_folder);
            Collections.sort(bind_folder_image_list);
            File bookmark_file = new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + bind_folder.getName() + ".manga");
            File bookmark_save_file = new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + bind_folder.getName() + ".manga_save");
            ConvertManga.writeBookmark(bind_folder, bookmark_file, bookmark_save_file, bind_folder_image_list.get(0));
        }
        String zip_file_filename = null;
        zip_file_filename = use_comic_zeal_naming ? String.valueOf(output_folder_filename) + title + "~" + bind_folder.getName() + zip_extension : String.valueOf(output_folder_filename) + bind_folder.getName() + zip_extension;
        File zip_file = new File(zip_file_filename);
        File pdf_file = new File(String.valueOf(output_folder_filename) + bind_folder.getName() + ".pdf");
        File epub_file = new File(String.valueOf(output_folder_filename) + bind_folder.getName() + ".epub");
        if (use_zip) {
            FileUtils.zipFolder(bind_folder, zip_file);
        }
        if (use_pdf) {
            im.pdfImageFolder(bind_folder, pdf_file);
        }
        if (use_epub) {
            EpubMaker em = new EpubMaker(bind_folder.getName(), epub_file, folders, page_filename_length, epub_r_to_l);
            em.makeEpub();
        }
    }

    public static void writeBookmark(File cur_dir, File bookmark_file, File bookmark_save_file, File first_file) {
        try {
            FileOutputStream out = new FileOutputStream(bookmark_file);
            byte[] b = new byte[]{0};
            ((OutputStream)out).write(b);
            ((OutputStream)out).close();
            BufferedWriter bw = new BufferedWriter(new FileWriter(bookmark_save_file));
            bw.write("LAST=/mnt/us/pictures/" + cur_dir.getName() + "/" + first_file.getName());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void outputUsage() {
        System.out.println("\nCanti v1.61, author: Andrew Mantel");
        System.out.println("Purpose: Convert a collection of manga scans for ereader devices such as the Kindle DX, Kindle 2, and iPad.");
        System.out.println("Usage: ConvertManga [mandatory_arguments] [other_options]");
        System.out.println("\nMandatory Arguments: (these arguments MUST be specified)");
        System.out.println("-parent_folder /path/to/parent_folder/");
        System.out.println("  The parent folder containing subfolders representing chapters.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path (for example, \"C:\\\\Program Files\\\\manga parent folder\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("-title \"Manga Title\"");
        System.out.println("  Title of the manga, such as \"School Rumble\".");
        System.out.println("\nOther Options: (these are all optional)");
        System.out.println("-num_chars_keep_suffix [integer]");
        System.out.println("  Number of characters to keep from original subfolder suffix.");
        System.out.println("  If you do not set this or set this to -1, then the program will attempt to auto sense the suffix.");
        System.out.println("  Note that if using auto suffix sensing then each manga folder must end with a number such as 1, 001, 1.11, or 001.11 for this to work properly).");
        System.out.println("-manga_prefix \"[manga_prefix]\"");
        System.out.println("  This is placed after the manga title but before the subfolder suffix.");
        System.out.println("  Recommended value is something like \"Ch.\" or \"Vol.\" so that the output will look like \"School_Rumble_-_Ch.001\"");
        System.out.println("-bind_prefix \"[bind_prefix]\"");
        System.out.println("  This is places after the manga title but before the binding number of bound manga.");
        System.out.println("  Recommend value is something like \"Vol.\" or \"Bind.\" so that the output will look like \"School_Rumble_-_Vol.1\"");
        System.out.println("  If not specified, the default value is \"Vol.\"");
        System.out.println("-output_folder /path/to/output_folder/");
        System.out.println("  The output parent folder. If not specified, default is an \"OUT\" folder created one directory above -parent_folder.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path (for example, \"C:\\\\Program Files\\\\manga parent folder\\\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("\nSee ConvertManga.properties for conversion settings.");
        System.out.println("\nSee readme.txt for manga organization requirements and other tips.");
        System.out.println("");
        System.exit(0);
    }

    public static boolean isFolderProcessed(File progress_file, File folder) {
        boolean found = false;
        String folder_path = folder.getAbsolutePath();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(progress_file));
            while (!found && (line = br.readLine()) != null) {
                if (!line.equals(folder_path)) continue;
                found = true;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return found;
    }

    public static void addProcessedFolder(File progress_file, File folder) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(progress_file, true));
            bw.write(String.valueOf(folder.getAbsolutePath()) + "\n");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        boolean use_auto_bind;
        boolean done;
        int cur_length;
        String cur_suffix;
        File cur_folder;
        ExtFilter zip_filter;
        String parent_folder_filename = null;
        String output_folder_filename = null;
        String title = null;
        String manga_prefix = "";
        String bind_prefix = "Vol.";
        String prefix = null;
        File progress_file = null;
        File bind_file = null;
        File parent_folder_file = null;
        File output_folder_file = null;
        boolean use_bind = false;
        boolean single_folder_mode = false;
        boolean auto_sense_suffix = false;
        int num_chars_keep_suffix = -1;
        ArrayList<Object> binds = new ArrayList();
        ArrayList<String> suffixes = new ArrayList<String>();
        PropertiesLoader pl = new PropertiesLoader();
        if (args.length == 0) {
            ConvertManga.outputUsage();
        } else if (args.length % 2 != 0) {
            System.out.println("ERROR: Invalid number of arguments.");
            ConvertManga.outputUsage();
        } else {
            boolean parsed_parent_folder = false;
            boolean parsed_title = false;
            int i = 0;
            while (i < args.length) {
                String option = args[i];
                String option_value = args[++i];
                if (option.equalsIgnoreCase("-parent_folder")) {
                    parent_folder_filename = option_value;
                    if (parent_folder_filename.charAt(parent_folder_filename.length() - 1) != File.separatorChar) {
                        parent_folder_filename = String.valueOf(parent_folder_filename) + File.separatorChar;
                    }
                    parsed_parent_folder = true;
                } else if (option.equalsIgnoreCase("-title")) {
                    title = option_value;
                    title = title.replaceAll(" ", "_");
                    parsed_title = true;
                } else if (option.equalsIgnoreCase("-manga_prefix")) {
                    manga_prefix = option_value;
                    manga_prefix = manga_prefix.replaceAll(" ", "_");
                } else if (option.equalsIgnoreCase("-bind_prefix")) {
                    bind_prefix = option_value;
                    bind_prefix = bind_prefix.replaceAll(" ", "_");
                } else if (option.equalsIgnoreCase("-num_chars_keep_suffix")) {
                    num_chars_keep_suffix = Integer.parseInt(option_value);
                } else if (option.equalsIgnoreCase("-output_folder")) {
                    output_folder_filename = option_value;
                    if (output_folder_filename.charAt(output_folder_filename.length() - 1) != File.separatorChar) {
                        output_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar;
                    }
                } else {
                    System.out.println("ERROR: Invalid option \"" + option + "\"");
                    ConvertManga.outputUsage();
                }
                ++i;
            }
            if (!parsed_parent_folder || !parsed_title) {
                System.out.println("ERROR: Not all mandatory arguments were specified.");
                ConvertManga.outputUsage();
            }
            if (!(parent_folder_file = new File(parent_folder_filename)).exists()) {
                System.out.println("ERROR: Cannot find parent folder: " + parent_folder_file.getAbsolutePath());
                System.exit(1);
            }
            if (output_folder_filename == null) {
                String output_base_folder = pl.getOutputBaseFolder();
                if (output_base_folder.equalsIgnoreCase("default")) {
                    output_folder_filename = String.valueOf(parent_folder_file.getParent()) + File.separatorChar + "OUT" + File.separatorChar;
                } else {
                    output_folder_filename = output_base_folder = output_base_folder.replaceAll(" ", "_");
                    if (output_folder_filename.charAt(output_folder_filename.length() - 1) != File.separatorChar) {
                        output_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar;
                    }
                    output_folder_filename = String.valueOf(output_folder_filename) + title + File.separatorChar;
                }
            }
            if (!(output_folder_file = new File(output_folder_filename)).exists()) {
                FileUtils.recursiveMakeDirectory(output_folder_file);
            }
            if (!(progress_file = new File(String.valueOf(output_folder_filename) + "progress.txt")).exists()) {
                progress_file.createNewFile();
            }
            if ((bind_file = new File(String.valueOf(parent_folder_filename) + "bind.txt")).exists()) {
                use_bind = true;
                binds = ConvertManga.processBindFile(bind_file);
            }
            prefix = String.valueOf(title) + " - " + manga_prefix;
            prefix = prefix.replaceAll(" ", "_");
            if (num_chars_keep_suffix < 0) {
                auto_sense_suffix = true;
            }
        }
        boolean use_zip = pl.getZip();
        String zip_extension = ".zip";
        if (use_zip && !(zip_filter = new ExtFilter("zip")).isValid(zip_extension = pl.getZipFormat())) {
            System.out.println("ERROR: " + zip_extension + " is not a valid zip extension. Defaulting to .zip");
            zip_extension = ".zip";
        }
        boolean use_pdf = pl.getPdf();
        boolean use_epub = pl.getEpub();
        boolean epub_r_to_l = pl.getEpubRToL();
        boolean use_kindle_bookmark = pl.getKindleBookmark();
        boolean use_comic_zeal_naming = pl.getComicZealNaming();
        int page_filename_length = pl.getPageFilenameLength();
        pl.printProperties();
        if (use_bind) {
            System.out.println("Found bind.txt file, will perform binding after processing manga.\n");
        }
        ImageMagick im = new ImageMagick();
        StopWatch sw = new StopWatch();
        sw.start();
        ArrayList<File> folderList = FileUtils.getFolderList(parent_folder_file);
        Collections.sort(folderList);
        if (folderList.isEmpty() || folderList.size() == 0) {
            System.out.println("parent_folder " + parent_folder_file.getAbsolutePath() + " did not contain any subfolders, so running in single folder mode.\n");
            single_folder_mode = true;
            folderList.add(parent_folder_file);
        }
        boolean found_empty_folder = false;
        int i = 0;
        while (!folderList.isEmpty() && i < folderList.size()) {
            cur_folder = folderList.get(i);
            ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder);
            if (image_files.isEmpty()) {
                found_empty_folder = true;
                System.out.println("Ignoring folder " + cur_folder.getAbsolutePath() + " because it has no image files.");
                folderList.remove(i);
                --i;
            }
            ++i;
        }
        if (found_empty_folder) {
            System.out.println("");
        }
        i = 0;
        while (i < folderList.size()) {
            cur_folder = folderList.get(i);
            String cur_folder_name = cur_folder.getName();
            if (auto_sense_suffix) {
                boolean done2 = false;
                boolean found_decimal = false;
                String suffix = "";
                int j = 0;
                while (!done2 && j < cur_folder_name.length() - 1) {
                    char cur_char = cur_folder_name.charAt(cur_folder_name.length() - 1 - j);
                    if (cur_char == '.') {
                        if (!found_decimal) {
                            suffix = String.valueOf(cur_char) + suffix;
                            found_decimal = true;
                        } else {
                            done2 = true;
                        }
                    } else if (Character.isDigit(cur_char)) {
                        suffix = String.valueOf(cur_char) + suffix;
                    } else {
                        done2 = true;
                    }
                    ++j;
                }
                String regex = "^0*";
                suffix = suffix.replaceAll(regex, "");
                suffixes.add(suffix);
            } else {
                suffixes.add(cur_folder_name.substring(cur_folder_name.length() - num_chars_keep_suffix));
            }
            ++i;
        }
        int longest_length = 0;
        int i2 = 0;
        while (i2 < suffixes.size()) {
            cur_suffix = (String)suffixes.get(i2);
            cur_length = 0;
            done = false;
            int j = 0;
            while (!done && j < cur_suffix.length()) {
                char cur_char = cur_suffix.charAt(j);
                if (cur_char == '.') {
                    done = true;
                } else {
                    ++cur_length;
                }
                ++j;
            }
            if (cur_length > longest_length) {
                longest_length = cur_length;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < suffixes.size()) {
            cur_suffix = (String)suffixes.get(i2);
            cur_length = 0;
            done = false;
            int j = 0;
            while (!done && j < cur_suffix.length()) {
                char cur_char = cur_suffix.charAt(j);
                if (cur_char == '.') {
                    done = true;
                } else {
                    ++cur_length;
                }
                ++j;
            }
            j = cur_length;
            while (j < longest_length) {
                cur_suffix = "0" + cur_suffix;
                ++j;
            }
            suffixes.remove(i2);
            suffixes.add(i2, cur_suffix);
            ++i2;
        }
        if (use_bind) {
            int total_num_binds = 0;
            int i3 = 0;
            while (i3 < binds.size()) {
                total_num_binds += ((Integer)binds.get(i3)).intValue();
                ++i3;
            }
            if (total_num_binds > folderList.size()) {
                System.out.println("ERROR: Total number of binds (" + total_num_binds + ") is greater than the number of manga folders (" + folderList.size() + ") in " + parent_folder_filename + ". The number of binds must be equal to or less than the number of manga folders. Please correct the bind.txt file before running again.");
                System.exit(1);
            }
        }
        if (use_bind && manga_prefix.equals(bind_prefix)) {
            System.out.println("WARNING: manga_prefix is the same as bind_prefix. Changing bind_prefix to \"Bind.\".");
            bind_prefix = "Bind.";
        }
        if (!use_bind && !single_folder_mode && (use_auto_bind = pl.getAutoBind())) {
            use_bind = true;
            int auto_bind_size = pl.getAutoBindSize();
            System.out.println("Will perform auto-binding after processing manga.\n");
            int num_full = folderList.size() / auto_bind_size;
            int num_left_over = folderList.size() % auto_bind_size;
            int i4 = 0;
            while (i4 < num_full) {
                binds.add(auto_bind_size);
                ++i4;
            }
            if (num_left_over != 0) {
                binds.add(num_left_over);
            }
        }
        ArrayList<File> newFolderList = new ArrayList<File>();
        System.out.println("Copying files to new folders...");
        int i5 = 0;
        while (i5 < folderList.size()) {
            File source = folderList.get(i5);
            String suffix = (String)suffixes.get(i5);
            if (!source.exists()) {
                System.out.println("File or directory does not exist.");
                System.exit(0);
            }
            String dest_filename = null;
            dest_filename = !(suffix != null && !suffix.equals("") || manga_prefix != null && !manga_prefix.equals("")) ? String.valueOf(output_folder_filename) + File.separatorChar + title : String.valueOf(output_folder_filename) + File.separatorChar + prefix + suffix;
            File destination = new File(dest_filename);
            if (!destination.exists()) {
                destination.mkdir();
                FileUtils.copyDirectory(source, destination);
            }
            newFolderList.add(destination);
            ++i5;
        }
        long time_before_processing = sw.getElapsedTimeSecs();
        System.out.println("Converting all manga scans using ImageMagick...");
        int num_folders_processed = 0;
        int i6 = 0;
        while (i6 < newFolderList.size()) {
            boolean already_zipped = false;
            boolean already_pdfed = false;
            boolean already_epubbed = false;
            File cur_folder2 = (File)newFolderList.get(i6);
            if (num_folders_processed != 0) {
                String approx_time_remaining = StopWatch.formatTime((long)(newFolderList.size() - i6) * (sw.getElapsedTimeSecs() - time_before_processing) / (long)num_folders_processed);
                System.out.println("  Processing folder: " + cur_folder2.getName() + "... (approx " + approx_time_remaining + " remaining)");
            } else {
                System.out.println("  Processing folder: " + cur_folder2.getName() + "...");
            }
            File bookmark_file = new File(String.valueOf(cur_folder2.getAbsolutePath()) + File.separatorChar + cur_folder2.getName() + ".manga");
            File bookmark_save_file = new File(String.valueOf(cur_folder2.getAbsolutePath()) + File.separatorChar + cur_folder2.getName() + ".manga_save");
            String zip_file_filename = null;
            zip_file_filename = use_comic_zeal_naming ? String.valueOf(output_folder_filename) + title + "~" + cur_folder2.getName() + zip_extension : String.valueOf(output_folder_filename) + cur_folder2.getName() + zip_extension;
            File zip_file = new File(zip_file_filename);
            File pdf_file = new File(String.valueOf(output_folder_filename) + cur_folder2.getName() + ".pdf");
            File epub_file = new File(String.valueOf(output_folder_filename) + cur_folder2.getName() + ".epub");
            boolean processed = ConvertManga.isFolderProcessed(progress_file, cur_folder2);
            if (zip_file.exists()) {
                already_zipped = true;
            }
            if (pdf_file.exists()) {
                already_pdfed = true;
            }
            if (epub_file.exists()) {
                already_epubbed = true;
            }
            if (!processed) {
                ConvertManga.renamePages(cur_folder2, page_filename_length);
                ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder2);
                Collections.sort(image_files);
                int j = 0;
                while (j < image_files.size()) {
                    File cur_image = image_files.get(j);
                    im.processImage(cur_image);
                    ++j;
                }
                if (image_files.size() > 0 && use_kindle_bookmark) {
                    ConvertManga.writeBookmark(cur_folder2, bookmark_file, bookmark_save_file, image_files.get(0));
                }
                ConvertManga.addProcessedFolder(progress_file, cur_folder2);
                ++num_folders_processed;
            }
            if (use_zip && !use_bind && !already_zipped) {
                FileUtils.zipFolder(cur_folder2, zip_file);
            }
            if (use_pdf && !use_bind && !already_pdfed) {
                im.pdfImageFolder(cur_folder2, pdf_file);
            }
            if (use_epub && !use_bind && !already_epubbed) {
                EpubMaker em = new EpubMaker(cur_folder2.getName(), epub_file, cur_folder2, page_filename_length, epub_r_to_l);
                em.makeEpub();
            }
            ++i6;
        }
        if (use_bind) {
            System.out.println("\nBeginning binding...");
            ArrayList<File> unbound_folders = FileUtils.getFolderList(output_folder_file);
            Collections.sort(unbound_folders);
            int i7 = 0;
            while (i7 < binds.size()) {
                int cur_bind = (Integer)binds.get(i7);
                String bind_title = String.valueOf(title) + "_-_" + bind_prefix + Integer.toString(i7 + 1);
                bind_title = bind_title.replaceAll(" ", "_");
                String bind_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar + bind_title;
                File bind_folder = new File(bind_folder_filename);
                if (bind_folder.exists()) {
                    FileUtils.deleteDirectory(bind_folder);
                }
                bind_folder.mkdir();
                ArrayList<File> folders_to_bind = new ArrayList<File>();
                int j = 0;
                while (j < cur_bind) {
                    folders_to_bind.add(unbound_folders.remove(0));
                    ++j;
                }
                System.out.println("  Binding folders:");
                j = 0;
                while (j < folders_to_bind.size()) {
                    System.out.println("    " + ((File)folders_to_bind.get(j)).getName());
                    ++j;
                }
                System.out.println("  to form " + bind_title + "...");
                ConvertManga.bindFolders(folders_to_bind, bind_folder, output_folder_filename, im, title, use_zip, zip_extension, use_pdf, use_kindle_bookmark, use_comic_zeal_naming, use_epub, epub_r_to_l, page_filename_length);
                ++i7;
            }
        }
        sw.stop();
        System.out.println("\nFinished.");
        System.out.println("Total time: " + StopWatch.formatTime(sw.getElapsedTimeSecs()));
        System.out.println("Check folder " + output_folder_filename + " for output.");
    }
}

