/*
 * Decompiled with CFR 0.152.
 */
package common.utils;

import common.utils.ExtFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static ArrayList<File> getFolderList(File folder) {
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> listOfFolders = new ArrayList<File>();
        int i = 0;
        while (i < listOfFiles.length) {
            if (listOfFiles[i].isDirectory()) {
                listOfFolders.add(listOfFiles[i]);
            }
            ++i;
        }
        return listOfFolders;
    }

    public static ArrayList<File> getFileList(File folder) {
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> listOfFiles_strict = new ArrayList<File>();
        int i = 0;
        while (i < listOfFiles.length) {
            if (listOfFiles[i].isFile()) {
                listOfFiles_strict.add(listOfFiles[i]);
            }
            ++i;
        }
        return listOfFiles_strict;
    }

    public static ArrayList<File> getImageFileList(File folder) {
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> listOfImageFiles_strict = new ArrayList<File>();
        ExtFilter image_filter = new ExtFilter("image");
        int i = 0;
        while (i < listOfFiles.length) {
            if (listOfFiles[i].isFile() && image_filter.isValid(listOfFiles[i])) {
                listOfImageFiles_strict.add(listOfFiles[i]);
            }
            ++i;
        }
        return listOfImageFiles_strict;
    }

    public static void recursiveMakeDirectory(File path) {
        if (!path.exists()) {
            File parent_path = path.getParentFile();
            if (parent_path != null && !parent_path.exists()) {
                FileUtils.recursiveMakeDirectory(parent_path);
            }
            path.mkdir();
        }
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    FileUtils.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }

    public static void copyDirectory(File sourceDir, File destDir) throws IOException {
        File[] children = sourceDir.listFiles();
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        File[] fileArray = children;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File sourceChild = fileArray[n];
            String name = sourceChild.getName();
            File destChild = new File(destDir, name);
            if (sourceChild.isDirectory()) {
                FileUtils.copyDirectory(sourceChild, destChild);
            } else {
                FileUtils.copyFile(sourceChild, destChild);
            }
            ++n;
        }
    }

    public static void copyFile(File source, File dest) throws IOException {
        if (!dest.exists()) {
            dest.createNewFile();
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    public static void zipFolder(File inFolder, File zipFile) {
        try {
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            BufferedInputStream in = null;
            byte[] data = new byte[1000];
            String[] files = inFolder.list();
            int i = 0;
            while (i < files.length) {
                int count;
                in = new BufferedInputStream(new FileInputStream(String.valueOf(inFolder.getPath()) + File.separatorChar + files[i]), 1000);
                out.putNextEntry(new ZipEntry(files[i]));
                while ((count = in.read(data, 0, 1000)) != -1) {
                    out.write(data, 0, count);
                }
                out.closeEntry();
                ++i;
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zipFolderRecursive(String parent_folder_path, String source_folder_path, ZipOutputStream zos) {
        try {
            File zip_folder = new File(source_folder_path);
            String[] dir_list = zip_folder.list();
            byte[] readBuffer = new byte[1000];
            int bytesIn = 0;
            int i = 0;
            while (i < dir_list.length) {
                File f = new File(zip_folder, dir_list[i]);
                if (f.isDirectory()) {
                    String filePath = f.getPath();
                    FileUtils.zipFolderRecursive(parent_folder_path, filePath, zos);
                } else {
                    FileInputStream fis = new FileInputStream(f);
                    ZipEntry n_entry = new ZipEntry(f.getPath().substring(parent_folder_path.length()));
                    zos.putNextEntry(n_entry);
                    while ((bytesIn = fis.read(readBuffer)) != -1) {
                        zos.write(readBuffer, 0, bytesIn);
                    }
                    fis.close();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

