-- tools --

math.randomseed(os.time());

---- buttons ----

buttonsPngStrB64 = "iVBORw0KGgoAAAANSUhEUgAAAUAAAAAoAgMAAADyLsu6AAAADFBMVEUAAABVVVWqqqr////Bf2LRAAAE40lEQVRIiaWWvWsjRxjGpXTBjdYgQuLCXQqn0L9gw0qFBQl70cgYwalJjqCA1cdwSuHrYzhBLvUlnCVYNSkSLdltnP4Mch+DDD5jjRKQQF87k/d5ZyXt3keld63l52dXM4+enY9NpdZ1fMH1fDP6/LeoXqYDbWp/E0p9+iKqn7fk0ByvN6HU3pOaOb7ZjTrRv29CMYcnSilNH/UAUit6n/ZhimV4Sh38WqNTeLrsL0xqM29JKnj3vpC1mENXyjvbrkop3aG5j2itSRna+Y4h+XAiIzIFmrCW2qtF9R114AhRRvfqCVegYprWt0IcRebG9aVNLqarCijuUC2EEKUTJd1ByUY9lTFNqTyRz6SuK3QiagqU0Z6VocUyDPR/uFrRs0DxfaIxi2l6AqqDtG6WEWmg+bYya2FW0HkWc9gZ/s2Xh7IzMA0GkrU8a/IWUlGTpqUQeggy9w2hUX910mLjMOpPIMPIoYJW/pY13TRukFdI1zg5sdau8EOSGYai5L5BTG5YuiCFCY01Qco2eRGpkRAYeW7UMUj3haiSFs9wisfZhC+FOBRoim5vWcuuXOsb4ybuUE3pWpBw2Jnkq0P6clV2whJ9SyLDSZ4GyATawripy47Wz4Qo0A0dnTchEU38vFjUdWIcjukZ6ikZJzdwmCU3Y3rU9RDaNGoQDmH2LYdXuebRuJJw6PdLvlZhqaiCEKRKgfL7QvcKqkQNTkpc6G4B8NGMDeJHdlbsV3vUdDzDG5NcZZkhHN44WtBfBV65qEE9MiNy6fARUZh1pg0aaIkMe3nMHbtIGdpo0G7IznWBZk1wRlqfJ4/9FeV1zYDkWMoTTWzbX9h2PTEOrwTmpThCho2lwzLNgEZz7ZAIzwTTOu6QRuHuGFfjGS4dKp+fsio1lN8rhDYcUpqRQ+XrM0BBE0UOVdCjNYnuKCYzdNYOVxk+UpYIOEOHCw5vGODQaBpXRWPqOLlkhkhOrjKUyLCfl+QA2mid4QRQT2RIa+XiKf2WxDi8QXJhdieRoRWcf6KgjUUWtUu+QkCDM8xaWWub6Wi0e76dnMt9mybogjy4oe3TtMR62Lf9N/TvY+lOjMMTrH2wxeuhcQjqVS8P+8XkejhydrT+19mdBWEGDjO0Ho6cnNZ0mgVTi/PCGqnPHedrXg8dCwdo1DhwprnEekgeCmp4CQ8DMw6JHii+Yc9oXD72D3qmRd5JjENQSKPQdWViHIZWpj5Nw1do1VqtliErUAcgfWChAjgcWVaOHRqNV+y+Ze0mV+yoPxt7ir1PBV+k5Z8bD5c8+niHe4DTpEP52rYPseutM/Tm55mMldmez7www3U6I83KpFmb/wNpCzRXGWs+B+1Ds1gbZawvSEs45MlA3SzzgkPWvoSHO9BjswefFeTa4QFr9B03uS+3vT+ttJXJed32X+b97rQbaXXSPJ8CS3sgz7va8pjMeshacGDNSUu+OZhABrQvc7kD0n6MNH62h4Zkn5wa4mLqwfUglmGt6/VTqZ2Zd1Hzorog7TaV+r4L6nadrMfkdf/4wYs0lNFGn0GLOaxRB81jvM3Ulj0zvfhlSRzf27S6j9937mLjcK/dpija7dYrEMrQSmvR8c7VNbWYYg4/bt3L+3v6vGSSK7p/D8kPUSzDj1pR/bQJxRymjiPa34gSlU6nN6X/AVIG0wp6uTN6AAAAAElFTkSuQmCCaVZCT1J3MEtHZ29BQUFBTlNVaEVVZ0FBQVVBQUFBQW9BZ01BQUFEeUxzdTZBQUFBREZCTVZFVUFBQUJWVlZXcXFxci8vLy9CZjJMUkFBQUU0MGxFUVZSSWlhV1d2V3NqUnhqR3BYVEJqZFlnUXVMQ1hRcW4wTDlndzBxRkJRbDcwY2dZd2FsSmpxQ0ExY2R3U3VIcll6aEJMdlVsbkNWWU5Ta1NMZGx0blA0TWNoK0RERDVqalJLUVFGODdrL2Q1WnlYdDNrZWxkNjNsNTJkWE00K2VuWTlOcGRaMWZNSDFmRFA2L0xlb1hxWURiV3AvRTBwOStpS3FuN2ZrMEJ5dk42SFUzcE9hT2I3WmpUclJ2MjlDTVljblNpbE5IL1VBVWl0Nm4vWmhpbVY0U2gzOFdxTlRlTHJzTDB4cU0yOUpLbmozdnBDMW1FTlh5anZicmtvcDNhRzVqMml0U1JuYStZNGgrWEFpSXpJRm1yQ1cycXRGOVIxMTRBaFJSdmZxQ1ZlZ1lwcld0MEljUmViRzlhVk5McWFyQ2lqdVVDMkVFS1VUSmQxQnlVWTlsVEZOcVR5Uno2U3VLM1FpYWdxVTBaNlZvY1V5RFBSL3VGclJzMER4ZmFJeGkybDZBcXFEdEc2V0VXbWcrYll5YTJGVzBIa1djOWdaL3MyWGg3Iz";
buttons = gd.createFromPngStr(mime.unb64(buttonsPngStrB64));
buttonsPngStrB64 = nil;

pushButtonsPngStrB64 = "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";
pushButtons = gd.createFromPngStr(mime.unb64(pushButtonsPngStrB64));
pushButtonsPngStrB64 = nil;

-- Tetris Settings --

game_speed = 1400;
score      = 0;

marginSize = 100;
cellSize   = 40;

if (eblua.platform == "pocketbook") then
  left_key     =  29;
  right_key    =  25;
  rotation_left_key  =  28;
  down_key     = 24;
  quit_key     = 27;
elseif (eblua.platform == "hanlin") then
  left_key     =  34;        -- key '4'              
  right_key    =  35;        -- key '5'
  rotation_left_key  =  32;  -- key '2'
  down_key     = 31;         -- key '1'
  quit_key     = 40;         -- key 'return'
elseif (eblua.platform == "windows") then
  left_key     =  44;              -- key '<'
  right_key    =  46;              -- key '>'
  rotation_left_key  =  120;       -- key 'x'
  down_key     = 122;              -- key 'z'
  quit_key     = 113;              -- key 'esc'
elseif (eblua.platform == "linux") then
  left_key     =  59;
  right_key    =  60;
  rotation_left_key  =  53;
  down_key     = 52;
  quit_key     = 9;
elseif (eblua.platform == "mac") then
  left_key     =  65580;
  right_key    =  65582;
  rotation_left_key  =  65656;
  down_key     = 65658;
  quit_key     = 65563;
else
  print ("Error: unknown platform")
  left_key     = 0;
  right_key    = 0;
  rotation_left_key = 0;
  down_key     = 0;
  quit_key     = 0;
end

damage = {};

function clearDamage()
  damage.l = 600;
  damage.t = 800;
  damage.r = 0;
  damage.b = 0;
end

function collectDamage(l,t,r,b)
  if (l < damage.l) then
    damage.l = l
  end
  if (t < damage.t) then
    damage.t = t
  end
  if (r > damage.r) then
    damage.r = r
  end
  if (b > damage.b) then
    damage.b = b
  end
end

function updateDamage()
  eblua.invalidate(damage.l, damage.t, damage.r, damage.b);
end

function drawCell (line, col, cellKind)
  local l = marginSize + (col-1) * cellSize;
  local t = (line-1) * cellSize;
  local r = marginSize + col * cellSize;
  local b = line * cellSize;

  eblua.window_image:copy(buttons, l, t, (40*cellKind), 0, 40, 40);
  
  collectDamage(l,t,r,b);
end

-- TetrisBoard --

TetrisBoard = {};

TetrisBoard.width  = 10;
TetrisBoard.height = 20;

function TetrisBoard:draw()
  for lineNr = 1, self.height do
    line = self[lineNr];
    for colNr = 1, TetrisBoard.width do
      local cell = line[colNr];
      drawCell (lineNr, colNr, cell)
    end
  end
end

function TetrisBoard:clear()
  for lineNr = 1, self.height do
    line = {};
    self[lineNr] = line;
    for colNr = 1, TetrisBoard.width do
      line[colNr] = 0;
    end
  end
end

-- Tetrominos --

Tetromino = {};

TetrominoI = {{1,1,1,1}};

TetrominoJ = {{2,0,0},
              {2,2,2}};

TetrominoL = {{0,0,3},
              {3,3,3}};

TetrominoO = {{4,4},
              {4,4}};

TetrominoS = {{0,5,5},
              {5,5,0}};

TetrominoT = {{0,6,0},
              {6,6,6}};

TetrominoZ = {{7,7,0},
              {0,7,7}};
              
TetrominoTemplates = {
  TetrominoI,
  TetrominoJ,
  TetrominoL,
  TetrominoO,
  TetrominoS,
  TetrominoT,
  TetrominoZ
};
 
function Tetromino:New()
  local instance = shallowCopy(Tetromino);
  local ran = math.random(7);
  instance.cells = TetrominoTemplates[ran];
  return instance;
end

function Tetromino:rotateLeft()
  local newCells = {};
  local nrOfLines = #self.cells;
  for lineNr = 1, nrOfLines do
    line = self.cells[lineNr];
    local nrOfColumns = #line;
    for colNr = 1, nrOfColumns do
      local cell = line[colNr];
      local y = nrOfColumns-colNr+1;
      local x = lineNr;
      if (not newCells[y]) then
        newCells[y] = {};
      end
      newCells[y][x] = cell;
    end
  end
  local oldCells = self.cells;
  self.cells = newCells;
  if (self:canMoveOnBoard (0, 0)) then
    self.cells = oldCells;
    self:undraw();
    self.cells = newCells;
    self:draw();
  else
    self.cells = oldCells;
  end
end

function Tetromino:cellsDo (fun)
  local nrOfLines = #self.cells;
  for lineNr = 1, nrOfLines do
    line = self.cells[lineNr];
    local nrOfColumns = #line;
    for colNr = 1, nrOfColumns do
      local cell = line[colNr];
      if (cell > 0) then
        fun(self.row + lineNr, self.col + colNr, cell);
      end
    end
  end
end

function Tetromino:canMoveOnBoard (dx, dy)
  local nrOfLines = #self.cells;
  for lineNr = 1, nrOfLines do
    line = self.cells[lineNr];
    local nrOfColumns = #line;
    for colNr = 1, nrOfColumns do
      if (line[colNr] > 0) then 
        local y = self.row + dy + lineNr;
        local x = self.col + dx + colNr;
        if (x < 1) then
	    return false;
	end
	if (x > TetrisBoard.width) then
	  return false;
	end
	if (y < 1) then
	  return false;
	end
	if (y > TetrisBoard.height) then
	  return false;
	end
	if (TetrisBoard[y][x] > 0) then
	  return false;
	end
      end
    end
  end
  return true;
end

function Tetromino:moveOnBoard (dx, dy)
  self:undraw();
  self.col = self.col + dx;
  self.row = self.row + dy;
  self:draw();
end

function Tetromino:putOnBoard ()
  self:cellsDo(function (y, x, cell) TetrisBoard[y][x] = cell end);
end

function Tetromino:draw ()
  self:cellsDo(drawCell);
end

function Tetromino:undraw ()
  self:cellsDo(function (y, x, cell) drawCell(y,x,0) end);
end

-- Tetris --

Tetris = {};

function Tetris:draw()
  TetrisBoard:draw();
  eblua.window_image:filledRectangle(500, 0, 600, 80, black);
  eblua.window_image:stringFT(white, eblua.default_font, 52, 0, 508, 78, "" .. score);
  eblua.invalidate(500, 0, 600, 80);
  if (self.fallingTetromino) then
    self.fallingTetromino:draw();
  end
  
end

function Tetris:keyLeft()
  if (self.fallingTetromino:canMoveOnBoard (-1, 0)) then
    self.fallingTetromino:moveOnBoard (-1, 0);
  end
end

function Tetris:keyRight()
  if (self.fallingTetromino:canMoveOnBoard (1, 0)) then
    self.fallingTetromino:moveOnBoard (1, 0);
  end
end

function Tetris:keyDown()
  while (self.fallingTetromino:canMoveOnBoard (0, 1)) do
    self.fallingTetromino:moveOnBoard (0, 1);
  end
end

function Tetris:rotateLeftKeyDown()
  self.fallingTetromino:rotateLeft();
end

function Tetris:removeLine(line)
  for lineNr = line, 2, -1 do
    TetrisBoard[lineNr] = TetrisBoard[lineNr-1];
  end
  TetrisBoard[1] = {0,0,0,0,0,0,0,0,0,0};
end

function Tetris:handleFullLines()
  local didRemoveLines = false;
  for lineNr = 1, TetrisBoard.height do
    local line = TetrisBoard[lineNr];
    local full = true;
    for colNr = 1, TetrisBoard.width do
      if (line[colNr] == 0) then
        full = false;
      end
    end
    if (full) then
      didRemoveLines = true;
      self:removeLine(lineNr);
      score = score + 1;
      eblua.stop_timer(123);
      game_speed = 0.9 * game_speed;
      eblua.start_timer(123, game_speed);
    end
  end
  if (didRemoveLines) then
    Tetris:draw();
  end
end

function Tetris:gameStep()
  clearDamage();
  if (self.fallingTetromino and self.fallingTetromino:canMoveOnBoard (0, 1)) then
    self.fallingTetromino:moveOnBoard (0, 1);
  else
    if (self.fallingTetromino) then
      self.fallingTetromino:putOnBoard();
    end
    self.fallingTetromino = nil;
    self:handleFullLines();
    self.fallingTetromino = Tetromino:New();
    self.fallingTetromino.row = 0;
    self.fallingTetromino.col = 3;
    self.fallingTetromino:draw();
    if (not self.fallingTetromino:canMoveOnBoard (0, 0)) then
      TetrisBoard:clear();
      eblua.stop_timer(123);
      game_speed = 1400;
      score = 0;
      eblua.start_timer(123, game_speed);
      Tetris:draw();
    end
  end
  updateDamage();
end

--- Key Handling --

function eblua.event_handlers.char (key, p4)
  clearDamage();
  if (key == left_key) then
    Tetris:keyLeft();
  elseif (key == right_key) then
    Tetris:keyRight();
  elseif (key == down_key) then
    Tetris:keyDown();
  elseif (key == rotation_left_key) then
    Tetris:rotateLeftKeyDown();
  elseif (key == quit_key) then
    eblua.post_quit();
  end
  updateDamage();
end

function eblua.event_handlers.timer (id, p4)
  Tetris:gameStep();
end

function eblua.event_handlers.mouse_up (x, y)
  clearDamage();
  if (x > 10) and (x < 90) then
    if (y > 620) and (y < 700) then
      Tetris:rotateLeftKeyDown();
    end
    if (y > 710) and (y < 790) then
      Tetris:keyLeft();
    end
  end
  if (x > 510) and (x < 590) then
    if (y > 620) and (y < 700) then
      Tetris:keyDown();
    end
    if (y > 710) and (y < 790) then
      Tetris:keyRight();
    end
  end
  updateDamage();
end

----------

eblua.window_image:filledRectangle(0,0,600,800,black);
TetrisBoard:clear();
clearDamage();
TetrisBoard:draw()
eblua.window_image:stringFT(white, eblua.default_font, 90, math.rad(90), 90, 400, "tetris");

eblua.window_image:copy(pushButtons, 10, 620, (0*80), 0, 80, 80);
eblua.window_image:copy(pushButtons, 10, 710, (2*80), 0, 80, 80);

eblua.window_image:copy(pushButtons, 510, 620, (1*80), 0, 80, 80);
eblua.window_image:copy(pushButtons, 510, 710, (3*80), 0, 80, 80);

Tetris:gameStep();
eblua.start_timer(123, game_speed);
eblua.invalidate();
