package hello;

import com.jinke.gui.Window;
import com.jinke.gui.event.KeyAdapter;
import com.jinke.gui.event.KeyEvent;
import com.jinke.gui.Font;
import com.jinke.device.LED;

import com.groundspeak.mochalua.LuaAPI;
import com.groundspeak.mochalua.LuaDebugLib;
import com.groundspeak.mochalua.lua_State;


public class HelloWindow extends Window {

	class HelloWindowKeyAdapter extends KeyAdapter {
		public void keyPressed(KeyEvent keyevent) {
			// led.resume();

			if (keyevent.getCh() == KeyEvent.KEY_CANCEL)
				System.exit(0);

			if (keyevent.getCh() == KeyEvent.KEY_OK)
				runLua();

			// led.resume();
		}
	}

	public HelloWindow(int i1, int j1, int k1, int l1) {
		super(i1, j1, k1, l1);

		this.setVisible(true);
		this.addKeyListener(new HelloWindowKeyAdapter());

		viewerFont = new Font("/root/fonts/truetype/lBOOKN.ttf", 26, Font.BOLD);
		viewerFont.setInvert(false);

		led = new LED();

		this.paint();
	}

	public void paint() {
		gc.clear(0, 0, 600, 800);
		gc.setFont(viewerFont);
		gc.drawString("muchalua says Hello", 50, 50);
		Window.flush();
	}

	public void runLua() {

		try {
			System.out.println("-- start runLua --");

			lua_State L = LuaAPI.lua_newstate();
			LuaAPI.luaL_openlibs(L);

			int status = LuaAPI.luaL_loadfile(L, "/mnt/java/hello.out");

			if (status != 0) {
				int top = LuaAPI.lua_gettop(L);
				for (int i = 1; i <= top; ++i) {
					System.out.println(LuaAPI.lua_tostring(L, i + 1));
				}
			} else {

				int errfunc = LuaAPI.lua_gettop(L);
				LuaAPI.lua_pushjavafunction(L, new LuaDebugLib.traceback());
				LuaAPI.lua_insert(L, errfunc);

				gc.drawString("-- start LUA execution --", 150, 150);
				Window.flush();
				led.resume();

				status = LuaAPI.lua_pcall(L, 0, 0, errfunc);

				led.resume();
				gc.drawString("-- done with LUA execution --", 150, 180);
				Window.flush();

				// report errors from the stack (if any)
				if (status != 0) {
					int top = LuaAPI.lua_gettop(L);
					for (int i = 1; i <= top; ++i) {
						if (LuaAPI.lua_tostring(L, i) != null) {
							System.out.println(LuaAPI.lua_tostring(L, i));
						}
					}
				}
			}
			System.out.println("-- done runLua --");
		} catch (Exception e) {
			gc.drawString("-- LUA execution FAILED --", 150, 180);
			Window.flush();

			e.printStackTrace();
		}

	}

	Font viewerFont;
	LED led;
}