#!/bin/sh

PATH="/usr/local/bin:/usr/bin:/sbin:/bin:/usr/bin/X11:/usr/games:/usr/local/sony/bin:/usr/sbin"
LD_LIBRARY_PATH="/opt/sony/ebook/application:/lib:/usr/lib:/usr/local/sony/lib:/opt/sony/ebook/lib"
export PATH LD_LIBRARY_PATH

W_LOG=/tmp/script.log

rm $W_LOG

echo "SD execution script" > $W_LOG

echo "Mounting SD card A" >> $W_LOG
mkdir -p /tmp/sd_card
mount -t vfat /dev/sdmscard/sdmsa1 /tmp/sd_card >> $W_LOG 2>&1
#ls -laR /tmp/sd_card >> $W_LOG

if [ -f /tmp/sd_card/reader/main.sh ]
then
    echo "Executing /reader/main.sh on SD card A" >> $W_LOG
    /tmp/sd_card/reader/main.sh
else
    echo "Script /reader/main.sh not found on SD card A" >> $W_LOG
fi

# note: internal memory is at this point mounted at /Data

echo Done >> $W_LOG
cp $W_LOG /tmp/sd_card/runsd.log
sync

echo "Unmounting SD card A" >> $W_LOG
umount /tmp/sd_card >> $W_LOG 2>&1

sync
/bin/sleep 1
exit 0 

