#!/bin/sh
#

PATH="/usr/local/bin:/usr/bin:/sbin:/bin:/usr/bin/X11:/usr/games:/usr/local/sony/bin:/usr/sbin"
LD_LIBRARY_PATH="/opt/sony/ebook/application:/lib:/usr/lib:/usr/local/sony/lib:/opt/sony/ebook/lib"
export PATH LD_LIBRARY_PATH

W_LOG=/tmp/script.log

# Binaries
stat_fs=/tmp/bin/stat_fs
date=/bin/date
mkdir=/bin/mkdir
rm=/bin/rm
tar=/bin/tar
mkcramfs=/usr/bin/mkcramfs
mcopy=/tmp/mcopy
#mcopy=/usr/bin/mcopy
chmod=/bin/chmod
du=/usr/bin/du
cut=/usr/bin/cut
nblsdm=/usr/local/sony/bin/nblsdm
umount=/bin/umount
mtdmount=/usr/local/sony/bin/mtdmount

SD_IMG=/Data/test/new_opt.600.img
SD_MD5=/Data/test/new_opt.600.md5
TMP_IMG=/tmp/new_opt.600.img
M_CARD=`cat /tmp/cardroot`
PRS_VER=`cat /tmp/prsver`

##
#  Edit from here
##

rm $W_LOG
echo -n "Test script -> " > $W_LOG
echo "card $M_CARD ver. $PRS_VER" >> $W_LOG

mkdir -p /tmp/img_mnt

echo "Mounting SD card A" >> $W_LOG
mkdir -p /tmp/sd_card
mount -t vfat /dev/sdmscard/sdmsa1 /tmp/sd_card >> $W_LOG 2>&1
ls -laR /tmp/sd_card >> $W_LOG
umount /tmp/sd_card >> $W_LOG 2>&1

echo "Mounting SD card B" >> $W_LOG
mount -t vfat /dev/sdmscard/sdmsb1 /tmp/sd_card >> $W_LOG 2>&1
ls -laR /tmp/sd_card >>$W_LOG
umount /tmp/sd_card >> $W_LOG 2>&1

UMT=0

if [ -f $TMP_IMG ]
then
   TMP_IMG=/tmp/new_opt.600.img.0
fi

if [ -f $SD_IMG -a -f $SD_MD5 ]
then
   cp -f $SD_IMG $TMP_IMG
   REAL_MD5=`/usr/bin/md5sum $TMP_IMG | cut -f1 -d\  `
   TEST_MD5=`cut -f1 -d\  $SD_MD5`

   if [ $REAL_MD5 = $TEST_MD5 ]
   then
      echo "Mounting SD card image" >> $W_LOG
      mount -o loop -t cramfs $TMP_IMG /tmp/img_mnt >> $W_LOG 2>&1
      mount --bind /tmp/img_mnt/bin /bin >> $W_LOG 2>&1
      mount --bind /tmp/img_mnt/lib /lib >> $W_LOG 2>&1
      mount --bind /tmp/img_mnt/usr /usr >> $W_LOG 2>&1
      mount --bind /tmp/img_mnt/opt /opt >> $W_LOG 2>&1
      echo "Done mounting SD card image" >> $W_LOG
      UMT=1
   else
      echo MD5 failure >> $W_LOG
   fi
fi

echo "Filesystem listing" >>$W_LOG
echo "/:" >>$W_LOG
ls -la / >>$W_LOG
ls -laR /Data >>$W_LOG
ls -laR /bin >>$W_LOG
echo "/dev:" >>$W_LOG
ls -la /dev >>$W_LOG
echo "/dev/sdmscard:" >>$W_LOG
ls -la /dev/sdmscard >>$W_LOG
ls -laR /etc >>$W_LOG
ls -laR /home >>$W_LOG
ls -laR /lib >>$W_LOG
ls -laR /mnt >>$W_LOG
ls -laR /opt >>$W_LOG
ls -laR /opt0 >>$W_LOG
ls -laR /opt1 >>$W_LOG
echo "/proc:" >>$W_LOG
ls -la /proc >>$W_LOG
ls -laR /root >>$W_LOG
ls -laR /sbin >>$W_LOG
ls -laR /tmp >>$W_LOG
ls -laR /usr >>$W_LOG
ls -laR /var >>$W_LOG
#ls -laR /sys >>$W_LOG

for file in /proc/filesystems /proc/mtd /proc/mounts
do
   echo "-----------------------------" >> $W_LOG
   echo $file >> $W_LOG
   cat $file >> $W_LOG
   echo "-----------------------------" >> $W_LOG
done

echo "df -k before remount" >> $W_LOG
echo "-----------------------------------" >> $W_LOG
/bin/df -k >> $W_LOG
echo "-----------------------------------" >> $W_LOG

#/bin/mount -o remount -t tmpfs -o size=32m /dev/shm /tmp >> $W_LOG 2>&1

#echo "df -k after remount" >> $W_LOG
#echo "-----------------------------------" >> $W_LOG
#/bin/df -k >> $W_LOG
#echo "-----------------------------------" >> $W_LOG

echo "/usr/local/sony/bin/nblconfig -dump" >> $W_LOG
echo "-----------------------------------" >> $W_LOG
/usr/local/sony/bin/nblconfig -dump >> $W_LOG
echo "-----------------------------------" >> $W_LOG

echo "/usr/local/sony/bin/nblsdm -?" >> $W_LOG
echo "-----------------------------------" >> $W_LOG
/usr/local/sony/bin/nblsdm -? >> $W_LOG
echo "-----------------------------------" >> $W_LOG
echo "/usr/local/sony/bin/nblsdm list" >> $W_LOG
echo "-----------------------------------" >> $W_LOG
/usr/local/sony/bin/nblsdm list >> $W_LOG
echo "-----------------------------------" >> $W_LOG

WF_COPY=/Data/tmp/Wf.img
BOOTIMG_COPY=/Data/tmp/BootImg.img
INFO_COPY=/Data/tmp/Info.img

#cat /dev/mtd8 > $WF_COPY
#cat /dev/mtd9 > $BOOTIMG_COPY
#cat /dev/mtd11 > $INFO_COPY

# if [ $UMT = 1 ]
# then
   # echo Unmounting images >> $W_LOG
   # umount /usr >> $W_LOG 2>&1
   # umount /lib >> $W_LOG 2>&1
   # umount /bin >> $W_LOG 2>&1
   # umount /tmp/img_mnt >> $W_LOG 2>&1
# fi

echo "All running processes" >> $W_LOG
ps ax >> $W_LOG 2>&1

# echo Copying Log >> $W_LOG
# echo cp $W_LOG /tmp/sd_card >> $W_LOG 2>&1
# cp -f $W_LOG /tmp/sd_card/script.log >> $W_LOG 2>&1
# ls -l /tmp/sd_card/script.log >> $W_LOG 2>&1
# echo Done copying Log >> $W_LOG
# ls /tmp/sd_card >> $W_LOG 2>&1
# sync
# sync
# sync
# sync

# note internal memory is at this point mounted at /Data
# SD card is not
echo "Misc diagnostics" >> $W_LOG
/bin/date
cp /proc/config.gz /Data/test/config.gz 2>&1 >> $W_LOG
cat /proc/cpuinfo 2>&1 >> $W_LOG
echo "Uname:" >> $W_LOG
uname -a 2>&1 >> $W_LOG
echo "End Misc diagnostics" >> $W_LOG

# umount /tmp/sd_card >> $W_LOG 2>&1
echo Done >> $W_LOG

sync
exit 0 
