//dump object's properties to a string
target.dumpObject = function(o)
{
    //this.trace("[autorun] dumpObject enter\n");
    var dump = "---\n";
    for (var i in o)
    {
      //this.trace("getting property "+i+"\n");
      try {
         //if (o.propertyIsScriptable(i))
         //   dump += (i+"="+o[i]+"\n");
         //else
            dump += i+"\n";
      }
      catch(e)
      {
         this.trace("error getting property\n");
      }
    }
    dump += "---\n";
    //this.trace("[autorun] dumpObject exit\n");
    return dump;
}

//ugly but pretty robust tracer
target.trace = function(message)
{
    if (!this.hasOwnProperty('logno'))
        this.logno = 0;
    if (!this.hasOwnProperty('driveroot'))
        this.driveroot = 'b:';
    this.stringToFile(this.driveroot+"/autorun_log2."+this.logno, message);
    this.logno++;
}

//a not very robust copying function. groks a:/ and b:/
target.copyFile = function(from,to)
{
    //this.trace("copyFile() from "+from+" to "+to+"\n");
    try {
      FileSystem.copyFile(from, to);
    }
    catch(e) {
      this.trace("copy error: "+e.message+"\n");
      return false;
    }
    if (FileSystem.getFileInfo(to))
      return true;
    else
      return false;
}

//load an VM from xml. mainly intended to load extenstions
target.loadVm = function(path)
{
    // this.trace("loading vm from "+path+"\n");
    var myvm = FskInclude.load(path);
    // this.trace("myvm = "+myvm+"\n");
    // this.trace(myvm.serialize()+"\n");
    try {
      // this.trace("before load()\n");
      var t = myvm.load();
      // this.trace("load result: "+t+"\n");
    }
    catch(e)
    {
      this.trace("vm load error: "+e.toString()+"\n");

      // this.copyFile("/proc/filesystems",this.driveroot + "filesystems.txt");
      // this.copyFile("/proc/mtd",this.driveroot + "mtd.txt");
      // this.copyFile("/proc/mounts",this.driveroot + "mounts.txt");
      // this.copyFile("/dev/mtd12","/Data/tmp/mtd12");
    }
}

//show text in the main area. remove the danger sign if it's still there for more space
target.showMsg = function(text)
{
  if (this.DANGER.isShown())
  {
      this.DANGER.show(false);
      //                        left, width, right, top, height, bottom
      this.MSGTEXT.changeLayout(0, undefined, 0, 0, undefined, 0);
  }
  var model = kbook.model;
  model.processing(100);
  this.MSGTEXT.setValue(text);
  FskUI.Window.update.call(model.container.getWindow());
  model.processed(100);
}

//return file's content in a string
target.fileToString = function(path)
{
  var res=null;
  try {
    var f = new Stream.File(path)
    res = f.toString();
  }
  catch (e)
  {
    res=null;
  }
  return res;
}

//write string to file, overwriting if needed
target.stringToFile = function(path, text)
{
  try {
    if (FileSystem.getFileInfo(path))
       FileSystem.deleteFile(path);
    var stream = new Stream.File(path, 1);
    stream.writeString(text);
    stream.close();
  }
  catch (e)
  {
  }
}

target.getPRSVersion = function ()
{
 model = this.fileToString('/opt1/info/model'); //PRS-505/U
 return model.substring(4,7);
}

target.scriptPrepared = false;
target.prepareScript = function()
{
  if (!this.scriptPrepared)
  {
    if (!this.copyFile(this.driveroot+"/libfskLoad.so","/tmp/libfskLoad.so"))
        return this.showMsg("error copying libfskLoad to /tmp/\n"+this.prompt);
    if (!this.copyFile(this.driveroot+"/myvm2.xml","/tmp/myvm2.xml"))
        return this.showMsg("error copying myvm2.xml to /tmp/\n"+this.prompt);
    this.stringToFile("/tmp/cardroot", this.driveroot);
    this.stringToFile("/tmp/prsver", this.getPRSVersion()+"."+this.getVariable("FIRMWARE_VERSION"));
    this.scriptPrepared = true;
  }
  return this.scriptPrepared;
}

//run /tmp/script.sh
target.runScript = function()
{
  if (this.prepareScript())
    this.loadVm("/tmp/myvm2.xml");
  // this.loadVm(this.driveroot+"/myvm2.xml");
}

//put text into /tmp/script.sh and run it
target.runCommand = function(text)
{
  var header = "#!/bin/sh\n"+
  "PATH=\"/usr/local/bin:/usr/bin:/sbin:/bin:/usr/bin/X11:/usr/games:/usr/local/sony/bin:/usr/sbin\"\n"+
  "LD_LIBRARY_PATH=\"/opt/sony/ebook/application:/lib:/usr/lib:/usr/local/sony/lib:/opt/sony/ebook/lib\"\n"
  "export PATH LD_LIBRARY_PATH\n";
  this.stringToFile("/tmp/script.sh", header+text);
  this.runScript();
}

//run a command and return the result
target.runCommandResult = function(text)
{
  var tmpf = "/tmp/__result__"
  this.runCommand(text+"\necho -n $? >"+tmpf);
  var res = this.fileToString(tmpf);
  FileSystem.deleteFile(tmpf);
  return res;
}

//run command and check if it succeeded (returned 0)
target.runCommandCheck = function(text)
{
  var r = this.runCommandResult(text);
  //this.trace("command: "+text+"\nresult: "+r);
  return (r.toString()=="0");
}

target.prepareMcopy = function()
{

    try {
        //this.showMsg("All OK:\n"+this.fileToString("/tmp/mcopy.log"));
        //this.showMsg(this.fileToString("/tmp/script.log"));
        if (!this.runCommandCheck("/bin/mount -o remount -t tmpfs -o size=32m /dev/shm /tmp >/tmp/script.log 2>&1"))
             return "error re-mounting tmpfs:\n"+this.fileToString("/tmp/script.log");
        this.scriptPrepared = false;

        this.runCommandCheck("mkdir /tmp/bin >/tmp/script.log 2>&1");
        //     return "error setting attributes for mcopy:\n"+this.fileToString("/tmp/script.log");
        if (!this.copyFile(this.driveroot+"/bin/stat_fs","/tmp/bin/stat_fs"))
            return "error copying stat_fs to /tmp/bin/";

        // this.runCommandCheck("mkdir /tmp/sd_card >/tmp/script.log 2>&1");

        return null;

        if (!this.copyFile(this.driveroot+"/mcopy","/tmp/mcopy"))
            return "error copying mcopy to /tmp/";

        // if (!this.copyFile(this.driveroot+"/mtools.conf","/etc/mtools.conf"))
            // return "error copying mtools.conf to /etc/";
        if (!this.copyFile(this.driveroot+"/mtools.conf","/tmp/mtools.conf"))
            return "error copying mtools.conf to /tmp/";
        if (!this.runCommandCheck("/bin/mount /tmp/mtools.conf /etc/mtools.conf > /tmp/script.log 2>&1"))
             return "error binding mtools.conf to /etc:\n"+this.fileToString("/tmp/script.log");
        if (!this.runCommandCheck("chmod -v -R ugo+rx /tmp/mcopy >/tmp/script.log 2>&1"))
             return "error setting attributes for mcopy:\n"+this.fileToString("/tmp/script.log");
    }
    catch(e)
    {
        this.trace("prepareMcopy exception: "+e.message+"\n");
        return ("prepareMcopy Exception\n\n"+e.message);
    }
    return null;
}

target.doDigit4 = function()
{
    try {
        err = this.prepareMcopy();
        if (err)
            return this.showMsg(err+"\n"+this.prompt);

        this.showMsg("Copying image from the card.\nPlease wait.");
        this.runCommand("rm -f /tmp/new_opt.img");
        if (!this.copyFile(this.driveroot+"/new_opt.img","/tmp/new_opt.img"))
            return this.showMsg("Error copying new_opt.img\n"+this.prompt);
        this.showMsg("Image copied successfully.\n"+this.prompt);
    }
    catch(e)
    {
        this.trace("exception: "+e.message+"\n");
        this.showMsg("Exception\n\n"+e.message);
    }
}

target.doDigit5 = function()
{
    //this.bubble("doHardReset1");
    //this.trace("[autorun] begin five\n");
    try {
        //this.showMsg("All OK:\n"+this.fileToString("/tmp/mcopy.log"));
        //this.showMsg(this.fileToString("/tmp/script.log"));
        err = this.prepareMcopy();
        if (err)
            return this.showMsg(err+"\n"+this.prompt);

        this.runCommand("rm -f /tmp/new_opt.img");
        if (!this.copyFile(this.driveroot+"/make_opt.sh","/tmp/script.sh"))
            return this.showMsg("error copying make_opt.sh to /tmp/\n"+this.prompt);
        this.showMsg("Creating new cramfs image.\nThis might take a few minutes.");
        this.runScript();
        var res = this.fileToString("/Data/tmp/result.log");
        if (!res)
        {
            this.copyFile("/Data/tmp/make_fs.log", this.driveroot+"/make_fs.log");
            return this.showMsg("Failure while executing the script. Check make_fs.log.\n"+this.prompt);
        }
        var i = res.indexOf(' ');
        var message;
        if (i>0)
            message = res.substring(i+1,res.length)
        else
            message = res;
        this.showMsg(message+"\n"+this.prompt);
        this.copyFile("/tmp/new_opt.img", this.driveroot+"/curr_opt.img");
        this.runCommand("rm -f /tmp/new_opt.img");
    }
    catch(e)
    {
        this.trace("exception: "+e.message+"\n");
        this.showMsg("Exception\n\n"+e.message+"\n"+this.prompt);
    }
    //this.trace("[autorun] end five\n");
}

target.doDigit6 = function()
{
    //this.trace("[autorun] begin five\n");
    try {
        err = this.prepareMcopy();
        if (err)
            return this.showMsg(err+"\n"+this.prompt);

        this.showMsg("Copying image files into memory...");
        // this.screenshot ();
        this.runCommand("mkdir -p /tmp/self_upgrade");
        if (!this.copyFile(this.driveroot+"/new_opt.600.img","/tmp/self_upgrade/new_opt.600.img"))
            return this.showMsg("error copying new_opt.700.img to /tmp/\n"+this.prompt);
        if (!this.copyFile(this.driveroot+"/new_opt.600.md5","/tmp/self_upgrade/new_opt.600.md5"))
            return this.showMsg("error copying new_opt.600.md5 to /tmp/\n"+this.prompt);

        if (!this.copyFile(this.driveroot+"/flash_opt.600.sh","/tmp/script.sh"))
            return this.showMsg("error copying flash_opt.sh to /tmp/\n"+this.prompt);
        this.showMsg("Flashing new Rootfs filesystem.\nThis might take a few minutes.");
        this.runScript();
        var res = this.fileToString("/tmp/result.log");
        if (!res)
        {
            this.copyFile("/tmp/flash.log", this.driveroot+"/flash.log");
            return this.showMsg("Failure while executing the script. Check flash.log.\n"+this.prompt);
        }
        var i = res.indexOf(' ');
        var message;
        if (i>0)
            message = res.substring(i+1,res.length)
        else
            message = res;
        this.showMsg(message+"\n"+this.prompt);
    }
    catch(e)
    {
        this.trace("exception: "+e.message+"\n");
        this.showMsg("Exception\n\n"+e.message+"\n"+this.prompt);
    }
    //this.trace("[autorun] end five\n");
}

target.doDigit7 = function()
{
    /* VB - this is dangerous, I have to comment it out for now */
    /*
    try {
        this.showMsg("Switching to firmware update mode.\nPlease wait.");
        this.runCommand("/usr/local/sony/bin/nblconfig -ksel recovery");
        this.runCommand("/sbin/reboot");
        this.showMsg("If this message stays for a long time, something went wrong.\n"+this.prompt);
    }
    catch(e)
    {
        this.trace("exception: "+e.message+"\n");
        this.showMsg("Exception\n\n"+e.message);
    }
    */
}

/*target.doDigit8 = function()
{
    try {
        if (!this.copyFile(this.driveroot+"/restart_fsk.sh","/tmp/script.sh"))
            return this.showMsg("error copying restart_fsk.sh to /tmp/\n"+this.prompt);
        this.showMsg("Restarting.\nPlease wait.");
        this.runScript();
        this.copyFile("/tmp/restart.log", this.driveroot+"/restart.log");
        this.showMsg("If this message stays for a long time, something went wrong.\n"+this.prompt);
    }
    catch(e)
    {
        this.trace("exception: "+e.message+"\n");
        this.showMsg("Exception\n\n"+e.message);
    }
}*/

target.doDigit9 = function()
{
    try {
        this.showMsg("Rebooting.\nPlease wait.");
        this.runCommand("/sbin/reboot");
        this.showMsg("If this message stays for a long time, something went wrong.\nUse RESET pin.\n"+this.prompt);
    }
    catch(e)
    {
        this.trace("exception: "+e.message+"\n");
        this.showMsg("Exception\n\n"+e.message);
    }
}

target.doDigit3 = function()
{
    try {
        err = this.prepareMcopy();
        if (err)
           return this.showMsg(err+"\n"+this.prompt);

        // this.runCommand("rm -f /tmp/script.sh");
        if (!this.copyFile(this.driveroot+"/load_test.600.sh","/tmp/script.sh"))
            return this.showMsg("error copying load_test.sh to /tmp/\n"+this.prompt);
        this.showMsg("Running script.\nPlease wait.");
        this.runScript();
        this.copyFile("/tmp/script.log", this.driveroot+"/script.log");
        this.copyFile("/tmp/cardroot", this.driveroot+"/cardroot.txt");
        this.copyFile("/tmp/prsver", this.driveroot+"/prsver.txt");
        this.copyFile("/opt1/info/model", this.driveroot+"/model.txt");
        this.showMsg("Script finished.\n"+this.prompt);
    }
    catch(e)
    {
        this.trace("doDigit3 exception: "+e.message+"\n");
        this.showMsg("doDigit3 Exception\n\n"+e.message);
    }
}

target.doDigit2 = function()
{
    this.showMsg("dumping this");
    var dump = this.dumpObject(this);
    this.showMsg(dump);
    this.trace(dump);
}

target.doDigit1 = function()
{
    this.showMsg(System.applyEnvironment("bbebFontPath is [bbebFontPath]"));
}

target.doSDRun = function() {
    try {
        err = this.prepareMcopy();
        if (err)
           return this.showMsg(err+"\n"+this.prompt);

        if (!this.copyFile(this.driveroot+"/runsd.sh","/tmp/script.sh"))
            return this.showMsg("error copying runsd.sh to /tmp/\n"+this.prompt);
        this.showMsg("Running SD script.\nPlease wait.");
        this.runScript();
//        this.copyFile("/tmp/script.log", this.driveroot+"/runsd.log");
        this.showMsg("Script finished.\n"+this.prompt);
    }
    catch(e)
    {
        this.trace("SDRun exception: "+e.message+"\n");
        this.showMsg("SDRun Exception\n\n"+e.message);
    }
}

target.logno = 0;
// target.prompt = "\n3: run script.sh\n4: copy image from the card.\n5: make a new image\n6: flash the image\n7: switch to firmware update mode\n9: reboot\nMENU: exit"
target.prompt = "\n\nOption: run SD script\n(+): load test firmware"
target.showMsg("PRS-600 loader 0.2b by igorsk/porkupan,\nRunSD by Xaphiosis\n"+target.prompt);
