#!/bin/sh

PATH="/usr/local/bin:/usr/bin:/sbin:/bin:/usr/bin/X11:/usr/games:/usr/local/sony/bin:/usr/sbin"
LD_LIBRARY_PATH="/opt/sony/ebook/application:/lib:/usr/lib:/usr/local/sony/lib:/opt/sony/ebook/lib"
export PATH LD_LIBRARY_PATH

# basic setup is we're expecting an SD card mounted on /tmp/sd_card
# with a directory of /reader with interesting things inside it, like this
# script
# any output we want to export, we put in /reader_out on the sd card so as to
# not make a mess in the source dir
SD_CARD=/tmp/sd_card
SD=$SD_CARD/reader
OUT=$SD_CARD/reader_out
export OUT SD

# working directory
WD=$SD
LOG=$OUT/main.log
export WD LOG

mkdir -p $OUT
echo main.sh begins > $LOG
#-------------------------
#echo Running diagnostics.sh >> $LOG
#$WD/diagnostics.sh 2>&1 >> $LOG

echo Running g_serial tests
$WD/g_serial.sh 2>&1 >> $LOG
#-------------------------
echo main.sh ends >> $LOG
# Make a copy of the log
cp $LOG $OUT/main.log
# Clean up
rm -rf $WD

sync
return 0

