#!/bin/sh

echo Modules:
/sbin/lsmod
echo

echo Removing g_file_storage g_serial g_ether
/sbin/rmmod g_file_storage
/sbin/rmmod g_serial
/sbin/rmmod g_ether
echo

echo Modules:
/sbin/lsmod
echo

echo Installing g_serial
/sbin/insmod -f $WD/g_serial.ko use_acm=1
echo

echo Modules:
/sbin/lsmod
echo

echo Obtaining dmesg
/bin/dmesg 2>&1 > $OUT/dmesg

# Hopefully g_serial is loaded now, so let's proceed under that assumption
# XXX: it would be better to check

sleep 20
/bin/mknod /dev/ttygserial c 127 0
# run getty shell as daemon, so if we kill tinyhttp etc from there, it won't die
nohup /sbin/getty -n -l /bin/sh 115200 ttygserial vt102 &

# XXX: no idea what the best way is to kill tinyhttp yet, so let's just go to
#      sleep for a long while. To resume, kill sleep in the shell, then exit
sleep 1d
# sleep a bit longer to give the shell time to exit after killing previous sleep
sleep 2

# Try to restore original context, at least enough to get back to home screen

sync

echo Removing g_serial
/sbin/rmmod g_serial

echo Re-installing g_file_storage
if [ -r /opt1/keys/data ]; then
    ID=`/usr/local/sony/bin/deviceid`
    VENDOR=`/usr/local/sony/bin/deviceid | tail -c 11`
else
    ID=0000000000000000
    VENDOR=0000000000
fi
NUM1=`grep "\"Data\"" /proc/mtd | awk -F: '{print $1}' | awk -Fd '{print$2}'`
NUM2=`grep "\"Data2\"" /proc/mtd | awk -F: '{print $1}' | awk -Fd '{print$2}'`
if [ X$NUM1 != X -a X$NUM2 != X ] ; then
    insmod /lib/modules/2.6.23/kernel/drivers/usb/gadget/g_file_storage.ko file=/dev/mtdblock$NUM1,/dev/sdmscard/sdmsb,/dev/sdmscard/sdmsa,/dev/mtdblock$NUM2 ProductID=PRS-600 VendorSpecific=$VENDOR sn_select=0 iSerialNumber=$ID ro=0,0,0,1
else
        insmod /lib/modules/2.6.23/kernel/drivers/usb/gadget/g_file_storage.ko file=/dev/sdmscard/sdmsb,/dev/sdmscard/sdmsa ProductID=PRS-600 VendorSpecific=$VENDOR sn_select=0 iSerialNumber=$ID
fi

echo
echo Modules:
/sbin/lsmod

