#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2008, Kovid Goyal <kovid at kovidgoyal.net>'
'''
bbc.co.uk
'''

from calibre.web.feeds.news import BasicNewsRecipe

class BBC(BasicNewsRecipe):
    title          = u'The Onion AV Club'
    __author__     = 'Stephen Williams'
    description    = 'Film, Television and Music Reviews'
    no_stylesheets = True
    oldest_article        = 2    
    max_articles_per_feed = 100

    keep_only_tags     = [dict(name='div', attrs={'id':'content'})
                          ]

    remove_tags    = [dict(name='div', attrs={'class':['footer','tools_horizontal']}),
                      dict(name='div', attrs={'id':['tool_holder','elsewhere_on_avclub']})
                      ]
    extra_css      = '.headline {font-size: x-large;} \n .fact { padding-top: 10pt  }' 

    feeds          = [
                      ('Interviews', 'http://www.avclub.com/feed/interview/'), 
                      ('AV Club Daily', 'http://www.avclub.com/feed/daily'),
                      ('Film', 'http://www.avclub.com/feed/film/'),
                      ('Music', 'http://www.avclub.com/feed/music/'),
                      ('DVD', 'http://www.avclub.com/feed/dvd/'),
                      ('Books', 'http://www.avclub.com/feed/books/'),
                      ('Games', 'http://www.avclub.com/feed/games/'),
                      ('Interviews', 'http://www.avclub.com/feed/interview/'),
                    ]
