/***-----
|
|	eio.c
|
|	expanded input output functions
|
|	for Flash
|
|	based on stdlib & stdio functions, rather than
|	win32 functions
|
|	eio_loadfile: loads an entire text file from disk,
|	allocating a buffer as it goes. returns a pointer
|	to the buffer, and fills a given int with the file
|	length.
|
|		sample use:
|		===========
|		int len;
|		char *bfr;
|		bfr = eio_loadfile ("myfile.txt", &len);
|		puts (bfr);
|		free (bfr);
|
|	eio_fputns: put n characters of string out to file.
|
|		sample use:
|		===========
|		eio_fputs ("hello there", 5, stdout);
|		...output would be: hello
|
|
-----***/


/*** preprocessor commands ----------------------------------***/

#include		<stdlib.h>
#include		<stdio.h>
#include		<string.h>
#include		"../bfr/bfr.h"

#define		OK		1
#define		ERROR	0


/*** global variables ---------------------------------------***/

/*** function prototypes ------------------------------------***/

char		*	eio_loadfile	(char *filename, int *length);
int			eio_savefile	(char *filename, char *bfr);
void			eio_fputns	(char *str, int max, FILE *fp);


/*** program functions --------------------------------------***/

/*>>>_____ FUNCTION: eio_loadfile _____ */

	/***-----
	|
	|	load a file, allocating
	|	buffer as load, filling
	|	given int with file length
	|
	-----***/

char *eio_loadfile (char *filename, int *filelength)
{
	FILE *fp;
	char *filebuffer, chbfr;

	if (! (fp = fopen (filename, "r")))
		return NULL;
	bfr_init ();
	while ((chbfr = fgetc (fp)) != EOF)
		if (! bfr_addch (chbfr))
		{
			fclose (fp);
			*filelength = 0;

			return NULL;
		}
	fclose (fp);
	filebuffer = bfr_retrieve ();
	*filelength = _bfr_finallength;

	return filebuffer;
}


/*>>>_____ FUNCTION: eio_savefile _____ */

	/***-----
	|
	|	save a text buffer with a
	|	given filename... pass NULL
	|	instead of a text buffer to
	|	create an empty file (works
	|	the same as if the first
	|	char of the buffer were
	|	'\0')
	|
	-----***/

int eio_savefile (char *filename, char *bfr)
{
	FILE *fp;

	if (! (fp = fopen (filename, "w")))
		return ERROR;
	if (bfr)
		while (*bfr)
			if (fputc (*bfr ++, fp) == EOF)
				break;
	fclose (fp);

	return OK;
}


/*>>>_____ FUNCTION: eio_fputns _____ */

	/***-----
	|
	|	works like fputs, but
	|	only outputs n chars
	|	and returns void
	|
	-----***/

void eio_fputns (char *str, int max, FILE *fp)
{
	while (*str && (max -- > 0))
		putc (*str ++, fp);
	return;
}

