/***-----
|
|	bfr.c
|
|	textbuffer management
|
|	for Flash
|	part of rtci
|
|	Creates a buffer, allocates memory as
|	needed, and fills buffer with text. If
|	a bfr_add function returns ERROR, it
|	means there's been a memory allocation
|	error. No need to free the buffer
|	allocated so far, the allocation
|	function will do that automatically.
|
|
-----***/


/*** preprocessor commands ----------------------------------***/

#include			<stdlib.h>

#define			DEFAULT_MEMCHUNK	1000
#define			OK				1
#define			ERROR			0


/*** global variables ---------------------------------------***/

int				_bfr_memchunk;
int				_bfr_finallength;
static char	*	buffer;
static int		idx;
static int		mem_allocated;


/*** function prototypes ------------------------------------***/

void				bfr_init		();
int				bfr_addstr	(char *str);
int				bfr_addch		(char c);
char			*	bfr_retrieve	();
char			*	bfr_alloc		();
char			*	bfr_fit		();


/*** program functions --------------------------------------***/

/*>>>_____ FUNCTION: bfr_init _____ */

	/***-----
	|
	|	reset global variables
	|
	-----***/

void bfr_init ()
{
	mem_allocated = 0;
	buffer = NULL;
	idx = 0;
	_bfr_finallength = 0;
	_bfr_memchunk = DEFAULT_MEMCHUNK;
	return;
}


/*>>>_____ FUNCTION: bfr_addstr _____ */

	/***-----
	|
	|	add a string to buffer
	|
	-----***/

int bfr_addstr (char *str)
{
	while (*str)
	{
		if (idx + 1 > mem_allocated)
			if (! bfr_alloc ())
				return ERROR;
		buffer [idx ++] = *str ++;
	}

	return OK;
}


/*>>>_____ FUNCTION: bfr_addch _____ */

	/***-----
	|
	|	add a single char to
	|	buffer
	|
	-----***/

int bfr_addch (char c)
{
	if (idx + 1 > mem_allocated)
		if (! bfr_alloc ())
			return ERROR;
	buffer [idx ++] = c;

	return OK;
}


/*>>>_____ FUNCTION: bfr_retrieve _____ */

	/***-----
	|
	|	nul terminate the buffer,
	|	setting _bfr_finallength
	|	to the correct length, then
	|	set idx to the char
	|	before the nul in case
	|	the calling program attempts
	|	to add more to the buffer
	|	later
	|
	-----***/

char *bfr_retrieve ()
{
	if (! bfr_addch ('\0'))
		return ERROR;
	bfr_fit ();
	_bfr_finallength = -- idx;

	return buffer;
}


/*>>>_____ FUNCTION: bfr_alloc _____ */

	/***-----
	|
	|	internal function
	|	create or expand a text
	|	buffer in _bfr_memchunk
	|	increments
	|
	-----***/

char *bfr_alloc ()
{
	char *newspace;
	
	newspace = realloc (buffer,
		mem_allocated + _bfr_memchunk);
	if (! newspace)
		free (buffer);
	buffer = newspace;
	mem_allocated += _bfr_memchunk;

	return buffer;
}


/*>>>_____ FUNCTION: bfr_fit () _____ */

	/***-----
	|
	|	shrink an allocation
	|	to fit real current
	|	buffer size
	|
	-----***/

char *bfr_fit ()
{
	char *newspace;
	int fitsize = idx + 1;
	
	newspace = realloc (buffer, fitsize);
	if (! newspace)
		free (buffer);
	buffer = newspace;
	mem_allocated = fitsize;

	return buffer;
}

