/*
 * Decompiled with CFR 0.152.
 */
package manga;

import common.utils.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.zip.ZipOutputStream;

public class EpubMaker {
    private static String default_loc = "/manga/epub/";
    private static String default_mimetype_filename = "mimetype";
    private static String default_container_filename = "container.xml";
    private static String default_pagetemplate_filename = "page-template.xpgt";
    private static String default_stylesheet_filename = "stylesheet.css";
    private String title = null;
    private File epub_file = null;
    private File manga_folder = null;
    private File tmp_folder = null;
    private String uuid = null;
    File metainf_folder = null;
    File oebps_folder = null;
    File images_folder = null;

    public EpubMaker(String n_title, File n_epub_file, File n_manga_folder) {
        this.title = n_title;
        this.epub_file = n_epub_file;
        this.manga_folder = n_manga_folder;
        this.tmp_folder = new File(String.valueOf(this.epub_file.getAbsolutePath()) + "_tmp" + File.separatorChar);
        this.metainf_folder = new File(String.valueOf(this.tmp_folder.getAbsolutePath()) + File.separatorChar + "META-INF");
        this.oebps_folder = new File(String.valueOf(this.tmp_folder.getAbsolutePath()) + File.separatorChar + "OEBPS");
        this.images_folder = new File(String.valueOf(this.oebps_folder.getAbsolutePath()) + File.separatorChar + "images");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        this.uuid = "canti" + sdf.format(date);
    }

    public void makeEpub() {
        if (this.title == null || this.epub_file == null || this.manga_folder == null) {
            return;
        }
        this.setupEpub();
        this.copyMangaImages();
        this.createXhtml();
        this.createContent();
        this.createToc();
        this.finalizeEpub();
    }

    private void copyMangaImages() {
        ArrayList<File> image_files = FileUtils.getImageFileList(this.manga_folder);
        try {
            int i = 0;
            while (i < image_files.size()) {
                File cur_image = image_files.get(i);
                FileUtils.copyFile(cur_image, new File(String.valueOf(this.images_folder.getAbsolutePath()) + File.separatorChar + cur_image.getName()));
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createXhtml() {
        ArrayList<File> image_files = FileUtils.getImageFileList(this.images_folder);
        Collections.sort(image_files);
        File xhtml_file = new File(String.valueOf(this.oebps_folder.getAbsolutePath()) + File.separatorChar + this.manga_folder.getName() + ".xhtml");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(xhtml_file));
            bw.write("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n");
            bw.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n");
            bw.write("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
            bw.write("<head>\n");
            bw.write("  <title>" + this.manga_folder.getName() + "</title>\n");
            bw.write("  <link href=\"stylesheet.css\" type=\"text/css\" rel=\"stylesheet\" />\n");
            bw.write("  <link rel=\"stylesheet\" type=\"application/vnd.adobe-page-template+xml\" href=\"page-template.xpgt\"/>\n");
            bw.write("</head>\n");
            bw.write("<body>\n\n");
            int i = 0;
            while (i < image_files.size()) {
                bw.write("<img src=\"images/" + image_files.get(i).getName() + "\"/>\n");
                ++i;
            }
            bw.write("\n</body>\n");
            bw.write("</html>");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createContent() {
        File content_file = new File(String.valueOf(this.oebps_folder.getAbsolutePath()) + File.separatorChar + "content.opf");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(content_file));
            bw.write("<?xml version=\"1.0\"?>\n");
            bw.write("<package version=\"2.0\" xmlns=\"http://www.idpf.org/2007/opf\"\n");
            bw.write("         unique-identifier=\"BookId\">\n");
            bw.write(" <metadata xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n");
            bw.write("           xmlns:opf=\"http://www.idpf.org/2007/opf\">\n");
            bw.write("   <dc:title>" + this.manga_folder.getName() + "</dc:title>\n");
            bw.write("   <dc:creator opf:role=\"aut\">Canti</dc:creator>\n");
            bw.write("   <dc:language>en-US</dc:language>\n");
            bw.write("   <dc:rights>Public Domain</dc:rights>\n");
            bw.write("   <dc:publisher>Canti</dc:publisher>\n");
            bw.write("   <dc:identifier id=\"BookId\">urn:uuid:" + this.uuid + "</dc:identifier>\n");
            bw.write(" </metadata>\n");
            bw.write(" <manifest>\n");
            bw.write("  <item id=\"ncx\" href=\"toc.ncx\" media-type=\"text/xml\" />\n");
            bw.write("  <item id=\"style\" href=\"stylesheet.css\" media-type=\"text/css\" />\n");
            bw.write("  <item id=\"pagetemplate\" href=\"page-template.xpgt\" media-type=\"application/vnd.adobe-page-template+xml\" />\n");
            bw.write("  <item id=\"" + this.manga_folder.getName() + "\" href=\"" + this.manga_folder.getName() + ".xhtml\" media-type=\"application/xhtml+xml\" />\n");
            bw.write(" </manifest>\n");
            bw.write(" <spine toc=\"ncx\">\n");
            bw.write("  <itemref idref=\"" + this.manga_folder.getName() + "\" />\n");
            bw.write(" </spine>\n");
            bw.write("</package>\n");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createToc() {
        File toc_file = new File(String.valueOf(this.oebps_folder.getAbsolutePath()) + File.separatorChar + "toc.ncx");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(toc_file));
            bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            bw.write("<ncx xmlns=\"http://www.daisy.org/z3986/2005/ncx/\" version=\"2005-1\">\n");
            bw.write("  <head>\n");
            bw.write("    <meta name=\"dtb:uid\" content=\"" + this.uuid + "\"/>\n");
            bw.write("    <meta name=\"dtb:depth\" content=\"1\"/>\n");
            bw.write("    <meta name=\"dtb:totalPageCount\" content=\"0\"/>\n");
            bw.write("    <meta name=\"dtb:maxPageNumber\" content=\"0\"/>\n");
            bw.write("  </head>\n");
            bw.write("  <docTitle>\n");
            bw.write("    <text>" + this.manga_folder.getName() + "</text>\n");
            bw.write("  </docTitle>\n");
            bw.write("  <navMap>\n");
            bw.write("    <navPoint id=\"" + this.manga_folder.getName() + "\" playOrder=\"1\">\n");
            bw.write("      <navLabel>\n");
            bw.write("        <text>" + this.manga_folder.getName() + "</text>\n");
            bw.write("      </navLabel>\n");
            bw.write("      <content src=\"" + this.manga_folder.getName() + ".xhtml\"/>\n");
            bw.write("    </navPoint>\n");
            bw.write("  </navMap>\n");
            bw.write("</ncx>");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setupEpub() {
        if (this.tmp_folder.exists()) {
            FileUtils.deleteDirectory(this.tmp_folder);
        }
        this.tmp_folder.mkdir();
        this.metainf_folder.mkdir();
        this.oebps_folder.mkdir();
        this.images_folder.mkdir();
        this.copyJarFile(String.valueOf(default_loc) + default_mimetype_filename, new File(String.valueOf(this.tmp_folder.getAbsolutePath()) + File.separatorChar + default_mimetype_filename));
        this.copyJarFile(String.valueOf(default_loc) + default_container_filename, new File(String.valueOf(this.metainf_folder.getAbsolutePath()) + File.separatorChar + default_container_filename));
        this.copyJarFile(String.valueOf(default_loc) + default_pagetemplate_filename, new File(String.valueOf(this.oebps_folder.getAbsolutePath()) + File.separatorChar + default_pagetemplate_filename));
        this.copyJarFile(String.valueOf(default_loc) + default_stylesheet_filename, new File(String.valueOf(this.oebps_folder.getAbsolutePath()) + File.separatorChar + default_stylesheet_filename));
    }

    private void finalizeEpub() {
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(this.epub_file));
            FileUtils.zipFolderRecursive(this.tmp_folder.getAbsolutePath(), this.tmp_folder.getAbsolutePath(), zos);
            zos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileUtils.deleteDirectory(this.tmp_folder);
    }

    private void copyJarFile(String source_filename, File dest) {
        try {
            int length;
            InputStream is = this.getClass().getResourceAsStream(source_filename);
            FileOutputStream os = new FileOutputStream(dest);
            byte[] buffer = new byte[4096];
            while ((length = is.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
            ((OutputStream)os).close();
            is.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

